/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.RLImages;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.PublicationBO;
import com.sybase.aseplugin.bo.ReplicationBO;
import com.sybase.aseplugin.bo.SubscriptionBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.ConnectionProp;
import com.sybase.aseplugin.bo.wiz.PublicationWizard;
import com.sybase.aseplugin.bo.wiz.SubscriptionWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.ConnectionSO;
import com.sybase.aseplugin.so.PublicationSO;
import com.sybase.aseplugin.so.SubscriptionSO;
import com.sybase.aseplugin.util.Debug;
import com.sybase.aseplugin.util.RLStatusMonitor;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class ConnectionBO
extends ASEBaseContainer2 {
    private ConnectionSO _connSO;
    public static final int CONN_NAME = 1;
    public static final int CONN_TYPE = 2;
    public static final int CONN_STATUS = 3;
    private static final int CMD_RESUME = 3001;
    private static final int CMD_SUSPEND = 3002;
    private static final int NEW_PUBLICATION = 3003;
    private static final int NEW_SUBSCRIPTION = 3004;
    public static final ImageIcon PRIMARY_CONNECTION_UP_ICON = new ImageIcon(RLImages.getPConnUpSmallImage());
    public static final ImageIcon REPLICATE_CONNECTION_UP_ICON = new ImageIcon(RLImages.getRConnUpSmallImage());
    public static final ImageIcon PRIMARY_CONNECTION_DOWN_ICON = new ImageIcon(RLImages.getPConnDownSmallImage());
    public static final ImageIcon REPLICATE_CONNECTION_DOWN_ICON = new ImageIcon(RLImages.getRConnDownSmallImage());
    public static final ImageIcon NEW_CONNECTION_ICON = new ImageIcon(RLImages.getNewRepConnectionImage());

    ConnectionBO(ReplicationBO replicationBO, ConnectionSO connectionSO) {
        super(connectionSO.getLongName(), (ASEBaseContainer2)replicationBO, connectionSO);
        this._connSO = connectionSO;
        RLStatusMonitor rLStatusMonitor = ((ReplicationBO)this.getParent()).getRLStatusMonitor();
        if (rLStatusMonitor != null) {
            rLStatusMonitor.register(this);
        }
    }

    public ConnectionSO getConnSO() {
        Debug.wassert(this._connSO != null, this, "Null ConnectionSO attribute");
        return this._connSO;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 96;
    }

    @Override
    public int getAttributes() {
        return 1;
    }

    public String getDDB() {
        return ((ConnectionSO)this.getSO()).getDDB();
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        ASEMenuItem aSEMenuItem = ((ConnectionSO)this.getSO()).isPrimary() ? new ASEMenuItem(3003, ASEUtils.getString("MSG_ADD_PUBLICATION"), ASEUtils.getString("MSG_ADD_PUBLICATION"), Support.getMnemonic("CREA_MNEM"), PublicationBO.PUBLICATION_ICON) : new ASEMenuItem(3004, ASEUtils.getString("MSG_ADD_SUBSCRIPTION"), ASEUtils.getString("MSG_ADD_SUBSCRIPTION"), Support.getMnemonic("CREA_MNEM"), SubscriptionBO.SUBSCRIPTION_UP_ICON);
        return new ASEMenuItem[]{aSEMenuItem};
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        ASEToolBarButton aSEToolBarButton = ((ConnectionSO)this.getSO()).isPrimary() ? new ASEToolBarButton(3003, PublicationBO.NEW_PUBLICATION_ICON, ASEUtils.getString("MSG_ADD_PUBLICATION"), ASEUtils.getString("MSG_ADD_PUBLICATION")) : new ASEToolBarButton(3004, SubscriptionBO.NEW_SUBSCRIPTION_ICON, ASEUtils.getString("MSG_ADD_SUBSCRIPTION"), ASEUtils.getString("MSG_ADD_SUBSCRIPTION"));
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public Vector getItems(int n) throws SQLException {
        Vector<ASEBaseContainer2> vector = new Vector<ASEBaseContainer2>();
        if (((ConnectionSO)this.getSO()).isPrimary()) {
            Enumeration enumeration = PublicationSO.getPublications(this.getConnection(), this.getDDB(), ((ConnectionSO)this.getSO()).getServer(), ((ConnectionSO)this.getSO()).getDatabase());
            while (enumeration.hasMoreElements()) {
                vector.addElement(new PublicationBO(this, (PublicationSO)enumeration.nextElement()));
            }
        } else {
            Enumeration enumeration = SubscriptionSO.getSubscriptions(this.getConnection(), this.getDDB(), ((ConnectionSO)this.getSO()).getServer(), ((ConnectionSO)this.getSO()).getDatabase(), (ConnectionSO)this.getSO());
            while (enumeration.hasMoreElements()) {
                vector.addElement(new SubscriptionBO(this, (SubscriptionSO)enumeration.nextElement()));
            }
        }
        return vector;
    }

    @Override
    public Icon getImage(boolean bl) {
        ImageIcon imageIcon = null;
        switch (((ConnectionSO)this.getSO()).getState()) {
            case 1: {
                if (((ConnectionSO)this.getSO()).isPrimary()) {
                    imageIcon = PRIMARY_CONNECTION_UP_ICON;
                    break;
                }
                imageIcon = REPLICATE_CONNECTION_UP_ICON;
                break;
            }
            case -1: 
            case 0: 
            case 3: {
                if (((ConnectionSO)this.getSO()).isPrimary()) {
                    imageIcon = PRIMARY_CONNECTION_DOWN_ICON;
                    break;
                }
                imageIcon = REPLICATE_CONNECTION_DOWN_ICON;
                break;
            }
            default: {
                Debug.wassert(false, this, "Invalid Connection State");
            }
        }
        return imageIcon;
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return this.getSO().getDisplayName();
            }
            case 2: {
                return ((ConnectionSO)this.getSO()).getTypeString();
            }
            case 3: {
                return ((ConnectionSO)this.getSO()).getReasonCode();
            }
        }
        return "";
    }

    @Override
    public SCMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ASEMenu();
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3001, ASEUtils.getString("CONTEXT_MENU_RESUME_TEXT"), ASEUtils.getString("CONTEXT_MENU_RESUME_HINT"), Support.getMnemonic("ACTN_MNEM_RESUME")));
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3002, ASEUtils.getString("CONTEXT_MENU_SUSPEND_TEXT"), ASEUtils.getString("CONTEXT_MENU_SUSPEND_HINT"), Support.getMnemonic("ACTN_MNEM_SUSPEND")));
            this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        }
        return this._contextMenu;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return true;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 107: {
                ConnectionProp connectionProp = new ConnectionProp((ConnectionSO)this.getSO(), (SCContainer2)this.getParent(), jFrame);
                ASEBaseDialog2.showDialog(jFrame, connectionProp);
                break;
            }
            case 106: {
                int n3 = Support.showQuestionYesNo(jFrame, ASEUtils.getString("MSG_DELETE_OBJECT_QUESTION"));
                if (n3 != 0) break;
                Support.getViewerSupport().startWait();
                while (enumeration.hasMoreElements()) {
                    try {
                        ConnectionBO connectionBO = (ConnectionBO)enumeration.nextElement();
                        connectionBO.getSO().remove();
                    }
                    catch (SQLException sQLException) {
                        Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                    }
                }
                Support.getViewerSupport().endWait();
                ((ReplicationBO)this.getParent()).refresh();
                break;
            }
            case 3001: {
                int n4;
                Object object;
                Vector<String> vector = new Vector<String>();
                while (enumeration.hasMoreElements()) {
                    object = (ConnectionBO)enumeration.nextElement();
                    vector.add(((ConnectionSO)((ASEBaseItem2)object).getSO()).resume());
                }
                if (vector.size() <= 0 || (n4 = Support.showQuestionYesNo(jFrame, (String)(object = ASEUtils.getString("MSG_RESUME_CONN_CONFIRM")))) != 0) break;
                Support.getViewerSupport().startWait();
                try {
                    this.execute(vector);
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                }
                ((ReplicationBO)this.getParent()).refresh();
                Support.getViewerSupport().endWait();
                break;
            }
            case 3002: {
                int n5;
                Object object;
                Vector<String> vector = new Vector<String>();
                while (enumeration.hasMoreElements()) {
                    object = (ConnectionBO)enumeration.nextElement();
                    vector.add(((ConnectionSO)((ASEBaseItem2)object).getSO()).suspend());
                }
                if (vector.size() <= 0 || (n5 = Support.showQuestionYesNo(jFrame, (String)(object = ASEUtils.getString("MSG_SUSPEND_CONN_CONFIRM")))) != 0) break;
                Support.getViewerSupport().startWait();
                try {
                    this.execute(vector);
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                }
                ((ReplicationBO)this.getParent()).refresh();
                Support.getViewerSupport().endWait();
                break;
            }
            case 3003: {
                PublicationSO publicationSO = new PublicationSO(this.getConnection(), this.getDDB());
                PublicationWizard publicationWizard = new PublicationWizard(publicationSO, (SCContainer2)this.getParent());
                ASEBaseDialog2.showDialog(jFrame, publicationWizard);
                break;
            }
            case 3004: {
                SubscriptionSO subscriptionSO = new SubscriptionSO(this.getConnection(), this.getDDB(), (ConnectionSO)this.getSO());
                SubscriptionWizard subscriptionWizard = new SubscriptionWizard(subscriptionSO, (SCContainer2)this.getParent(), this);
                SubscriptionWizard.myshowDialog(jFrame, subscriptionWizard);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Vector vector) throws SQLException {
        SQLException sQLException = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                this.getConnection().executeCommand(string);
            }
            catch (SQLException sQLException2) {
                if (sQLException == null) {
                    sQLException = sQLException2;
                    continue;
                }
                sQLException.setNextException(sQLException2);
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        if (((ConnectionSO)this.getSO()).isPrimary()) {
            return new ASEBaseHeader[]{new ASEBaseHeader(ASEUtils.getString("DISP_PUB_HDR"), 0, 170)};
        }
        return new ASEBaseHeader[]{new ASEBaseHeader(ASEUtils.getString("DISP_SUB_HDR"), 0, 170), new ASEBaseHeader(ASEUtils.getString("DISP_REASON_HDR"), 1, 200)};
    }
}

