/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.ProfileHelper;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDBContainer;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DBsCtrBO;
import com.sybase.aseplugin.bo.DatabaseDevicesCtrBO;
import com.sybase.aseplugin.bo.DefaultBO;
import com.sybase.aseplugin.bo.DefaultsCtrBO;
import com.sybase.aseplugin.bo.ESPBO;
import com.sybase.aseplugin.bo.ESPsCtrBO;
import com.sybase.aseplugin.bo.EncryptionKeyBO;
import com.sybase.aseplugin.bo.EncryptionKeysCtrBO;
import com.sybase.aseplugin.bo.FunctionBO;
import com.sybase.aseplugin.bo.FunctionsCtrBO;
import com.sybase.aseplugin.bo.GroupBO;
import com.sybase.aseplugin.bo.GroupsCtrBO;
import com.sybase.aseplugin.bo.JavaJarBO;
import com.sybase.aseplugin.bo.JavaObjectsCtrBO;
import com.sybase.aseplugin.bo.ProceduresCtrBO;
import com.sybase.aseplugin.bo.ProxyTablesCtrBO;
import com.sybase.aseplugin.bo.RuleBO;
import com.sybase.aseplugin.bo.RulesCtrBO;
import com.sybase.aseplugin.bo.SDCInstanceBO;
import com.sybase.aseplugin.bo.SQLJFunctionBO;
import com.sybase.aseplugin.bo.SQLJProcedureBO;
import com.sybase.aseplugin.bo.SegmentBO;
import com.sybase.aseplugin.bo.SegmentsCtrBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.StoredProcedureBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.SybDDLGenerator;
import com.sybase.aseplugin.bo.SystemTablesCtrBO;
import com.sybase.aseplugin.bo.TableBO;
import com.sybase.aseplugin.bo.TableFunctionBO;
import com.sybase.aseplugin.bo.TempDBsCtrBO;
import com.sybase.aseplugin.bo.TempDBsListCtrBO;
import com.sybase.aseplugin.bo.UserBO;
import com.sybase.aseplugin.bo.UserDefinedWebServicesCtrBO;
import com.sybase.aseplugin.bo.UserTablesCtrBO;
import com.sybase.aseplugin.bo.UserTypeBO;
import com.sybase.aseplugin.bo.UserTypesCtrBO;
import com.sybase.aseplugin.bo.UsersCtrBO;
import com.sybase.aseplugin.bo.ViewBO;
import com.sybase.aseplugin.bo.ViewsCtrBO;
import com.sybase.aseplugin.bo.dlg.DDLObjectFilterDialog;
import com.sybase.aseplugin.bo.dlg.DatabaseQuiesceReleaseDialog;
import com.sybase.aseplugin.bo.dlg.EncryptionPasswordDialog;
import com.sybase.aseplugin.bo.dlg.ItemsConfirmDialog;
import com.sybase.aseplugin.bo.dlg.TempDBSessionDialog;
import com.sybase.aseplugin.bo.prop.ArchiveDBProperties;
import com.sybase.aseplugin.bo.prop.DatabaseProperties;
import com.sybase.aseplugin.bo.wiz.BackupWizard;
import com.sybase.aseplugin.bo.wiz.DBCCWizard;
import com.sybase.aseplugin.bo.wiz.DatabaseQuiesceHoldWizard;
import com.sybase.aseplugin.bo.wiz.DatabaseUnmountWizard;
import com.sybase.aseplugin.bo.wiz.RestoreWizard;
import com.sybase.aseplugin.bo.wiz.UpdateStatWizard;
import com.sybase.aseplugin.so.ArchiveDBSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.so.TempDBSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import sybase.isql.ISQLImages;

public class DatabaseBO
extends ASEBaseContainer2 {
    public static final ImageIcon LOCAL_DATABASE_ICON = new ImageIcon(ASEImages.getDatabaseSmallImage());
    public static final ImageIcon PROXY_DATABASE_ICON = new ImageIcon(ASEImages.getProxyDatabaseSmallImage());
    public static final ImageIcon FOR_LOAD_DATABASE_ICON = new ImageIcon(ASEImages.getDatabaseForLoadSmallImage());
    public static final ImageIcon SUSPECT_DATABASE_ICON = new ImageIcon(ASEImages.getDatabaseSuspectSmallImage());
    public static final ImageIcon TEMP_DATABASE_ICON = new ImageIcon(ASEImages.getDatabaseTempSmallImage());
    public static final ImageIcon NEW_TEMP_DATABASE_ICON = new ImageIcon(ASEImages.getNewTempDBImage());
    public static final ImageIcon OFFLINE_DATABASE_ICON = new ImageIcon(ASEImages.getDatabaseWarnSmallImage());
    public static final ImageIcon NEW_DATABASE_ICON = new ImageIcon(ASEImages.getNewDatabaseImage());
    public static final ImageIcon MOUNT_DATABASE_ICON = new ImageIcon(ASEImages.getMountDatabaseImage());
    static final int COL_NAME = 0;
    static final int COL_OWNER = 1;
    static final int COL_SIZE = 2;
    static final int COL_CREATION_DATE = 3;
    static final int COL_SDC_INSTANCE_NAME = 4;
    private static final int CMD_BACKUP_DATABASE = 3001;
    private static final int CMD_RESTORE_DATABASE = 3002;
    private static final int CMD_UNMOUNT_DATABASE = 3003;
    private static final int CMD_QUIESCE_DATABASE_HOLD = 3004;
    private static final int CMD_QUIESCE_DATABASE_RELEASE = 3005;
    private static final int CMD_CHECK_CONSISTENCY = 3006;
    private static final int CMD_GENERATE_CREATE_DDL = 3007;
    private static final int CMD_GENERATE_OBJECTS_DDL = 3008;
    private static final int CMD_ACTIVE_SESSIONS = 3009;
    private static final int CMD_ONLINE_DATABASE = 3010;
    private static final int CMD_CHECKPOINT = 3011;
    private static final int CMD_REALLOCATE_SPACE = 3012;
    private static final int CMD_OPEN_DBISQL = 3013;
    private static final int CMD_RECREATE_DATABASE_WITH_TEMPLATE = 3014;
    public static final int CMD_NEW_DEFAULT = 3061;
    public static final int CMD_NEW_ESP = 3062;
    public static final int CMD_NEW_GROUP = 3063;
    public static final int CMD_NEW_JAR = 3064;
    public static final int CMD_NEW_PROXY_TABLE = 3065;
    public static final int CMD_NEW_RULE = 3066;
    public static final int CMD_NEW_SEGMENT = 3067;
    public static final int CMD_NEW_SQLJ_FUNCTION = 3068;
    public static final int CMD_NEW_SQLJ_PROCEDURE = 3069;
    public static final int CMD_NEW_STORED_PROCEDURE = 3070;
    public static final int CMD_NEW_USER = 3071;
    public static final int CMD_NEW_TABLE = 3072;
    public static final int CMD_NEW_UDT = 3073;
    public static final int CMD_NEW_VIEW = 3074;
    private static final int CMD_ENCRYPTION_PASSWORD_NEW = 3075;
    private static final int CMD_ENCRYPTION_PASSWORD_ALTER = 3076;
    private static final int CMD_ENCRYPTION_PASSWORD_DELETE = 3077;
    public static final int CMD_NEW_SCALAR_FUNCTION = 3078;
    public static final int CMD_NEW_TABLE_FUNCTION = 3079;
    public static final int CMD_NEW_ECRYPTION_KEY = 3080;
    public static final int CMD_NEW_KEY_COPY = 3081;
    public static final int CMD_NEW_UDWS = 3082;
    public static final int CMD_NEW_WS_ALIAS = 3083;
    public static final int CMD_NEW_WS = 3084;
    private DefaultsCtrBO _defaultsCtrBO;
    private ESPsCtrBO _espsCtrBO;
    private GroupsCtrBO _groupsCtrBO;
    private JavaObjectsCtrBO _javaObjectsCtrBO = null;
    private ProxyTablesCtrBO _proxyTablesCtrBO = null;
    private RulesCtrBO _rulesCtrBO;
    private SegmentsCtrBO _segmentsCtrBO;
    private FunctionsCtrBO _functionsCtrBO = null;
    private ProceduresCtrBO _proceduresCtrBO;
    private UsersCtrBO _usersCtrBO;
    private UserTablesCtrBO _userTablesCtrBO;
    private UserTypesCtrBO _userTypesCtrBO;
    private ViewsCtrBO _viewsCtrBO;
    private UserDefinedWebServicesCtrBO _udwsCtrBO;
    private EncryptionKeysCtrBO _encyrptionKeysCtrBO;
    private boolean _hasScalarFunction;
    private boolean _hasTableFunction;
    private boolean _showJava;

    public static ImageIcon getIcon(DatabaseSO databaseSO) {
        if (databaseSO.isForLoad()) {
            return FOR_LOAD_DATABASE_ICON;
        }
        if (databaseSO.isSuspect()) {
            return SUSPECT_DATABASE_ICON;
        }
        if (databaseSO.getType().equals("TDB")) {
            return TEMP_DATABASE_ICON;
        }
        if (databaseSO.isOffline()) {
            return OFFLINE_DATABASE_ICON;
        }
        if (databaseSO.isProxy()) {
            return PROXY_DATABASE_ICON;
        }
        return LOCAL_DATABASE_ICON;
    }

    DatabaseBO(DBsCtrBO dBsCtrBO, DatabaseSO databaseSO) {
        super(dBsCtrBO, (SOItemInterface)databaseSO, (Icon)DatabaseBO.getIcon(databaseSO));
        boolean bl = this.getConnection().isJavaEnabled();
        this._hasScalarFunction = databaseSO.hasScalarFunction();
        this._hasTableFunction = databaseSO.hasTableFunction();
        this._showJava = this.alwaysShowFolders() || !this.alwaysShowFolders() && bl;
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        return new ASEBaseHeader[]{new ASEBaseHeader(ASEUtils.getString("DISP_FOLDERS_TEXT"), 0, 200)};
    }

    @Override
    public boolean includeCreate() {
        DatabaseSO databaseSO = (DatabaseSO)this.getSO();
        return !databaseSO.isSuspectOrLoadOrOffline();
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        ASEMenuItem aSEMenuItem;
        ASEMenuItem aSEMenuItem2;
        ASEMenuItem aSEMenuItem3;
        ASEMenuItem aSEMenuItem4;
        Vector<ASEMenuItem> vector = new Vector<ASEMenuItem>();
        String string = ASEUtils.getString("MSG_DEFAULT_TYPE");
        String string2 = ASEUtils.getString("CREATION_HINT_NEW_DEFAULT");
        ASEMenuItem aSEMenuItem5 = new ASEMenuItem(3061, string, string2, '\u0000', DefaultBO.DEFAULT_ICON);
        vector.add(aSEMenuItem5);
        string = ASEUtils.getString("MSG_ESP_TYPE");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_ESP");
        ASEMenuItem aSEMenuItem6 = new ASEMenuItem(3062, string, string2, '\u0000', ESPBO.ESP_ICON);
        vector.add(aSEMenuItem6);
        string = ASEUtils.getString("DISP_GROUP_TEXT");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_GROUP");
        ASEMenuItem aSEMenuItem7 = new ASEMenuItem(3063, string, string2, '\u0000', GroupBO.GROUP_ICON);
        vector.add(aSEMenuItem7);
        if (this.showJava()) {
            string = ASEUtils.getString("MSG_JAR_TYPE");
            string2 = ASEUtils.getString("CREATION_HINT_NEW_JAR");
            aSEMenuItem4 = new ASEMenuItem(3064, string, string2, '\u0000', JavaJarBO.JAR_ICON);
            vector.add(aSEMenuItem4);
            string = ASEUtils.getString("DNAME_SQLJ_FUNCTION");
            string2 = ASEUtils.getString("CREATION_HINT_NEW_SQLJ_FUNCTION");
            aSEMenuItem3 = new ASEMenuItem(3068, string, string2, '\u0000', SQLJFunctionBO.SQLJ_FUNCTION_ICON);
            vector.add(aSEMenuItem3);
            string = ASEUtils.getString("DNAME_SQLJ_PROCEDURE");
            string2 = ASEUtils.getString("CREATION_HINT_NEW_SQLJ_PROCEDURE");
            aSEMenuItem2 = new ASEMenuItem(3069, string, string2, '\u0000', SQLJProcedureBO.SQLJ_PROCEDURE_ICON);
            vector.add(aSEMenuItem2);
        }
        string = ASEUtils.getString("MSG_PROC_TYPE");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_PROCEDURE");
        aSEMenuItem4 = new ASEMenuItem(3070, string, string2, '\u0000', StoredProcedureBO.PROC_ICON);
        vector.add(aSEMenuItem4);
        string = ASEUtils.getString("DNAME_PROXYTABLE");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_PROXY_TABLE");
        aSEMenuItem3 = new ASEMenuItem(3065, string, string2, '\u0000', TableBO.PROXY_TABLE_ICON);
        vector.add(aSEMenuItem3);
        string = ASEUtils.getString("MSG_RULE_TYPE");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_RULE");
        aSEMenuItem2 = new ASEMenuItem(3066, string, string2, '\u0000', RuleBO.RULE_ICON);
        vector.add(aSEMenuItem2);
        string = ASEUtils.getString("MSG_SEGMENT_TYPE");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_SEGMENT");
        ASEMenuItem aSEMenuItem8 = new ASEMenuItem(3067, string, string2, '\u0000', SegmentBO.SEGMENT_ICON);
        vector.add(aSEMenuItem8);
        if (this.hasScalarFunctions()) {
            string = ASEUtils.getString("DNAME_SCALAR_FUNCTION");
            string2 = ASEUtils.getString("CREATION_HINT_NEW_SCALAR_FUNCTION");
            aSEMenuItem = new ASEMenuItem(3078, string, string2, '\u0000', FunctionBO.FUNCTION_ICON);
            vector.add(aSEMenuItem);
        }
        if (this.hasTableFunctions()) {
            string = ASEUtils.getString("DNAME_TABLE_FUNCTION");
            string2 = ASEUtils.getString("CREATION_HINT_NEW_TABLE_FUNCTION");
            aSEMenuItem = new ASEMenuItem(3079, string, string2, '\u0000', TableFunctionBO.TABLE_FUNCTION_ICON);
            vector.add(aSEMenuItem);
        }
        string = ASEUtils.getString("MSG_TABLE_TYPE");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_TABLE");
        aSEMenuItem = new ASEMenuItem(3072, string, string2, '\u0000', TableBO.TABLE_ICON);
        vector.add(aSEMenuItem);
        string = ASEUtils.getString("MSG_USER_TYPE");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_USER");
        ASEMenuItem aSEMenuItem9 = new ASEMenuItem(3071, string, string2, '\u0000', UserBO.USER_ICON);
        vector.add(aSEMenuItem9);
        string = ASEUtils.getString("MSG_UDT_TYPE");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_UDT");
        ASEMenuItem aSEMenuItem10 = new ASEMenuItem(3073, string, string2, '\u0000', UserTypeBO.UDT_ICON);
        vector.add(aSEMenuItem10);
        string = ASEUtils.getString("MSG_VIEW_TYPE");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_VIEW");
        ASEMenuItem aSEMenuItem11 = new ASEMenuItem(3074, string, string2, '\u0000', ViewBO.VIEW_ICON);
        vector.add(aSEMenuItem11);
        string = ASEUtils.getString("MSG_ENCRYPTION_KEY_TYPE");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_ENCRYPTION_KEY");
        ASEMenuItem aSEMenuItem12 = new ASEMenuItem(3080, string, string2, '\u0000', EncryptionKeyBO.KEY_ICON);
        vector.add(aSEMenuItem12);
        Object[] objectArray = vector.toArray(new ASEMenuItem[0]);
        Arrays.sort(objectArray);
        return (ASEMenuItem[])objectArray;
    }

    @Override
    public String getDisabledCreateHint() {
        return ASEUtils.getString("CONTEXT_MENU_DELETE_MORE_DB_HINT");
    }

    @Override
    public Vector getItems(int n) throws SQLException {
        boolean bl;
        Vector<ASEBaseDBContainer> vector = ((DatabaseSO)this.getSO()).open(1);
        if (vector == null) {
            vector = new Vector<ASEBaseDBContainer>();
            return vector;
        }
        DatabaseSO databaseSO = (DatabaseSO)this.getSO();
        boolean bl2 = bl = !databaseSO.isProxyDB() || databaseSO.isProxyDB() && !databaseSO.isProxy();
        if (bl) {
            this._userTablesCtrBO = new UserTablesCtrBO(this);
            vector.addElement(this._userTablesCtrBO);
        }
        vector.addElement(new SystemTablesCtrBO(this));
        if (this.getConnection().isCISEnabled()) {
            this._proxyTablesCtrBO = new ProxyTablesCtrBO(this);
            vector.addElement(this._proxyTablesCtrBO);
        }
        if (this.showJava() || this.hasScalarFunctions()) {
            this._functionsCtrBO = new FunctionsCtrBO(this);
            vector.addElement(this._functionsCtrBO);
        }
        this._proceduresCtrBO = new ProceduresCtrBO(this);
        vector.addElement(this._proceduresCtrBO);
        this._viewsCtrBO = new ViewsCtrBO(this);
        vector.addElement(this._viewsCtrBO);
        this._usersCtrBO = new UsersCtrBO(this);
        vector.addElement(this._usersCtrBO);
        this._groupsCtrBO = new GroupsCtrBO(this);
        vector.addElement(new GroupsCtrBO(this));
        this._userTypesCtrBO = new UserTypesCtrBO(this);
        vector.addElement(this._userTypesCtrBO);
        if (this.showJava()) {
            this._javaObjectsCtrBO = new JavaObjectsCtrBO(this);
            vector.addElement(this._javaObjectsCtrBO);
        }
        this._defaultsCtrBO = new DefaultsCtrBO(this);
        vector.addElement(this._defaultsCtrBO);
        this._rulesCtrBO = new RulesCtrBO(this);
        vector.addElement(this._rulesCtrBO);
        this._segmentsCtrBO = new SegmentsCtrBO(this);
        vector.addElement(this._segmentsCtrBO);
        this._espsCtrBO = new ESPsCtrBO(this);
        vector.addElement(this._espsCtrBO);
        if (this.getConnection().getVersion().compareTo("12.5.2") >= 0 && (this.alwaysShowFolders() || this.getConnection().isWSEnabled())) {
            this._udwsCtrBO = new UserDefinedWebServicesCtrBO(this);
            vector.addElement(this._udwsCtrBO);
        }
        if (this.alwaysShowFolders() || this.getConnection().isEncryptedKeyEnabled()) {
            this._encyrptionKeysCtrBO = new EncryptionKeysCtrBO(this);
            vector.addElement(this._encyrptionKeysCtrBO);
        }
        return vector;
    }

    private boolean alwaysShowFolders() {
        return ProfileHelper.getBooleanPreference("Setting.Default");
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return ((DatabaseSO)this.getSO()).getName();
            }
            case 1: {
                return ((DatabaseSO)this.getSO()).getOwner();
            }
            case 2: {
                DatabaseSO databaseSO = (DatabaseSO)this.getSO();
                return String.valueOf(databaseSO.getTotalSpaceinMB());
            }
            case 3: {
                return ((DatabaseSO)this.getSO()).getCreationDate();
            }
            case 4: {
                return ((TempDBSO)this.getSO()).getSDCInstanceName();
            }
        }
        return "";
    }

    @Override
    public int getAttributes() {
        return -5;
    }

    @Override
    public SCMenu getContextMenu() {
        DatabaseSO databaseSO = (DatabaseSO)this.getSO();
        boolean bl = databaseSO.isQuiesceHold();
        if (this._contextMenu != null) {
            return this._contextMenu;
        }
        this._contextMenu = new ASEMenu();
        if (!databaseSO.isSuspectOrLoadOrOffline()) {
            ASEMenuItem aSEMenuItem;
            ASEMenuItem aSEMenuItem2;
            this.addUniqueContextMenuItem(new ASEMenuItem(3013, ASEUtils.getString("MSG_OPEN_DBISQL"), ASEUtils.getString("MSG_DBISQL_DETAIL"), Support.getMnemonic("CONTEXT_MENU_OPEN_DBISQL_MNEM"), ISQLImages.getImageIcon((String)"isql16")));
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            if (!databaseSO.isArchiveDB()) {
                this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3001, ASEUtils.getString("CONTEXT_MENU_BACKUP_TEXT"), ASEUtils.getString("CONTEXT_MENU_BACKUP_HINT"), Support.getMnemonic("BACKUP_MNEM")));
            }
            if ((databaseSO.getDBType() == 1 || databaseSO.isArchiveDB()) && !((DatabaseSO)this.getSO()).getName().equals("tempdb")) {
                this.addUniqueContextMenuItem(new ASEMenuItem(3002, ASEUtils.getString("CONTEXT_MENU_RESTORE_TEXT"), ASEUtils.getString("CONTEXT_MENU_RESTORE_HINT"), Support.getMnemonic("RESTORE_MNEM")));
            }
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            if (this.getConnection().getVersion().compareTo("12.5.1") >= 0) {
                boolean bl2 = false;
                try {
                    bl2 = this.getConnection().isHAEnabled();
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                }
                if (!(databaseSO.isSystem() || bl2 || databaseSO.isProxy() || databaseSO.isArchiveDB() || databaseSO.isInIMDBFamily())) {
                    this.addUniqueContextMenuItem(new ASEMenuItem(3003, ASEUtils.getString("CONTEXT_MENU_UNMOUNT_TEXT"), ASEUtils.getString("CONTEXT_MENU_UNMOUNT_HINT"), Support.getMnemonic("UNMOUNT_MNEM")));
                    this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
                }
                if (!databaseSO.isArchiveDB() && !databaseSO.isInIMDBFamily()) {
                    aSEMenuItem2 = new ASEMenu(ASEUtils.getString("CONTEXT_MENU_QUIESCE_TEXT"));
                    aSEMenuItem2.setMnemonic(Support.getMnemonic("QUIESCE_MNEM"));
                    aSEMenuItem = new ASEMenuItem(3004, ASEUtils.getString("CONTEXT_MENU_QUIESCE_HOLD_TEXT"), ASEUtils.getString("CONTEXT_MENU_QUIESCE_HOLD_HINT"), Support.getMnemonic("QUIESCE_HOLD_MNEM"));
                    aSEMenuItem.setEnabled(!bl);
                    ((ASEMenu)aSEMenuItem2).addItem((SCMenuItem)aSEMenuItem);
                    ASEMenuItem aSEMenuItem3 = new ASEMenuItem(3005, ASEUtils.getString("CONTEXT_MENU_QUIESCE_RELEASE_TEXT"), ASEUtils.getString("CONTEXT_MENU_QUIESCE_RELEASE_HINT"), Support.getMnemonic("QUIESCE_RELEASE_MNEM"));
                    aSEMenuItem3.setEnabled(bl);
                    ((ASEMenu)aSEMenuItem2).addItem((SCMenuItem)aSEMenuItem3);
                    this._contextMenu.addItem((SCMenuItem)aSEMenuItem2);
                    this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
                }
            }
            this.addUniqueContextMenuItem(new ASEMenuItem(3006, ASEUtils.getString("CONTEXT_MENU_CHECK_CONSISTENCY_TEXT"), ASEUtils.getString("CONTEXT_MENU_CHECK_CONSISTENCY_HINT"), Support.getMnemonic("CC_DATABASE_MNEM")));
            if (!((DatabaseSO)this._so).isQuiesceHold()) {
                this.addUniqueContextMenuItem(new ASEMenuItem(3011, ASEUtils.getString("CONTEXT_MENU_CHECKPOINT_TEXT"), ASEUtils.getString("CONTEXT_MENU_CHECKPOINT_HINT"), Support.getMnemonic("CHECKPOINT_MNEM")));
            }
            this.addUniqueContextMenuItem(TableBO.getStatisticsMenu(3082));
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            if (!((DatabaseSO)this._so).isQuiesceHold()) {
                ASEMenu aSEMenu = new ASEMenu(ASEUtils.getString("CONTEXT_MENU_GENERATE_DDL_TEXT"));
                aSEMenu.setMnemonic(Support.getMnemonic("GENERATE_DDL_MNEM"));
                aSEMenuItem2 = new ASEMenuItem(3007, ASEUtils.getString("CONTEXT_MENU_DATABASE_CREATE_DDL_TEXT"), ASEUtils.getString("CONTEXT_MENU_DATABASE_CREATE_DDL_HINT"), Support.getMnemonic("CONTEXT_MENU_DATABASE_CREATE_DDL_MNEM"));
                aSEMenu.addItem((SCMenuItem)aSEMenuItem2);
                aSEMenuItem = new ASEMenuItem(3008, ASEUtils.getString("CONTEXT_MENU_DATABASE_OBJECTS_DDL_TEXT"), ASEUtils.getString("CONTEXT_MENU_DATABASE_OBJECTS_DDL_HINT"), Support.getMnemonic("CONTEXT_MENU_DATABASE_OBJECTS_DDL_MNEM"));
                aSEMenu.addItem((SCMenuItem)aSEMenuItem);
                this._contextMenu.addItem((SCMenuItem)aSEMenu);
                this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            }
            try {
                if (this.getConnection().isEncryptedKeyEnabled() && !((DatabaseSO)this.getSO()).isArchiveDB()) {
                    if (!((DatabaseSO)this.getSO()).systemDefaultHasSet()) {
                        ASEMenuItem aSEMenuItem4 = new ASEMenuItem(3075, ASEUtils.getString("CONTEXT_MENU_CREATE_SYSTEM_ENCRYPTION_KEY"), ASEUtils.getString("CONTEXT_MENU_CREATE_SYSTEM_ENCRYPTION_KEY_DETAIL"), Support.getMnemonic("CONTEXT_MNEM_CREATE_SYSTEM_ENCRYPTION_KEY"));
                        this._contextMenu.addItem((SCMenuItem)aSEMenuItem4);
                    } else {
                        ASEMenu aSEMenu = new ASEMenu(ASEUtils.getString("CONTEXT_MENU_SYSTEM_ENCRYPTION_KEY"));
                        aSEMenu.addItem((SCMenuItem)new ASEMenuItem(3076, ASEUtils.getString("CONTEXT_MENU_ALTER_SYSTEM_ENCRYPTION_KEY"), ASEUtils.getString("CONTEXT_MENU_ALTER_SYSTEM_ENCRYPTION_KEY_DETAIL"), Support.getMnemonic("CONTEXT_MNEM_ALTER_SYSTEM_ENCRYPTION_KEY")));
                        aSEMenu.addItem((SCMenuItem)new ASEMenuItem(3077, ASEUtils.getString("CONTEXT_MENU_DELETE_SYSTEM_ENCRYPTION_KEY"), ASEUtils.getString("CONTEXT_MENU_DELETE_SYSTEM_ENCRYPTION_KEY_DETAIL"), Support.getMnemonic("CONTEXT_MNEM_DELETE_SYSTEM_ENCRYPTION_KEY")));
                        this._contextMenu.addItem((SCMenuItem)aSEMenu);
                    }
                    this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            }
            if (!databaseSO.isSystem()) {
                this.addUniqueContextMenuItem(this.getDeleteMenuItem());
                this.addUniqueContextMenuItem(new ASEMenuItem());
            }
            if (((DatabaseSO)this.getSO()).getDBType() == 3) {
                this.addUniqueContextMenuItem(new ASEMenuItem(3009, ASEUtils.getString("MSG_ACTIVE_SESSION"), ASEUtils.getString("CONTEXT_MENU_ACTIVE_HINT"), Support.getMnemonic("MNEM_ACTIVE")));
                this.addUniqueContextMenuItem(new ASEMenuItem());
            }
            this.addUniqueContextMenuItem(ASEMenuItem.getPropertiesMenuItem());
        }
        if (((DatabaseSO)this.getSO()).isForLoad()) {
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3002, ASEUtils.getString("CONTEXT_MENU_RESTORE_TEXT"), ASEUtils.getString("CONTEXT_MENU_RESTORE_HINT"), Support.getMnemonic("RESTORE_MNEM")));
            if (!((DatabaseSO)this.getSO()).isArchiveDB()) {
                this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3012, ASEUtils.getString("CONTEXT_MENU_REALLOCATE_SPACE_TEXT"), ASEUtils.getString("CONTEXT_MENU_REALLOCATE_SPACE_HINT"), Support.getMnemonic("REALLOCATE_SPACE_MNEM")));
            }
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            this.addUniqueContextMenuItem(this.getDeleteMenuItem());
            this.addUniqueContextMenuItem(new ASEMenuItem());
            this.addUniqueContextMenuItem(ASEMenuItem.getPropertiesMenuItem());
        } else if (((DatabaseSO)this.getSO()).isOffline()) {
            if (!databaseSO.isArchiveDB()) {
                this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3001, ASEUtils.getString("CONTEXT_MENU_BACKUP_TEXT"), ASEUtils.getString("CONTEXT_MENU_BACKUP_HINT"), Support.getMnemonic("BACKUP_MNEM")));
            }
            this.addUniqueContextMenuItem(new ASEMenuItem(3002, ASEUtils.getString("CONTEXT_MENU_RESTORE_TEXT"), ASEUtils.getString("CONTEXT_MENU_RESTORE_HINT"), Support.getMnemonic("RESTORE_MNEM")));
            this.addUniqueContextMenuItem(new ASEMenuItem(3010, ASEUtils.getString("CONTEXT_MENU_ONLINE_TEXT"), ASEUtils.getString("CONTEXT_MENU_ONLINE_HINT"), Support.getMnemonic("ONLINE_MNEM")));
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            this.addUniqueContextMenuItem(this.getDeleteMenuItem());
        }
        if (((DatabaseSO)this.getSO()).isSuspect()) {
            this.addUniqueContextMenuItem(this.getDeleteMenuItem());
        }
        return this._contextMenu;
    }

    private void addUniqueContextMenuItem(ASEMenuItem aSEMenuItem) {
        if (this._contextMenu == null || aSEMenuItem == null) {
            return;
        }
        if (aSEMenuItem.isSeparator()) {
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
            return;
        }
        SCMenuItem[] sCMenuItemArray = this._contextMenu.getMenuItems();
        boolean bl = false;
        for (int i = 0; i < sCMenuItemArray.length; ++i) {
            if (sCMenuItemArray[i].getCommandId() != aSEMenuItem.getCommandId()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        }
    }

    @Override
    public boolean isOkToBatch(int n) {
        return super.isOkToBatch(n) || n == 3010 || n == 3011 || n == 3012 || n == 3006 || n == 3004 || n == 3003 || n == 3008 || n == 3082;
    }

    private boolean isBackupServerUp() {
        String string;
        ServerBO serverBO = ContainerViewBO.getServerBO(this.getConnection());
        ServerSO serverSO = (ServerSO)serverBO.getSO();
        if (!serverSO.isCluster() && (string = ((DatabaseSO)this.getSO()).isBackupServerUp()).length() != 0) {
            Support.showError(this.getConnection(), this.getClass(), string);
            return false;
        }
        return true;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        DatabaseSO databaseSO = (DatabaseSO)this.getSO();
        switch (n) {
            case 3013: {
                Support.getProvider().openDBISQL(jFrame, this.getConnection(), this.getSO().getName(), null, false);
                break;
            }
            case 107: {
                if (databaseSO instanceof ArchiveDBSO) {
                    ArchiveDBProperties archiveDBProperties = new ArchiveDBProperties((ArchiveDBSO)databaseSO, (SCContainer2)this.getParent());
                    ASEBaseDialog2.showDialog(jFrame, archiveDBProperties);
                    break;
                }
                DatabaseProperties databaseProperties = new DatabaseProperties(databaseSO, (SCContainer2)this.getParent());
                ASEBaseDialog2.showDialog(jFrame, databaseProperties);
                break;
            }
            case 3001: {
                if (!this.isBackupServerUp()) {
                    return;
                }
                BackupWizard backupWizard = new BackupWizard(databaseSO, (SCContainer2)this.getParent(), jFrame);
                ASEBaseDialog2.showDialog(jFrame, backupWizard);
                break;
            }
            case 3010: {
                while (enumeration.hasMoreElements()) {
                    DatabaseBO databaseBO = (DatabaseBO)enumeration.nextElement();
                    DatabaseSO databaseSO2 = (DatabaseSO)databaseBO.getSO();
                    try {
                        databaseSO2.online();
                    }
                    catch (SQLException sQLException) {
                        Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                    }
                }
                ((DBsCtrBO)this.getParent()).refresh();
                break;
            }
            case 3011: {
                ArrayList arrayList = new ArrayList();
                if (this.isOkToBatch(n)) {
                    arrayList = Support.enumToArrayList(enumeration);
                } else {
                    arrayList.add(this);
                }
                ItemsConfirmDialog itemsConfirmDialog = new ItemsConfirmDialog(Support.createDialogSupport(jFrame), ASEUtils.getString("TITLE_CONFIRM_CHECKPOINT"), ASEUtils.getString("LABC_CONFIRM_CHECKPOINT"), "HELP_DATABASE_DLG_CONFIRM_CHECKPOINT_1252", this, 3011, arrayList);
                if (!itemsConfirmDialog.start(this)) break;
                break;
            }
            case 3012: {
                ArrayList arrayList = new ArrayList();
                if (this.isOkToBatch(n)) {
                    arrayList = Support.enumToArrayList(enumeration);
                } else {
                    arrayList.add(this);
                }
                ItemsConfirmDialog itemsConfirmDialog = new ItemsConfirmDialog(Support.createDialogSupport(jFrame), ASEUtils.getString("TITLE_CONFIRM_REALLOCATE_SPACE"), ASEUtils.getString("LABC_CONFIRM_REALLOCATE_SPACE"), "HELP_DATABASE_DLG_CONFIRM_REALLOCATE_SPACE_1252", this, 3012, arrayList);
                if (!itemsConfirmDialog.start(this)) break;
                break;
            }
            case 3002: {
                if (!this.isBackupServerUp()) {
                    return;
                }
                RestoreWizard restoreWizard = new RestoreWizard(databaseSO, (SCContainer2)this.getParent(), jFrame);
                ASEBaseDialog2.showDialog(jFrame, restoreWizard);
                break;
            }
            case 3006: {
                if (enumeration == null) break;
                ArrayList arrayList = Support.enumToArrayList(enumeration);
                DatabaseBO databaseBO = (DatabaseBO)arrayList.get(0);
                DatabaseSO databaseSO3 = (DatabaseSO)databaseBO.getSO();
                DBCCWizard dBCCWizard = new DBCCWizard(databaseSO3, arrayList, (SCContainer2)this.getParent());
                ASEBaseDialog2.showDialog(jFrame, dBCCWizard);
                break;
            }
            case 3004: {
                Object object;
                String string = "";
                while (enumeration.hasMoreElements()) {
                    object = (DatabaseBO)enumeration.nextElement();
                    DatabaseSO databaseSO4 = (DatabaseSO)((ASEBaseItem2)object).getSO();
                    string = string + databaseSO4.getName() + ",";
                }
                string = string.substring(0, string.length() - 1);
                object = new DatabaseQuiesceHoldWizard((DatabaseSO)this._so, (DBsCtrBO)this._parent, string);
                ASEBaseDialog2.showDialog(jFrame, (ASEBaseDialog2)object);
                break;
            }
            case 3005: {
                boolean bl = databaseSO.getConnection().hasRole("mon_role");
                if (bl) {
                    DatabaseQuiesceReleaseDialog databaseQuiesceReleaseDialog = new DatabaseQuiesceReleaseDialog(Support.createDialogSupport(jFrame), databaseSO);
                    databaseQuiesceReleaseDialog.start(this);
                } else {
                    String string;
                    String string2 = ASEUtils.getString("DB_QUIESCE_RELEASE_DLG_SENT_INTRO") + "\n\n" + ASEUtils.getString("DB_QUIESCE_RELEASE_TAG_INPUT_DLG_TEXT");
                    String string3 = JOptionPane.showInputDialog(jFrame, string2, string = ASEUtils.getString("DB_QUIESCE_RELEASE_TAG_INPUT_DLG_TITLE"), 3);
                    if (string3 != null) {
                        try {
                            databaseSO.quiesceRelease(string3);
                        }
                        catch (SQLException sQLException) {
                            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                        }
                    }
                }
                ((DBsCtrBO)this.getParent()).refresh();
                break;
            }
            case 3003: {
                String string = "";
                while (enumeration.hasMoreElements()) {
                    DatabaseBO databaseBO = (DatabaseBO)enumeration.nextElement();
                    DatabaseSO databaseSO5 = (DatabaseSO)databaseBO.getSO();
                    string = string + databaseSO5.getName() + ",";
                }
                string = string.substring(0, string.length() - 1);
                ASEBaseDialog2.showDialog(jFrame, new DatabaseUnmountWizard((DatabaseSO)this._so, (DBsCtrBO)this.getParent(), string));
                break;
            }
            case 3007: {
                SybDDLGenerator.setStoreToFile(false);
                SybDDLGenerator.generateDDL(this.getDDLParams(databaseSO), this.getConnection());
                break;
            }
            case 3008: {
                String[] stringArray;
                Vector<String> vector = new Vector<String>();
                ASConnection aSConnection = null;
                while (enumeration.hasMoreElements()) {
                    stringArray = (String[])enumeration.nextElement();
                    DatabaseSO databaseSO6 = (DatabaseSO)stringArray.getSO();
                    vector.addElement(databaseSO6.getName());
                    aSConnection = databaseSO6.getConnection();
                }
                stringArray = new String[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    stringArray[i] = (String)vector.elementAt(i);
                }
                DDLObjectFilterDialog.render(jFrame, stringArray, 'D', aSConnection, "HELP_DATABASE_DLG_FILTER_OBJECTS_FROM_DDL_OUTPUT_1252");
                break;
            }
            case 3009: {
                TempDBSessionDialog.showDialog(jFrame, (TempDBSO)databaseSO);
                break;
            }
            case 3061: {
                this._defaultsCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3062: {
                this._espsCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3063: {
                this._groupsCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3064: {
                if (this._javaObjectsCtrBO == null) break;
                this._javaObjectsCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3065: {
                if (this._proxyTablesCtrBO == null) break;
                this._proxyTablesCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3066: {
                this._rulesCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3067: {
                this._segmentsCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3068: {
                if (this._functionsCtrBO == null) break;
                this._functionsCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3078: {
                if (this._functionsCtrBO == null) break;
                this._functionsCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3069: {
                this._proceduresCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3070: {
                this._proceduresCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3071: {
                this._usersCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3072: {
                this._userTablesCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3073: {
                this._userTypesCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3074: {
                this._viewsCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3080: {
                if (this._encyrptionKeysCtrBO == null) break;
                this._encyrptionKeysCtrBO.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            case 3082: {
                if (enumeration == null) break;
                ArrayList arrayList = Support.enumToArrayList(enumeration);
                UpdateStatWizard updateStatWizard = new UpdateStatWizard((DatabaseSO)this.getSO(), arrayList, n, (SCContainer2)this.getParent());
                ASEBaseDialog2.showDialog(jFrame, updateStatWizard);
                break;
            }
            case 3075: {
                EncryptionPasswordDialog encryptionPasswordDialog = new EncryptionPasswordDialog(Support.createDialogSupport(jFrame), (DatabaseSO)this.getSO(), ((DatabaseSO)this.getSO()).getMinPasswordLength(), 0);
                encryptionPasswordDialog.start(this);
                this.getParent().refresh();
                break;
            }
            case 3076: {
                EncryptionPasswordDialog encryptionPasswordDialog = new EncryptionPasswordDialog(Support.createDialogSupport(jFrame), (DatabaseSO)this.getSO(), ((DatabaseSO)this.getSO()).getMinPasswordLength(), 1);
                encryptionPasswordDialog.start(this);
                break;
            }
            case 3077: {
                EncryptionPasswordDialog encryptionPasswordDialog = new EncryptionPasswordDialog(Support.createDialogSupport(jFrame), (DatabaseSO)this.getSO(), ((DatabaseSO)this.getSO()).getMinPasswordLength(), 2);
                encryptionPasswordDialog.start(this);
                this.getParent().refresh();
                break;
            }
            case 106: {
                TempDBsListCtrBO tempDBsListCtrBO;
                super.onCommand(jFrame, n, enumeration, n2);
                ServerBO serverBO = ContainerViewBO.getServerBO(((DatabaseSO)this.getSO()).getConnection());
                DatabaseDevicesCtrBO databaseDevicesCtrBO = null;
                databaseDevicesCtrBO = ((DatabaseSO)this.getSO()).isInIMDBFamily() ? ContainerViewBO.getIMDatabaseDevicesCtrBO(serverBO) : ContainerViewBO.getDatabaseDevicesCtrBO(serverBO);
                if (null != databaseDevicesCtrBO) {
                    databaseDevicesCtrBO.refresh();
                }
                if (!(this.getParent() instanceof TempDBsListCtrBO) || !((tempDBsListCtrBO = (TempDBsListCtrBO)this.getParent()).getParent() instanceof TempDBsCtrBO) || !(((TempDBsCtrBO)tempDBsListCtrBO.getParent()).getParent() instanceof SDCInstanceBO)) break;
                tempDBsListCtrBO.getParent().refresh();
                break;
            }
            default: {
                super.onCommand(jFrame, n, enumeration, n2);
            }
        }
    }

    @Override
    public boolean confirmExecution(ArrayList arrayList, int n) {
        if (n == 3011) {
            return this.checkPoint(arrayList);
        }
        if (n == 3012) {
            return this.reAllocateSpace(arrayList);
        }
        return super.deleteObjects(arrayList);
    }

    public boolean reAllocateSpace(ArrayList arrayList) {
        boolean bl = true;
        Support.getViewerSupport().startWait();
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                ((DatabaseSO)((DatabaseBO)arrayList.get(i)).getSO()).reallocateSpace();
            }
            ((DBsCtrBO)this.getParent()).refresh();
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getConnection(), this.getClass(), exception.getMessage(), exception);
            bl = false;
        }
        Support.getViewerSupport().endWait();
        return bl;
    }

    public boolean checkPoint(ArrayList arrayList) {
        boolean bl = true;
        Support.getViewerSupport().startWait();
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                ((DatabaseSO)((DatabaseBO)arrayList.get(i)).getSO()).checkpoint();
            }
            ((DBsCtrBO)this.getParent()).refresh();
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getConnection(), this.getClass(), exception.getMessage(), exception);
            bl = false;
        }
        Support.getViewerSupport().endWait();
        return bl;
    }

    @Override
    public boolean includeDelete() {
        return !((DatabaseSO)this.getSO()).isSystem();
    }

    public UsersCtrBO getUsersCtrBO() {
        return this._usersCtrBO;
    }

    public UserTypesCtrBO getUserTypesCtrBO() {
        return this._userTypesCtrBO;
    }

    public JavaObjectsCtrBO getJavaObjectsCtrBO() {
        return this._javaObjectsCtrBO;
    }

    public boolean hasScalarFunctions() {
        return this._hasScalarFunction;
    }

    public boolean hasTableFunctions() {
        return this._hasTableFunction;
    }

    public boolean showJava() {
        return this._showJava;
    }

    @Override
    String[] getDDLParams(SOItemInterface sOItemInterface) {
        String[] stringArray;
        DatabaseSO databaseSO = (DatabaseSO)sOItemInterface;
        String string = databaseSO.getConnection().getCharacterSet();
        if (string != null) {
            stringArray = new String[7];
            stringArray[6] = "-J" + string;
        } else {
            stringArray = new String[]{"-U" + databaseSO.getConnection().getCurrentUser(), "-P" + databaseSO.getConnection().getPassword(), "-S" + databaseSO.getConnection().getHostName() + ":" + databaseSO.getConnection().getPortNumber(), "-TDB", "-N" + databaseSO.getName(), "-F%"};
        }
        return stringArray;
    }

    @Override
    public boolean includeDDLGen() {
        return true;
    }
}

