/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ItemsConfirmDialog;
import com.sybase.aseplugin.bo.dlg.ResizeDeviceDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.DatabaseDeviceProperties;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.ua.util.ProcessInfo;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class DatabaseDeviceBO
extends ASEBaseItem2 {
    public static final ImageIcon DATABASE_DEVICE_ICON = new ImageIcon(ASEImages.getDeviceSmallImage());
    public static final ImageIcon NEW_DATABASE_DEVICE_ICON = new ImageIcon(ASEImages.getNewDeviceImage());
    private static final int CMD_RESIZE = 3001;

    public DatabaseDeviceBO(DatabaseDeviceSO databaseDeviceSO, ASEBaseContainer2 aSEBaseContainer2) {
        super((SOItemInterface)databaseDeviceSO, aSEBaseContainer2, (Icon)DATABASE_DEVICE_ICON);
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        return new DatabaseDeviceProperties((DatabaseDeviceSO)this.getSO(), (SCContainer2)this.getParent());
    }

    @Override
    public SCMenu getContextMenu() {
        if (this._contextMenu != null) {
            return this._contextMenu;
        }
        this._contextMenu = new ASEMenu();
        this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getDDLGenMenuItem());
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        DatabaseDeviceSO databaseDeviceSO = (DatabaseDeviceSO)this.getSO();
        if (databaseDeviceSO.isResizeApplicable()) {
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3001, ASEUtils.getString("MSG_RESIZE"), ASEUtils.getString("CONTEXT_MENU_RESIZE_HINT"), Support.getMnemonic("MNEM_RESIZE")));
        }
        this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        return this._contextMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        if (n == 3001) {
            ResizeDeviceDialog resizeDeviceDialog = new ResizeDeviceDialog(Support.createDialogSupport(jFrame), this, (DatabaseDeviceSO)this.getSO());
            resizeDeviceDialog.start(this);
        } else {
            super.onCommand(jFrame, n, enumeration, n2);
        }
    }

    @Override
    public boolean includeDDLGen() {
        return true;
    }

    @Override
    void deleteItems(JFrame jFrame, Enumeration enumeration) {
        ServerSO serverSO = (ServerSO)ContainerViewBO.getServerBO(this.getConnection()).getSO();
        if (!this.getConnection().isLocal() && !ServerBO.getEnableUAF(serverSO)) {
            super.deleteItems(jFrame, enumeration);
            return;
        }
        String string = null;
        if (!((DatabaseDeviceSO)this.getSO()).isIMDBDevice()) {
            string = ASEUtils.getString("CHKB_ALSO_DELETE_DEVICE_FILE");
        }
        ArrayList arrayList = this.getBatchList(106, enumeration);
        ItemsConfirmDialog itemsConfirmDialog = new ItemsConfirmDialog(Support.createDialogSupport(jFrame), ASEUtils.getString("MSG_CONFIRM_DELETE"), ASEUtils.getString("DNAME_DATABASEDEVICES"), string, this, arrayList);
        if (itemsConfirmDialog.start(this)) {
            boolean bl = itemsConfirmDialog.isOptionSelected();
            if (bl) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    DatabaseDeviceBO databaseDeviceBO = (DatabaseDeviceBO)arrayList.get(i);
                    String string2 = databaseDeviceBO.getDisplayName(3);
                    if (string2 == null || Support.isJustFile(string2)) continue;
                    if (this.getConnection().isLocal()) {
                        if (!ASEUtils.deleteFile(string2)) continue;
                        this.logDeletedMessage(string2);
                        continue;
                    }
                    if (!ServerBO.getEnableUAF(serverSO) || !this.deleteRemoteFile(serverSO, string2)) continue;
                    this.logDeletedMessage(string2);
                }
            }
            this.getParent().refresh();
        }
    }

    private void logDeletedMessage(String string) {
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_FILE_DELETED"), string);
        String string2 = aSEMessageText.toString();
        Support.addLogEntry(2, this.getConnection(), this.getClass(), string2, string2);
    }

    private boolean deleteRemoteFile(ServerSO serverSO, String string) {
        try {
            boolean bl = this.getConnection().getPlatform().startsWith("NT");
            Object[] objectArray = new Object[]{bl ? "cmd /c del " + string : "rm " + string};
            String[] stringArray = new String[]{"java.lang.String"};
            ProcessInfo processInfo = serverSO.executeRemoteShell(objectArray, stringArray);
            return processInfo.getExitValue() == 0;
        }
        catch (Exception exception) {
            return true;
        }
    }
}

