/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ArchiveDatabasesCtrBO;
import com.sybase.aseplugin.bo.DBsCtrBO;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.IMDatabasesCtrBO;
import com.sybase.aseplugin.bo.ProxyDatabasesCtrBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.TempDBsCtrBO;
import com.sybase.aseplugin.bo.wiz.DatabaseMountWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DatabasesCtrSO;
import com.sybase.aseplugin.so.ServerSO;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;

public class DatabasesCtrBO
extends DBsCtrBO {
    public static final int CMD_MOUNT_DATABASE = 3162;
    private DatabasesCtrSO _dbCtrSO;
    private ServerSO _serverSO;

    public DatabasesCtrBO(ServerBO serverBO) {
        super(ASEUtils.getString("DNAME_DATABASES"), (ASEBaseContainer2)serverBO);
        this._serverSO = (ServerSO)serverBO.getSO();
        this._dbCtrSO = new DatabasesCtrSO(this.getConnection());
        if (this._serverSO.isCluster()) {
            this.setDatabaseCtrType(5);
            this._dbCtrSO.setDatabaseType(5);
        }
        this.setCtrSO(this._dbCtrSO);
    }

    @Override
    public Vector getItems(int n, Object[] objectArray) throws SQLException {
        Vector<ASEBaseContainer2> vector = new Vector<ASEBaseContainer2>();
        List list = this._dbCtrSO.open(1, objectArray);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                vector.addElement(new DatabaseBO(this, (DatabaseSO)iterator.next()));
            }
        }
        vector.addElement(new ProxyDatabasesCtrBO(this, this._serverSO));
        if (this.getConnection().getVersion().compareTo("12.5.0.3") >= 0) {
            vector.addElement(new TempDBsCtrBO(this));
        }
        if (this.getConnection().isArchiveDBApplicable()) {
            vector.addElement(new ArchiveDatabasesCtrBO(this, this._serverSO));
        }
        if (this.getConnection().isIMDBApplicable()) {
            vector.addElement(new IMDatabasesCtrBO((DBsCtrBO)this, this._serverSO));
        }
        this.setSortEndIndex(list.size());
        return vector;
    }

    @Override
    public ASEToolBarButton[] getContextButtons() {
        ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3162, DatabaseBO.MOUNT_DATABASE_ICON, ASEUtils.getString("MSG_MOUNT_DATABASE"), ASEUtils.getString("MSG_MOUNT_DATABASE_HINT"));
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public int[] getEnabledContextCmdIds() {
        return new int[]{3162};
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        if (n == 3162) {
            DatabasesCtrSO databasesCtrSO = new DatabasesCtrSO(this.getConnection());
            DatabaseSO databaseSO = new DatabaseSO(this.getConnection(), "", databasesCtrSO);
            ASEBaseDialog2.showDialog(jFrame, new DatabaseMountWizard(databaseSO, this, "all"));
        } else {
            super.onCommand(jFrame, n, enumeration, n2);
        }
    }
}

