/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.DumpDevicesCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ItemsConfirmDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.DumpDeviceProperties;
import com.sybase.aseplugin.so.DumpDeviceSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class DumpDeviceBO
extends ASEBaseItem2 {
    public static ImageIcon DUMP_DEVICE_ICON = new ImageIcon(ASEImages.getDeviceSmallImage());
    public static ImageIcon NEW_DUMP_DEVICE_ICON = new ImageIcon(ASEImages.getNewDeviceImage());
    private static final int CMD_ARCHIVE_DATABASE = 3001;

    public DumpDeviceBO(DumpDeviceSO dumpDeviceSO, ASEBaseContainer2 aSEBaseContainer2) {
        super((SOItemInterface)dumpDeviceSO, aSEBaseContainer2, (Icon)DUMP_DEVICE_ICON);
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        return new DumpDeviceProperties((DumpDeviceSO)this.getSO(), (SCContainer2)this.getParent());
    }

    @Override
    public SCMenu getContextMenu() {
        this._contextMenu = new ASEMenu();
        this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getDDLGenMenuItem());
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
        this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        DumpDeviceSO dumpDeviceSO = (DumpDeviceSO)this.getSO();
        if (dumpDeviceSO.getDeviceType().equals("Disk Dump Device") && dumpDeviceSO.getConnection().isArchiveDBApplicable()) {
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3001, ASEUtils.getString("CONTEXT_MENU_ARCHIVE_TEXT"), ASEUtils.getString("CONTEXT_MENU_ARCHIVE_HINT"), Support.getMnemonic("ARCHIVE_MNEM")));
        }
        return this._contextMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        if (n == 3001) {
            ArrayList arrayList = new ArrayList();
            if (this.isOkToBatch(n)) {
                arrayList = Support.enumToArrayList(enumeration);
            } else {
                arrayList.add(this);
            }
            ItemsConfirmDialog itemsConfirmDialog = new ItemsConfirmDialog(Support.createDialogSupport(jFrame), ASEUtils.getString("TITLE_CONFIRM_ARCHIVE_DEVICE"), ASEUtils.getString("LABC_CONFIRM_ARCHIVE_DEVICE"), "HELP_DATABASE_DLG_CONFIRM_CHECKPOINT_1252", this, 3001, arrayList);
            itemsConfirmDialog.start(this);
        } else {
            super.onCommand(jFrame, n, enumeration, n2);
        }
    }

    @Override
    public boolean confirmExecution(ArrayList arrayList, int n) {
        if (n == 106) {
            return super.deleteObjects(arrayList);
        }
        if (n == 3001) {
            boolean bl = true;
            Support.getViewerSupport().startWait();
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    ((DumpDeviceSO)((DumpDeviceBO)arrayList.get(i)).getSO()).markArchive();
                }
                ((DumpDevicesCtrBO)this.getParent()).refresh();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                bl = false;
            }
            Support.getViewerSupport().endWait();
            return bl;
        }
        return true;
    }
}

