/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ASEProvider;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.JavaClassBO;
import com.sybase.aseplugin.bo.JavaJarsCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEDialogController;
import com.sybase.aseplugin.bo.dlg.ItemsConfirmDialog;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.JavaClassSO;
import com.sybase.aseplugin.so.JavaJarSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class JavaJarBO
extends ASEBaseContainer2 {
    public static ImageIcon JAR_ICON = new ImageIcon(ASEImages.getJarSmallImage());
    public static ImageIcon NEW_JAR_ICON = new ImageIcon(ASEImages.getNewJarImage());
    private static final int CMD_EXTRACT = 3001;
    private static final int CMD_DELETE_RETAIN = 3002;
    int _cmdId;

    public JavaJarBO(JavaJarsCtrBO javaJarsCtrBO, JavaJarSO javaJarSO) {
        super(javaJarsCtrBO, (SOItemInterface)javaJarSO, (Icon)JAR_ICON);
    }

    @Override
    public int getAttributes() {
        return -5;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 32;
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        ASEBaseHeader aSEBaseHeader = new ASEBaseHeader(ASEUtils.getString("DISP_NAME_TEXT"), 0, 200);
        return new ASEBaseHeader[]{aSEBaseHeader};
    }

    @Override
    public SCMenu getContextMenu() {
        if (this._contextMenu != null) {
            return this._contextMenu;
        }
        this._contextMenu = new ASEMenu();
        String string = ASEUtils.getString("CONTEXT_MENU_EXTRACT_TEXT");
        String string2 = ASEUtils.getString("CONTEXT_MENU_EXTRACT_HINT");
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3001, string, string2, Support.getMnemonic("CONTEXT_MENU_EXTRACT_MNEM"));
        this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        if (this.includeDelete()) {
            this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
            string = ASEUtils.getString("CONTEXT_MENU_DELETE_RETAIN_TEXT");
            string2 = ASEUtils.getString("CONTEXT_MENU_DELETE_RETAIN_HINT");
            aSEMenuItem = ASEMenuItem.getDeleteMenuItem(string, string2, Support.getMnemonic("CONTEXT_MENU_DELETE_RETAIN_MNEM"), this.enableDelete(), this.getDisabledDeleteHint());
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        }
        return this._contextMenu;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return super.isOkToBatch(n) || n == 3001 || n == 3002;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 3001: {
                this.extract(jFrame, n, enumeration, n2);
                break;
            }
            case 106: 
            case 3002: {
                this.delete(jFrame, n, enumeration, n2);
                break;
            }
        }
    }

    private void extract(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        JavaJarSO javaJarSO = (JavaJarSO)this.getSO();
        String string = ASEProvider.getSybasePath();
        if (string == null) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_ENV_REQUIRED_FOR_EXTERNAL_UTILITY"), "SYBASE", javaJarSO.getExtractJavaCommand());
            Support.showError(this.getConnection(), this.getClass(), aSEMessageText.toString());
            return;
        }
        if (javaJarSO.getConnection().hasAdHocServerName()) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_NOT_VALID_SERVER_NAME_FOR_EXTERNAL_UTILITY"), javaJarSO.getConnection().getServerName(), javaJarSO.getExtractJavaCommand());
            String string2 = aSEMessageText.toString();
            if (!ASEUtils.OS_MAC_OS_X) {
                string2 = string2 + ASEUtils.getString("MSG_DEFINE_SERVER_ENTRY");
            }
            Support.showError(this.getConnection(), this.getClass(), string2);
            return;
        }
        try {
            Object object;
            String string3 = javaJarSO.getExtractJavaPath();
            String string4 = null;
            if (string3.length() == 0) {
                object = new ASEMessageText(ASEUtils.getString("ERR_NO_UTIL"), javaJarSO.getExtractJavaCommand());
                Support.showError(this.getConnection(), this.getClass(), ((ASEMessageText)object).toString());
                object = new ASEMessageText(ASEUtils.getString("INDICATE_LOCATION"), javaJarSO.getExtractJavaCommand());
                do {
                    if ((string4 = Support.browseForFile(Support.getViewerFrame(), ASEProvider.getSybaseOrSybrootDir(), ((ASEMessageText)object).toString(), ASEUtils.OS_WINDOWS ? 32 : 0)) != null) continue;
                    return;
                } while (!string4.endsWith(javaJarSO.getExtractJavaCommand()));
            }
            while (enumeration.hasMoreElements()) {
                object = (ASEBaseContainer2)enumeration.nextElement();
                String string5 = ((ASEBaseItem2)object).getSO().getName();
                String string6 = ".jar";
                String string7 = Support.browseForNewFile(Support.getViewerFrame(), new File(string5 + string6), ASEUtils.getString("SAVE_EXTRACTED_JAR_FILE"), 8);
                if (string7 == null) continue;
                if (!string7.endsWith(string6)) {
                    string7 = string7 + string6;
                }
                javaJarSO.extract(string7, string4);
            }
        }
        catch (IOException iOException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), iOException.getMessage(), iOException);
        }
    }

    private void delete(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        this._cmdId = n;
        while (enumeration.hasMoreElements()) {
            object = (ASEBaseContainer2)enumeration.nextElement();
            String string = object.getSO().getName();
            arrayList.add(string);
            arrayList2.add(object);
        }
        object = new ItemsConfirmDialog(Support.createDialogSupport(jFrame), ASEUtils.getString("MSG_OBJECTS"), this, arrayList2);
        if (((ASEDialogController)((Object)object)).start(this)) {
            this.getParent().getParent().refresh();
        }
    }

    @Override
    public Vector getItems(int n) throws SQLException {
        JavaJarsCtrBO javaJarsCtrBO = (JavaJarsCtrBO)this.getParent();
        DatabaseBO databaseBO = javaJarsCtrBO.getDatabaseBO();
        JavaJarSO javaJarSO = new JavaJarSO(this.getConnection(), (DatabaseSO)databaseBO.getSO(), this.getSO().getName());
        Vector<JavaClassBO> vector = new Vector<JavaClassBO>();
        List list = javaJarSO.open(1);
        for (JavaClassSO javaClassSO : list) {
            vector.add(new JavaClassBO(javaClassSO, (ASEBaseContainer2)this));
        }
        return vector;
    }

    @Override
    public boolean deleteObjects(ArrayList arrayList) {
        boolean bl = true;
        Object[] objectArray = arrayList.toArray();
        Support.getViewerSupport().startWait();
        try {
            if (this._cmdId == 106) {
                ((JavaJarSO)this.getSO()).remove(objectArray);
            } else if (this._cmdId == 3002) {
                ((JavaJarSO)this.getSO()).removeRetain(objectArray);
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), ASEMessageText.toString(sQLException), sQLException);
            bl = false;
        }
        Support.getViewerSupport().endWait();
        return bl;
    }
}

