/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.JobsCtrBO;
import com.sybase.aseplugin.bo.ScheduledJobsCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.JobProperties;
import com.sybase.aseplugin.bo.wiz.JobSchedulerWizard;
import com.sybase.aseplugin.so.JobSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ScheduledJobSO;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class JobBO
extends ASEBaseItem2 {
    private boolean traceThis = false;
    private JobsCtrBO _parentBO;
    public static final ImageIcon JOB_ICON = new ImageIcon(ASEImages.getJobSmallImage());
    public static final ImageIcon NEW_JOB_ICON = new ImageIcon(ASEImages.getNewJobImage());
    public static final int CMD_SCHEDULE = 3001;
    public static final int CMD_DUPLICATE = 3002;

    public JobBO(JobsCtrBO jobsCtrBO, JobSO jobSO) {
        super((SOItemInterface)jobSO, jobsCtrBO, (Icon)JOB_ICON);
        this._parentBO = jobsCtrBO;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 96;
    }

    @Override
    public SCMenu getContextMenu() {
        if (this._contextMenu != null) {
            return this._contextMenu;
        }
        this._contextMenu = new ASEMenu();
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3002, ASEUtils.getString("CONTEXT_MENU_DUPLICATE_AS_TEXT"), ASEUtils.getString("CONTEXT_MENU_DUPLICATE_JOB_HINT"), Support.getMnemonic("CONTEXT_MENU_DUPLICATE_AS_MNEM"));
        ASEMenuItem aSEMenuItem2 = new ASEMenuItem(3001, ASEUtils.getString("CONTEXT_MENU_SCHEDULE_TEXT"), ASEUtils.getString("CONTEXT_MENU_SCHEDULE_HINT"), Support.getMnemonic("CONTEXT_MENU_SCHEDULE_MNEM"));
        this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        this._contextMenu.addItem((SCMenuItem)aSEMenuItem2);
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        return this._contextMenu;
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        return new JobProperties((JobSO)this.getSO(), this.getParent());
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        JobSO jobSO = (JobSO)this.getSO();
        ScheduledJobsCtrBO scheduledJobsCtrBO = null;
        switch (n) {
            case 3001: {
                scheduledJobsCtrBO = (ScheduledJobsCtrBO)this._parentBO.getParent();
                if (!scheduledJobsCtrBO.isJSAuthorized()) {
                    Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_NO_SCHEDJOB_ROLE"));
                    return;
                }
                ScheduledJobSO scheduledJobSO = new ScheduledJobSO(jobSO.getConnection());
                JobSchedulerWizard jobSchedulerWizard = new JobSchedulerWizard(scheduledJobSO, jobSO, this.getParent());
                JobSchedulerWizard.showDialog(jFrame, jobSchedulerWizard);
                break;
            }
            case 3002: {
                scheduledJobsCtrBO = (ScheduledJobsCtrBO)this._parentBO.getParent();
                if (!scheduledJobsCtrBO.isJSAuthorized()) {
                    Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_NO_JS_COPY_ROLE"));
                    return;
                }
                String string = JOptionPane.showInputDialog(jFrame, ASEUtils.getString("NAME_JOB_INPUT_DIALOG_TEXT"), ASEUtils.getString("NAME_JOB_INPUT_DIALOG_TITLE"), 3);
                if (string == null) break;
                try {
                    jobSO.copy(string);
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                }
                this._parent.refresh();
                break;
            }
            case 106: {
                scheduledJobsCtrBO = (ScheduledJobsCtrBO)this._parentBO.getParent();
                if (!scheduledJobsCtrBO.isJSAuthorized()) {
                    Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_NO_JS_DELETE_ROLE"));
                    return;
                }
                super.onCommand(jFrame, n, enumeration, n2);
                break;
            }
            default: {
                super.onCommand(jFrame, n, enumeration, n2);
            }
        }
    }
}

