/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.JobBO;
import com.sybase.aseplugin.bo.ScheduledJobsCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.JobWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.JobSO;
import com.sybase.aseplugin.so.JobTemplateCtrSO;
import com.sybase.aseplugin.so.JobsCtrSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;

public class JobsCtrBO
extends ASEBaseContainer2 {
    private ScheduledJobsCtrBO _parentBO;
    private JobsCtrSO _ctrSO;
    private JobTemplateCtrSO _tmplCtrSO;
    private Hashtable _grpOrderedTmpls;
    private ASEMenuItem _allUsersItem;
    private boolean _showAllUsers;
    static final int JOB_NAME = 1;
    static final int JOB_ID = 2;
    static final int JOB_OWNER = 3;
    static final int JOB_CREATED = 4;
    static final int JOB_COMMENT = 5;
    private static final int CMD_ALL_USERS = 3001;
    private static final int CMD_NEW_JOB = 3002;

    public JobsCtrBO(ScheduledJobsCtrBO scheduledJobsCtrBO) {
        super(ASEUtils.getString("DNAME_JOBS"), (ASEBaseContainer2)scheduledJobsCtrBO);
        this._parentBO = scheduledJobsCtrBO;
        this._ctrSO = new JobsCtrSO(this._parent.getConnection());
        this._tmplCtrSO = new JobTemplateCtrSO(this._parent.getConnection());
        this._showAllUsers = false;
    }

    public JobsCtrBO(ScheduledJobsCtrBO scheduledJobsCtrBO, ASConnection aSConnection) {
        super(ASEUtils.getString("DNAME_JOBS"), (ASEBaseContainer2)scheduledJobsCtrBO);
        this._parentBO = scheduledJobsCtrBO;
        this._ctrSO = new JobsCtrSO(aSConnection);
        this._tmplCtrSO = new JobTemplateCtrSO(aSConnection);
        this._showAllUsers = false;
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        return new ASEBaseHeader[]{new ASEBaseHeader(ASEUtils.getString("DISP_JOB_NAME_TEXT"), 0, 170), new ASEBaseHeader(ASEUtils.getString("DISP_ID_TEXT"), 1, 80, 1), new ASEBaseHeader(ASEUtils.getString("DISP_CREATOR_TEXT"), 2, 70), new ASEBaseHeader(ASEUtils.getString("DISP_CREATION_DATE_TEXT"), 3, 140, 2), new ASEBaseHeader(ASEUtils.getString("DISP_COMMENT_TEXT"), 4, 280)};
    }

    @Override
    public String getDisplayName(int n) {
        return n == 0 ? super.getDisplayName(n) : "";
    }

    public Hashtable getJSTemplates() {
        try {
            if (this._grpOrderedTmpls == null) {
                this._grpOrderedTmpls = this._tmplCtrSO.getTemplateSOsByGroup();
            }
        }
        catch (SQLException sQLException) {
            this._grpOrderedTmpls = new Hashtable();
        }
        return this._grpOrderedTmpls;
    }

    @Override
    public Vector getItems(int n) throws Exception {
        this._ctrSO.setShowAllUsers(this._showAllUsers);
        Vector<JobBO> vector = new Vector<JobBO>();
        Vector vector2 = (Vector)this._ctrSO.open(1, null);
        for (int i = 0; i < vector2.size(); ++i) {
            vector.addElement(new JobBO(this, (JobSO)vector2.elementAt(i)));
        }
        return vector;
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        String string = ASEUtils.getString("MSG_JOB_TYPE");
        String string2 = ASEUtils.getString("CREATION_HINT_NEW_JOB");
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3002, string, string2, Support.getMnemonic("CREATION_MNEM_NEW_JOB"), JobBO.JOB_ICON);
        return new ASEMenuItem[]{aSEMenuItem};
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3002, JobBO.NEW_JOB_ICON, ASEUtils.getString("MSG_JOB_TYPE"), ASEUtils.getString("CREATION_HINT_NEW_JOB"));
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public SCMenu getContextMenu() {
        if (!this._parentBO.isAdministrator()) {
            return null;
        }
        if (this._contextMenu == null) {
            this._contextMenu = new ASEMenu();
            this._allUsersItem = new ASEMenuItem(4, 3001, ASEUtils.getString("CONTEXT_MENU_SHOWALLUSERS_JOB_TEXT"), ASEUtils.getString("CONTEXT_MENU_SHOWALLUSERS_JOB_HINT"), Support.getMnemonic("CONTEXT_MENU_SHOWALLUSERS_MNEM"));
            this._allUsersItem.setSelected(this._showAllUsers);
            this._contextMenu.addItem((SCMenuItem)this._allUsersItem);
        }
        return this._contextMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        if (n == 3001) {
            this._showAllUsers = !this._showAllUsers;
            this._allUsersItem.setSelected(this._showAllUsers);
            this.refresh();
        } else if (n == 3002) {
            ScheduledJobsCtrBO scheduledJobsCtrBO = (ScheduledJobsCtrBO)this.getParent();
            if (!scheduledJobsCtrBO.isJSAuthorized()) {
                Support.showInfo(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_NO_JOB_ROLE"));
            } else {
                JobSO jobSO = new JobSO(this.getConnection(), this._ctrSO);
                ASEBaseDialog2.showDialog(jFrame, new JobWizard(jobSO, (ASEBaseContainer2)this));
            }
        } else {
            super.onCommand(jFrame, n, enumeration, n2);
        }
    }
}

