/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ChangeEncryptionKeyPasswordDialog;
import com.sybase.aseplugin.bo.dlg.KeyRecoveryDialog;
import com.sybase.aseplugin.bo.dlg.PrepareKeyRecoveryDialog;
import com.sybase.aseplugin.bo.dlg.SupplyEncryptionKeyPasswordDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.KeyCopyProperties;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.KeyCopySO;
import com.sybase.aseplugin.so.KeySO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class KeyCopyBO
extends ASEBaseItem2 {
    public static final ImageIcon ICON_KEYCOPY = new ImageIcon(ASEImages.getEncryptionKeyCopySmallImage());
    public static final ImageIcon NEW_KEYCOPY_ICON = new ImageIcon(ASEImages.getNewEncryptionKeyCopyImage());
    public static final ImageIcon ICON_RECOVERY_KEYCOPY = new ImageIcon(ASEImages.getEncryptionKeyRecoveryCopySmallImage());
    private static final int CMD_CHANGE_PASSWORD = 3070;
    private static final int CMD_SUPPLY_PASSWORD = 3071;
    private static final int CMD_KEY_RECOVERY = 3072;
    private static final int CMD_PREPARE_KEY_RECOVERY_WITH_PWD = 3073;

    public KeyCopyBO(KeyCopySO keyCopySO, ASEBaseContainer2 aSEBaseContainer2) {
        super((SOItemInterface)keyCopySO, aSEBaseContainer2, (Icon)ICON_KEYCOPY);
        if (keyCopySO.IsKeyRecovery()) {
            this.setImageIcon(ICON_RECOVERY_KEYCOPY);
        }
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        return new KeyCopyProperties((KeyCopySO)this.getSO(), (SCContainer2)this.getParent());
    }

    @Override
    public boolean includeDDLGen() {
        return false;
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return ((KeyCopySO)this.getSO()).getAssignee() + "." + ((KeyCopySO)this.getSO()).getKeyName();
            }
            case 1: {
                return ((KeyCopySO)this.getSO()).getKeyName();
            }
            case 2: {
                return ((KeyCopySO)this.getSO()).getAssignee();
            }
            case 3: {
                return ((KeyCopySO)this.getSO()).getOwner();
            }
            case 4: {
                return Support.getYesNoString(((KeyCopySO)this.getSO()).IsKeyRecovery());
            }
            case 5: {
                return ((KeyCopySO)this.getSO()).getPasswordType();
            }
        }
        return "";
    }

    @Override
    public SCMenu getContextMenu() {
        ASEMenuItem aSEMenuItem;
        if (this._contextMenu != null) {
            return this._contextMenu;
        }
        this._contextMenu = new ASEMenu();
        ASEMenu aSEMenu = new ASEMenu(ASEUtils.getString("DISP_PASSWORD_TEXT"));
        aSEMenu.setMnemonic(Support.getMnemonic("MNEM_PASSWORD"));
        if (((KeyCopySO)this.getSO()).getAssignee().equals(((KeyCopySO)this.getSO()).getCurrentUser())) {
            aSEMenuItem = new ASEMenuItem(3070, ASEUtils.getString("CMD_CHANGE"), ASEUtils.getString("HINT_CHANGE_PASSWORD"), Support.getMnemonic("MNEM_CHANGE_PASSWORD"));
            aSEMenu.addItem((SCMenuItem)aSEMenuItem);
        }
        if (((KeyCopySO)this.getSO()).isUser(((KeyCopySO)this.getSO()).getPasswordType()) && !((KeyCopySO)this.getSO()).IsKeyRecovery() && ((KeyCopySO)this.getSO()).getAssignee().equals(((KeyCopySO)this.getSO()).getCurrentUser())) {
            aSEMenuItem = new ASEMenuItem(3071, ASEUtils.getString("CMD_SUPPLY"), ASEUtils.getString("HINT_SUPPLY_PASSWORD_FOR_KEY"), Support.getMnemonic("MNEM_SUPPLY_PASSWORD"));
            aSEMenu.addItem((SCMenuItem)aSEMenuItem);
        }
        if (aSEMenu.getMenuItems().length > 0) {
            this._contextMenu.addItem((SCMenuItem)aSEMenu);
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        }
        if ((((KeyCopySO)this.getSO()).getOwner().equals(((KeyCopySO)this.getSO()).getCurrentUser()) || ((KeyCopySO)this.getSO()).getConnection().hasSSORole()) && ((KeyCopySO)this.getSO()).IsKeyRecovery()) {
            aSEMenuItem = new ASEMenuItem(3072, ASEUtils.getString("CMD_KEY_RECOVERY"), ASEUtils.getString("HINT_KEY_RECOVERY"), Support.getMnemonic("MNEM_KEY_RECOVERY"));
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        }
        if (this.includeDelete()) {
            this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        }
        this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        return this._contextMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        if (enumeration != null && n == 3070) {
            DatabaseSO databaseSO = ((KeyCopySO)this.getSO()).getDatabaseSO();
            ChangeEncryptionKeyPasswordDialog changeEncryptionKeyPasswordDialog = new ChangeEncryptionKeyPasswordDialog(Support.createDialogSupport(jFrame), (KeyCopySO)this.getSO(), databaseSO.getMinPasswordLength(), (Object)this.getParent());
            changeEncryptionKeyPasswordDialog.start(this);
            if (changeEncryptionKeyPasswordDialog.getCloseState()) {
                this.getParent().refresh();
            }
        } else if (enumeration != null && n == 3071) {
            SupplyEncryptionKeyPasswordDialog supplyEncryptionKeyPasswordDialog = new SupplyEncryptionKeyPasswordDialog(Support.createDialogSupport(jFrame), KeySO.enumToArrayListWithFullyQualifiedName(enumeration));
            supplyEncryptionKeyPasswordDialog.start(this);
        } else if (enumeration != null && n == 3072) {
            DatabaseSO databaseSO = ((KeyCopySO)this.getSO()).getDatabaseSO();
            KeyRecoveryDialog keyRecoveryDialog = new KeyRecoveryDialog(Support.createDialogSupport(jFrame), (KeyCopySO)this.getSO(), databaseSO.getMinPasswordLength());
            keyRecoveryDialog.start(this);
        } else if (enumeration != null && n == 3073) {
            PrepareKeyRecoveryDialog prepareKeyRecoveryDialog = new PrepareKeyRecoveryDialog(Support.createDialogSupport(jFrame), (KeyCopySO)this.getSO());
            prepareKeyRecoveryDialog.start(this);
        } else {
            super.onCommand(jFrame, n, enumeration, n2);
        }
    }

    @Override
    public boolean isOkToBatch(int n) {
        return super.isOkToBatch(n) || n == 3071;
    }
}

