/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseDetailsContainer;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.LogBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.so.LogSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.central.SCItem;
import com.sybase.ua.AuthorizationException;
import java.sql.SQLException;

public class LogsDetailsBO
extends ASEBaseDetailsContainer {
    public LogsDetailsBO(ServerBO serverBO) {
        super(ASEUtils.getString("DNAME_SERVER_LOG"), serverBO);
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        ASEBaseHeader aSEBaseHeader = new ASEBaseHeader(ASEUtils.getString("DISP_DATE_TEXT"), 0, 170, 2);
        ASEBaseHeader aSEBaseHeader2 = new ASEBaseHeader(ASEUtils.getString("DISP_SOURCE_TEXT"), 1, 80);
        ASEBaseHeader aSEBaseHeader3 = new ASEBaseHeader(ASEUtils.getString("DISP_MESSAGE_TEXT"), 2, 280);
        ASEBaseHeader aSEBaseHeader4 = new ASEBaseHeader(ASEUtils.getString("DISP_ENGINE_NUMBER_TEXT"), 3, 80);
        ASEBaseHeader aSEBaseHeader5 = new ASEBaseHeader(ASEUtils.getString("DISP_FAMILY_ID_TEXT"), 4, 80);
        ASEBaseHeader aSEBaseHeader6 = new ASEBaseHeader(ASEUtils.getString("DISP_PROCESS_ID_TEXT"), 5, 80);
        ASEBaseHeader aSEBaseHeader7 = new ASEBaseHeader(ASEUtils.getString("DISP_DESC_TEXT"), 6, 80);
        return new ASEBaseHeader[]{aSEBaseHeader, aSEBaseHeader2, aSEBaseHeader3, aSEBaseHeader4, aSEBaseHeader5, aSEBaseHeader6, aSEBaseHeader7};
    }

    @Override
    void populate() throws SQLException {
        ServerBO serverBO = (ServerBO)this.getParent();
        ServerSO serverSO = (ServerSO)serverBO.getSO();
        this._helper.setStatusBarMessage(serverSO.getServerLogsFilterMessage());
        if (this.isOpened()) {
            return;
        }
        this.clearItems();
        String string = null;
        String[] stringArray = null;
        try {
            stringArray = serverSO.getLogEntries();
        }
        catch (AuthorizationException authorizationException) {
            string = ServerBO.getAuthenticationErrorMessage("getASELogFiltered", serverSO);
        }
        catch (Exception exception) {
            string = new ASEMessageText(ASEUtils.getString("MSG_OPERATION_FAILED"), "getASELogFiltered", serverSO.getName()).toString();
        }
        if (string != null) {
            throw new SQLException(string);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                LogBO logBO = new LogBO(this, new LogSO(serverSO, string2));
                this.addItem((SCItem)logBO);
            }
        }
    }
}

