/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.PartitionsCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TableBO;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.PartitionProperties;
import com.sybase.aseplugin.bo.wiz.RestoreDataWizard;
import com.sybase.aseplugin.bo.wiz.UpdateStatWizard;
import com.sybase.aseplugin.so.PartitionSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.sql.SQLListener;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class PartitionBO
extends ASEBaseItem2 {
    public static final ImageIcon PARTITION_ICON = new ImageIcon(ASEImages.getPartitionSmallImage());
    public static final ImageIcon NEW_PARTITION_ICON = new ImageIcon(ASEImages.getNewPartitionImage());
    public static final ImageIcon RE_PARTITION_ICON = new ImageIcon(ASEImages.getRepartitionImage());
    public static final int CMD_UPDATE_STATS = 3080;
    public static final int CMD_DELETE_STATS = 3081;
    private static final int CMD_RESTORE_DATA = 3082;

    public PartitionBO(PartitionSO partitionSO, PartitionsCtrBO partitionsCtrBO) {
        super((SOItemInterface)partitionSO, partitionsCtrBO, (Icon)PARTITION_ICON);
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        return new PartitionProperties((PartitionSO)this.getSO(), (PartitionsCtrBO)this.getParent());
    }

    private boolean isPartitionDeleteApplicable() {
        TableSO tableSO = ((PartitionSO)this.getSO()).getTableSO();
        try {
            if (tableSO.getConnection().getVersion().compareTo("15.0.1") >= 0 && ((PartitionSO)this.getSO()).getPartitionType() == 1 && tableSO.isRangeOrListPartitioned() && tableSO.getNumberPartitions() > 1) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), ASEMessageText.toString(sQLException), sQLException);
        }
        return false;
    }

    @Override
    public boolean includeDelete() {
        return super.includeDelete() && this.isPartitionDeleteApplicable();
    }

    @Override
    public SCMenu getContextMenu() {
        if (this._contextMenu != null) {
            return this._contextMenu;
        }
        this._contextMenu = new ASEMenu();
        if (super.includeDelete()) {
            String string = this.enableDelete() ? null : this.getDisabledDeleteHint();
            this._contextMenu.addItem((SCMenuItem)TableBO.getStatisticsMenu(3080, string));
            if (((PartitionSO)this.getSO()).getPartitionType() == 1) {
                this._contextMenu.addItem((SCMenuItem)TableBO.getStatisticsMenu(3081, string));
            }
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            TableSO tableSO = ((PartitionSO)this.getSO()).getTableSO();
            try {
                if (tableSO.includeRestore() && tableSO.isRangeOrListPartitioned()) {
                    this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3082, ASEUtils.getString("CONTEXT_MENU_RESTORE_DATA_TEXT"), ASEUtils.getString("CONTEXT_MENU_RESTORE_DATA_HINT"), Support.getMnemonic("RESTORE_DATA_MNEM")));
                    this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), ASEMessageText.toString(sQLException), sQLException);
            }
        }
        if (this.includeDelete()) {
            this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        }
        this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        return this._contextMenu;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 3080: 
            case 3081: {
                ArrayList arrayList = Support.enumToArrayList(enumeration);
                PartitionBO partitionBO = (PartitionBO)arrayList.get(0);
                PartitionSO partitionSO = (PartitionSO)partitionBO.getSO();
                UpdateStatWizard updateStatWizard = new UpdateStatWizard(partitionSO, arrayList, n, (SCContainer2)this.getParent());
                ASEBaseDialog2.showDialog(jFrame, updateStatWizard);
                return;
            }
            case 3082: {
                TableSO tableSO = ((PartitionSO)this.getSO()).getTableSO();
                SQLListener sQLListener = tableSO.getConnection().getSQLListener();
                tableSO.getConnection().setSQLListener(null);
                try {
                    ASEMessageText aSEMessageText;
                    int n3;
                    int n4 = ((PartitionSO)this.getSO()).getNumberOfRows();
                    tableSO.getConnection().setSQLListener((Object)sQLListener);
                    if (n4 > 0 && (n3 = Support.showQuestionYesNo((aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_PT_HAS_ROWS"), ((PartitionSO)this.getSO()).getName())).toString())) == 1) {
                        return;
                    }
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                    tableSO.getConnection().setSQLListener((Object)sQLListener);
                    return;
                }
                try {
                    if (!tableSO.getDatabaseSO().getOptionStatus("select into/bulkcopy/pllsort")) {
                        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_SELECT_INTO_NOT_ENABLED"), tableSO.getDatabaseName());
                        Support.showError(this.getConnection(), this.getClass(), aSEMessageText.toString());
                        return;
                    }
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                    return;
                }
                try {
                    if (tableSO.hasIndex()) {
                        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_TABLE_HAS_INDEX"), tableSO.getName());
                        Support.showError(this.getConnection(), this.getClass(), aSEMessageText.toString());
                        return;
                    }
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                    return;
                }
                RestoreDataWizard restoreDataWizard = new RestoreDataWizard((PartitionSO)this.getSO(), (SCContainer2)this.getParent());
                ASEBaseDialog2.showDialog(jFrame, restoreDataWizard);
                return;
            }
        }
        super.onCommand(jFrame, n, enumeration, n2);
    }

    @Override
    public boolean isOkToBatch(int n) {
        return super.isOkToBatch(n) || n == 3081 || n == 3080;
    }
}

