/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.IndexBO;
import com.sybase.aseplugin.bo.PartitionBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TableBO;
import com.sybase.aseplugin.bo.wiz.AddPartitionWizard;
import com.sybase.aseplugin.bo.wiz.PartitionWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.IndexSO;
import com.sybase.aseplugin.so.PartitionSO;
import com.sybase.aseplugin.so.PartitionsCtrSO;
import com.sybase.aseplugin.so.TableSO;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;

public class PartitionsCtrBO
extends ASEBaseContainer2 {
    private static final int NAME = 0;
    private static final int SEGMENT = 1;
    private static final int CR_DATE = 2;
    public static final int TYPE_DATA = 1;
    public static final int TYPE_INDEX = 2;
    public static final int CMD_RE_PARTITION = 3171;
    private int _type;
    private IndexSO _indexSO;

    public PartitionsCtrBO(TableBO tableBO) {
        super(ASEUtils.getString("DNAME_DATA_PARTTIONS"), (ASEBaseContainer2)tableBO);
    }

    public PartitionsCtrBO(IndexBO indexBO) {
        super(ASEUtils.getString("DNAME_INDEX_PARTTIONS"), (ASEBaseContainer2)indexBO, ((IndexSO)indexBO.getSO()).getTableSO());
        this._indexSO = (IndexSO)indexBO.getSO();
    }

    public void setType(int n) {
        this._type = n;
        TableSO tableSO = (TableSO)this.getSO();
        PartitionsCtrSO partitionsCtrSO = this._type == 1 ? new PartitionsCtrSO(this.getConnection(), tableSO) : new PartitionsCtrSO(this.getConnection(), tableSO, this._indexSO);
        this.setCtrSO(partitionsCtrSO);
    }

    private boolean canRepartition() {
        return this.getCtrSO().enableCreate() && this._type != 2;
    }

    private boolean canAddPartition() {
        TableSO tableSO = (TableSO)this.getSO();
        boolean bl = false;
        try {
            String string = tableSO.getPartitionStrategy();
            bl = string.equals("range") || string.equals("list");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.canRepartition() && bl;
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        if (this.canAddPartition()) {
            String string = ASEUtils.getString("MSG_PARTITION_TYPE");
            String string2 = ASEUtils.getString("CREATION_HINT_NEW_PARTITION");
            ASEMenuItem aSEMenuItem = new ASEMenuItem(3070, string, string2, Support.getMnemonic("CREATION_MNEM_NEW_PARTITION"), PartitionBO.PARTITION_ICON);
            return new ASEMenuItem[]{aSEMenuItem};
        }
        return null;
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        if (this.canAddPartition()) {
            ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3070, PartitionBO.NEW_PARTITION_ICON, ASEUtils.getString("MSG_PARTITION_TYPE"), ASEUtils.getString("CREATION_HINT_NEW_PARTITION"));
            return new ASEToolBarButton[]{aSEToolBarButton};
        }
        return null;
    }

    @Override
    public ASEToolBarButton[] getContextButtons() {
        if (this.canRepartition()) {
            ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3171, PartitionBO.RE_PARTITION_ICON, ASEUtils.getString("MSG_REPARTITION"), ASEUtils.getString("CREATION_HINT_NEW_PARTITION"));
            return new ASEToolBarButton[]{aSEToolBarButton};
        }
        return null;
    }

    @Override
    public int[] getEnabledContextCmdIds() {
        return new int[]{3171};
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        ASEBaseHeader aSEBaseHeader = new ASEBaseHeader(ASEUtils.getString("DISP_NAME_TEXT"), 0, 170);
        ASEBaseHeader aSEBaseHeader2 = new ASEBaseHeader(ASEUtils.getString("MSG_SEGMENT_TYPE"), 1, 170);
        ASEBaseHeader aSEBaseHeader3 = new ASEBaseHeader(ASEUtils.getString("DISP_CREATION_DATE_TEXT"), 2, 140);
        return new ASEBaseHeader[]{aSEBaseHeader, aSEBaseHeader2, aSEBaseHeader3};
    }

    @Override
    public Vector getItems(int n, Object[] objectArray) throws SQLException {
        Vector<PartitionBO> vector = new Vector<PartitionBO>();
        List list = ((PartitionsCtrSO)this.getCtrSO()).open(1, this._type);
        for (PartitionSO partitionSO : list) {
            vector.add(new PartitionBO(partitionSO, this));
        }
        return vector;
    }

    @Override
    public String getDisabledCreateHint() {
        return ASEUtils.getString("CONTEXT_MENU_DELETE_MORE_DB_HINT");
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        TableSO tableSO = (TableSO)this.getSO();
        PartitionSO partitionSO = new PartitionSO(this.getConnection(), tableSO);
        if (n == 3070) {
            ASEBaseDialog2.showDialog(jFrame, new AddPartitionWizard(partitionSO, this));
        } else if (n == 3171) {
            try {
                if (!partitionSO.getTableSO().getDatabaseSO().getOptionStatus("select into/bulkcopy/pllsort")) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_SELECT_INTO_NOT_ENABLED"), partitionSO.getTableSO().getDatabaseName());
                    Support.showError(this.getConnection(), this.getClass(), aSEMessageText.toString());
                    return;
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                return;
            }
            ASEBaseDialog2.showDialog(jFrame, new PartitionWizard(partitionSO, this));
        } else {
            super.onCommand(jFrame, n, enumeration, n2);
        }
    }
}

