/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.bo.TextQueue;
import com.sybase.aseplugin.go.ASEEditor;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLListener;

public class PreviewTracer
implements SQLListener {
    public static final int TRACE_STOP = 0;
    public static final int TRACE_START = 1;
    public static final String STOP_TRACING = "stop pv tracing";
    private ASEEditor _windowTracer;
    private TextQueue _q = new TextQueue();
    private ASConnection _conn;
    private boolean _contentText = false;

    public PreviewTracer(ASConnection aSConnection, ASEEditor aSEEditor) {
        this._windowTracer = aSEEditor;
        this._conn = aSConnection;
    }

    public void init() {
        Thread thread = new Thread("SQL Preview tracer"){

            @Override
            public void run() {
                String string;
                boolean bl;
                do {
                    string = PreviewTracer.this._q.getText();
                    bl = true;
                } while (bl = PreviewTracer.this.traceContents(string));
            }
        };
        thread.start();
    }

    @Override
    public boolean traceSQL(String string) {
        this._q.putText(string + "\n" + "go" + "\n");
        this._contentText = true;
        return true;
    }

    @Override
    public boolean needOutput() {
        return false;
    }

    @Override
    public boolean needRowNumbers() {
        return false;
    }

    @Override
    public void traceOutput(String string) {
    }

    @Override
    public void traceElapsedTime() {
    }

    @Override
    public void stopTracing() {
        this.traceSQL(STOP_TRACING);
        this._conn.removeSQLPreviewListener(this);
    }

    private boolean traceContents(String string) {
        if (this._windowTracer == null || string != null && string.startsWith(STOP_TRACING)) {
            return false;
        }
        this._windowTracer.append(string);
        return true;
    }

    public boolean available() {
        return this._contentText;
    }
}

