/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ItemsConfirmDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.ProcessProperties;
import com.sybase.aseplugin.so.ProcessSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class ProcessBO
extends ASEBaseItem2 {
    public static final ImageIcon PROCESS_ICON = new ImageIcon(ASEImages.getNormalProcessSmallImage());
    public static final ImageIcon BLOCKED_PROCESS_ICON = new ImageIcon(ASEImages.getBlockedProcessSmallImage());
    public static final ImageIcon BLOCKING_PROCESS_ICON = new ImageIcon(ASEImages.getBlockingProcessSmallImage());

    public ProcessBO(ProcessSO processSO, ASEBaseContainer2 aSEBaseContainer2) {
        super((SOItemInterface)processSO, aSEBaseContainer2, (Icon)(processSO.isBlocked() ? BLOCKED_PROCESS_ICON : (processSO.isBlocking() ? BLOCKING_PROCESS_ICON : PROCESS_ICON)));
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        ProcessSO processSO = (ProcessSO)this.getSO();
        if (processSO != null && processSO.isBlocked() && !processSO.isMerged()) {
            ProcessBO processBO = ContainerViewBO.getProcessBO((ServerBO)this.getParent().getParent(), processSO.getName());
            ProcessSO processSO2 = (ProcessSO)processBO.getSO();
            processSO2.merge(processSO);
        }
        return new ProcessProperties(processSO, (SCContainer2)this.getParent());
    }

    @Override
    public int getAttributes() {
        return -5;
    }

    @Override
    public SCMenu getContextMenu() {
        if (this._contextMenu != null) {
            return this._contextMenu;
        }
        this._contextMenu = new ASEMenu();
        String string = ASEUtils.getString("CONTEXT_MENU_KILL_TEXT");
        String string2 = ASEUtils.getString("CONTEXT_MENU_KILL_HINT");
        this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getDeleteMenuItem(string, string2, Support.getMnemonic("CONTEXT_MENU_KILL_MNEM"), this.enableDelete(), this.getDisabledDeleteHint()));
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        return this._contextMenu;
    }

    @Override
    void deleteItems(JFrame jFrame, Enumeration enumeration) {
        ArrayList arrayList = this.getBatchList(106, enumeration);
        ItemsConfirmDialog itemsConfirmDialog = new ItemsConfirmDialog(Support.createDialogSupport(jFrame), ASEUtils.getString("MSG_CONFIRM_KILL_PROCESS"), ASEUtils.getString("DNAME_PROCESSES"), null, this, arrayList);
        if (itemsConfirmDialog.start(this)) {
            if (this.getParent() != null) {
                this.getParent().refresh();
            } else if (this.getDetailsParent() != null) {
                this.getDetailsParent().refresh();
            }
        }
    }
}

