/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.RLImages;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ArticleBO;
import com.sybase.aseplugin.bo.ConnectionBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.PublicationProp;
import com.sybase.aseplugin.bo.wiz.ArticleWizard;
import com.sybase.aseplugin.bo.wiz.SubscriptionWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.ArticleSO;
import com.sybase.aseplugin.so.ConnectionSO;
import com.sybase.aseplugin.so.PublicationSO;
import com.sybase.aseplugin.so.SubscriptionSO;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class PublicationBO
extends ASEBaseContainer2 {
    static final int PUB_NAME = 0;
    private static final int CMD_SUBSCRIBE = 3001;
    private static final int NEW_ARTICLE = 3002;
    public static final ImageIcon PUBLICATION_ICON = new ImageIcon(RLImages.getPublicationSmallImage());
    public static final ImageIcon NEW_PUBLICATION_ICON = new ImageIcon(RLImages.getNewPublicationImage());

    PublicationBO(ConnectionBO connectionBO, PublicationSO publicationSO) {
        super(publicationSO.getLongName(), (ASEBaseContainer2)connectionBO, publicationSO);
    }

    public String getDDB() {
        return ((PublicationSO)this.getSO()).getDDB();
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3002, ASEUtils.getString("MSG_ADD_ARTICLE"), ASEUtils.getString("MSG_ADD_ARTICLE"), Support.getMnemonic("CREA_MNEM"), ArticleBO.PRIMARY_ARTICLE_TABLE_ICON);
        return new ASEMenuItem[]{aSEMenuItem};
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3002, ArticleBO.NEW_PRIMARY_ARTICLE_ICON, ASEUtils.getString("MSG_ADD_ARTICLE"), ASEUtils.getString("MSG_ADD_ARTICLE"));
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public Vector getItems(int n) throws SQLException {
        Vector<ArticleBO> vector = new Vector<ArticleBO>();
        Enumeration enumeration = ArticleSO.getPrimaryArticles(this.getConnection(), this.getDDB(), this.getSO().getDisplayName());
        while (enumeration.hasMoreElements()) {
            ArticleSO articleSO = (ArticleSO)enumeration.nextElement();
            articleSO.setPublication((PublicationSO)this.getSO());
            vector.addElement(new ArticleBO(this, articleSO));
        }
        return vector;
    }

    @Override
    public Icon getImage(boolean bl) {
        return PUBLICATION_ICON;
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getSO().getDisplayName();
            }
        }
        return "";
    }

    @Override
    public SCMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ASEMenu();
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3001, ASEUtils.getString("CONTEXT_MENU_SUBSCRIBE_TEXT"), ASEUtils.getString("CONTEXT_MENU_SUBSCRIBE_HINT"), Support.getMnemonic("ACTN_MNEM_SUBSCRIBE")));
            this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        }
        return this._contextMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 107: {
                PublicationProp publicationProp = new PublicationProp((PublicationSO)this.getSO(), (SCContainer2)this.getParent());
                ASEBaseDialog2.showDialog(jFrame, publicationProp);
                break;
            }
            case 106: {
                int n3 = Support.showQuestionYesNo(jFrame, ASEUtils.getString("MSG_DELETE_OBJECT_QUESTION"));
                if (n3 != 0) break;
                Support.getViewerSupport().startWait();
                while (enumeration.hasMoreElements()) {
                    try {
                        PublicationBO publicationBO = (PublicationBO)enumeration.nextElement();
                        publicationBO.getSO().remove();
                    }
                    catch (SQLException sQLException) {
                        Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                    }
                }
                Support.getViewerSupport().endWait();
                ((ConnectionBO)this.getParent()).refresh();
                break;
            }
            case 3001: {
                SubscriptionSO subscriptionSO = new SubscriptionSO(this.getConnection(), this.getDDB(), (ConnectionSO)((ConnectionBO)this.getParent()).getSO());
                SubscriptionWizard subscriptionWizard = new SubscriptionWizard(subscriptionSO, (SCContainer2)this.getParent(), this);
                SubscriptionWizard.myshowDialog(jFrame, subscriptionWizard);
                break;
            }
            case 3002: {
                ArticleSO articleSO = new ArticleSO(this.getConnection(), this.getDDB());
                articleSO.setPublication((PublicationSO)this.getSO());
                ArticleWizard articleWizard = new ArticleWizard(articleSO, this);
                ASEBaseDialog2.showDialog(jFrame, articleWizard);
                break;
            }
        }
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 96;
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        return new ASEBaseHeader[]{new ASEBaseHeader(ASEUtils.getString("DISP_ARTICLE_HDR"), 0, 170), new ASEBaseHeader(ASEUtils.getString("DISP_TYPE_HDR"), 1, 170), new ASEBaseHeader(ASEUtils.getString("DISP_OWNER_HDR"), 2, 170)};
    }
}

