/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.aseplugin.ASEConstants;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.ScheduledJobBO;
import com.sybase.aseplugin.bo.ScheduledJobsCtrBO;
import com.sybase.aseplugin.bo.SchedulesCtrBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.RemoteJobSchedulingWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.RegisteredJSSO;
import com.sybase.aseplugin.so.RemoteJobSchedulingSO;
import com.sybase.aseplugin.so.ScheduledJobsCtrSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.util.ds.Utils;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;

public class RJSScheduledJobsBO
extends ASEBaseContainer2
implements ASEConstants {
    private static final int CMD_NEW_SCHEDULED_JOB = 3001;
    private ScheduledJobsCtrBO _sjCtrBO = null;
    private ScheduledJobsCtrSO _remoteSJCtrSO = null;
    private ASConnection _jsConn = null;
    private boolean _jsAvailable = false;
    private boolean _jsUser = false;
    private boolean _refresh = false;

    public RJSScheduledJobsBO(ServerBO serverBO) {
        super(ASEUtils.getString("DNAME_RJSCHEDULING"), (ASEBaseContainer2)serverBO);
        this._sjCtrBO = ContainerViewBO.getScheduledJobsCtrBO(serverBO);
        this.init();
    }

    private void init() {
        this._jsConn = this.findJSConnection();
        if (this._jsConn != null) {
            this._remoteSJCtrSO = new ScheduledJobsCtrSO(this._jsConn);
            this._jsAvailable = true;
        } else {
            this._jsAvailable = false;
        }
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        return null;
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        String string = ASEUtils.getString("MSG_SCHEDULEDJOB_TYPE");
        String string2 = ASEUtils.getString("CREATION_HINT_NEW_SCHEDULEDJOB");
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3001, string, string2, Support.getMnemonic("CREATION_MNEM_NEW_SCHEDULEDJOB"), ScheduledJobBO.SCHEDULEDJOB_ICON);
        return new ASEMenuItem[]{aSEMenuItem};
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3001, ScheduledJobBO.NEW_SCHEDULEDJOB_ICON, ASEUtils.getString("MSG_SCHEDULEDJOB_TYPE"), ASEUtils.getString("CREATION_HINT_NEW_SCHEDULEDJOB"));
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        if (n == 3001) {
            RemoteJobSchedulingSO remoteJobSchedulingSO = new RemoteJobSchedulingSO(this.getJSConnection(), this.getConnection(), "Remote JS SO");
            ASEBaseDialog2.showDialog(jFrame, new RemoteJobSchedulingWizard(remoteJobSchedulingSO, (ASEBaseContainer2)this));
        } else {
            super.onCommand(jFrame, n, enumeration, n2);
        }
    }

    @Override
    public Vector getItems(int n) {
        return null;
    }

    public SchedulesCtrBO getSchedules() {
        return new SchedulesCtrBO(this._sjCtrBO, this._jsConn);
    }

    @Override
    public int getAttributes() {
        return 0;
    }

    private ASConnection findJSConnection() {
        ASConnection aSConnection = this.getRegisteredJSConnection();
        if (aSConnection == null) {
            try {
                if (this._sjCtrBO.isSchedulerInstalled()) {
                    aSConnection = this._sjCtrBO.getConnection();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return aSConnection;
    }

    private ASConnection getRegisteredJSConnection() {
        ASConnection aSConnection = null;
        ServerSO serverSO = (ServerSO)this.getSO();
        RegisteredJSSO registeredJSSO = new RegisteredJSSO(serverSO.getConnection(), serverSO);
        if (registeredJSSO.isRegistered()) {
            ASConnection aSConnection2 = this._sjCtrBO.getConnection();
            try {
                ASEConnectionInfo aSEConnectionInfo = aSConnection2.getConnectionInfo();
                aSEConnectionInfo.setServerName(registeredJSSO.getJSServerName());
                aSEConnectionInfo.host = registeredJSSO.getJSMachineName();
                aSEConnectionInfo.port = registeredJSSO.getJSServerPort();
                aSConnection = new ASConnection(aSEConnectionInfo, aSConnection2.getId());
            }
            catch (SQLException sQLException) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_CONNECT_JS"), registeredJSSO.getJSServerName() == null ? Utils.getHostAndPort((String)registeredJSSO.getJSMachineName(), (int)registeredJSSO.getJSServerPort()) : registeredJSSO.getJSServerName());
                Support.addLogEntry(1, this.getConnection(), this.getClass(), aSEMessageText.toString(), ASEMessageText.getSQLExceptionMessage(sQLException));
            }
            catch (ClassNotFoundException classNotFoundException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_NO_JDBC_DRIVER"), classNotFoundException);
            }
        }
        return aSConnection;
    }

    public ScheduledJobsCtrBO getLocalJSFolder() {
        return this._sjCtrBO;
    }

    public boolean isJSUser() {
        if (this._jsAvailable) {
            try {
                if (this._remoteSJCtrSO.isJSAuthorized()) {
                    this._jsUser = this._remoteSJCtrSO.isSybmgmtdbUser();
                }
            }
            catch (SQLException sQLException) {
                this._jsUser = false;
                Support.addLogEntry(1, this.getConnection(), this.getClass(), sQLException.getMessage(), ASEMessageText.getSQLExceptionMessage(sQLException));
            }
        }
        return this._jsUser;
    }

    public boolean isJSServer() {
        try {
            return this._sjCtrBO.isSchedulerInstalled();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public boolean showScheduleButton() {
        return this._jsAvailable && this._jsUser;
    }

    public boolean isJSAvailable() {
        return this._jsAvailable;
    }

    public void setRefresh() {
        this._refresh = true;
    }

    public ASConnection getJSConnection() {
        if (this._refresh) {
            this.init();
            this._refresh = false;
        }
        return this._jsConn;
    }

    public SchedulesCtrBO getJSSchedulesCtrBO() {
        return this._sjCtrBO.getSchedulesFolder();
    }
}

