/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ConnectionBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.SubscriptionBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.ReplicationProp;
import com.sybase.aseplugin.bo.wiz.ConnectionWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.ConnectionSO;
import com.sybase.aseplugin.so.ReplicationSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.util.Debug;
import com.sybase.aseplugin.util.RLStatusMonitor;
import com.sybase.aseplugin.util.TimerManager;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class ReplicationBO
extends ASEBaseContainer2
implements ActionListener {
    private static final int CMD_RESUME = 3001;
    private static final int CMD_SUSPEND = 3002;
    private static final int CMD_SHUTDOWN = 3003;
    private static final int NEW_CONNECTION = 3004;
    private static final int DELAY_DEFAULT = 60;
    private int _monitorDelay = 60;
    private RLStatusMonitor _monitor = null;
    private Timer _refreshTimer;
    private Vector _refreshList;

    public ReplicationBO(ServerBO serverBO) {
        super(ASEUtils.getString("DNAME_REPLICATION"), (ASEBaseContainer2)serverBO);
        this._so = new ReplicationSO(this.getConnection());
        try {
            this._monitorDelay = ((ReplicationSO)this._so).getMonitorDelay();
        }
        catch (Exception exception) {
            this._monitorDelay = 60;
        }
        if (((ReplicationSO)this._so).getMonitoringFlag()) {
            this.startMonitor();
        }
        this._refreshList = new Vector();
    }

    public void setMonitoring() {
        try {
            this._monitorDelay = ((ReplicationSO)this._so).getMonitorDelay();
        }
        catch (Exception exception) {
            this._monitorDelay = 60;
        }
        if (((ReplicationSO)this._so).getMonitoringFlag()) {
            this.startMonitor();
        }
    }

    @Override
    public int getAttributes() {
        return 1;
    }

    public ServerBO getServerBO() {
        return (ServerBO)this.getParent();
    }

    public String getDDB() {
        return ((ReplicationSO)this.getSO()).getDDB();
    }

    public void refreshParent() {
        super.refresh();
    }

    public boolean childExists(String string) {
        return this.getItem(string) != null;
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        if (this.getDDB() != null && this.getDDB().length() > 0) {
            ASEMenuItem aSEMenuItem = new ASEMenuItem(3004, ASEUtils.getString("MSG_ADD_CONNECTION"), ASEUtils.getString("MSG_ADD_CONNECTION"), Support.getMnemonic("CREA_MNEM"), ConnectionBO.PRIMARY_CONNECTION_UP_ICON);
            return new ASEMenuItem[]{aSEMenuItem};
        }
        return null;
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3004, ConnectionBO.NEW_CONNECTION_ICON, ASEUtils.getString("MSG_ADD_CONNECTION"), ASEUtils.getString("MSG_ADD_CONNECTION"));
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public Vector getItems(int n) throws SQLException {
        Vector<ConnectionBO> vector = new Vector<ConnectionBO>();
        if (this.getDDB() == null || this.getDDB().length() == 0) {
            Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_NO_DDB"));
            return vector;
        }
        String string = ((ReplicationSO)this.getSO()).getVersionString();
        if (string == null || string.length() == 0) {
            Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_REPLITE_SERVER_DOWN"));
            return vector;
        }
        Enumeration enumeration = ConnectionSO.getConnections(this.getConnection(), this.getDDB(), (ReplicationSO)this.getSO());
        while (enumeration.hasMoreElements()) {
            vector.addElement(new ConnectionBO(this, (ConnectionSO)enumeration.nextElement()));
        }
        return vector;
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public String getDisplayName(int n) {
        return ASEUtils.getString("DNAME_REPLICATION");
    }

    @Override
    public SCMenu getContextMenu() {
        ASEMenu aSEMenu = new ASEMenu();
        if (this.getDDB() != null && this.getDDB().length() > 0) {
            aSEMenu.addItem((SCMenuItem)new ASEMenuItem(3001, ASEUtils.getString("CONTEXT_MENU_RESUME_TEXT"), ASEUtils.getString("CONTEXT_MENU_RESUME_HINT"), Support.getMnemonic("ACTN_MNEM_RESUME")));
            aSEMenu.addItem((SCMenuItem)new ASEMenuItem(3002, ASEUtils.getString("CONTEXT_MENU_SUSPEND_TEXT"), ASEUtils.getString("CONTEXT_MENU_SUSPEND_HINT"), Support.getMnemonic("ACTN_MNEM_SUSPEND")));
            aSEMenu.addItem((SCMenuItem)new ASEMenuItem(3003, ASEUtils.getString("CONTEXT_MENU_SHUTDOWN_TEXT"), ASEUtils.getString("CONTEXT_MENU_SHUTDOWN_HINT"), Support.getMnemonic("ACTN_MNEM_SHUTDOWN")));
            aSEMenu.addItem((SCMenuItem)new ASEMenuItem());
            aSEMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        }
        return aSEMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 107: {
                ReplicationProp replicationProp = new ReplicationProp((ReplicationSO)this.getSO(), (SCContainer2)this.getParent(), this);
                ASEBaseDialog2.showDialog(jFrame, replicationProp);
                break;
            }
            case 3001: {
                String string = ASEUtils.getString("MSG_RESUME_REP_CONFIRM");
                int n3 = Support.showQuestionYesNo(jFrame, string);
                if (n3 != 0) break;
                Support.getViewerSupport().startWait();
                try {
                    this.execute(((ReplicationSO)this.getSO()).resume());
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                }
                ((ServerBO)this.getParent()).refresh();
                Support.getViewerSupport().endWait();
                break;
            }
            case 3002: {
                String string = ASEUtils.getString("MSG_SUSPEND_REP_CONFIRM");
                int n4 = Support.showQuestionYesNo(jFrame, string);
                if (n4 != 0) break;
                Support.getViewerSupport().startWait();
                try {
                    this.execute(((ReplicationSO)this.getSO()).suspend());
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                }
                ((ServerBO)this.getParent()).refresh();
                Support.getViewerSupport().endWait();
                break;
            }
            case 3003: {
                this.shutdown(jFrame);
                break;
            }
            case 3004: {
                ConnectionSO connectionSO = new ConnectionSO(this.getConnection(), this.getDDB(), (ReplicationSO)this.getSO());
                ConnectionWizard connectionWizard = new ConnectionWizard(connectionSO, (SCContainer2)this);
                ConnectionWizard.showDialog((Container)jFrame, connectionWizard);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String string) throws SQLException {
        SQLException sQLException = null;
        try {
            this.getConnection().executeCommand(string);
        }
        catch (SQLException sQLException2) {
            if (sQLException == null) {
                sQLException = sQLException2;
            }
            sQLException.setNextException(sQLException2);
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    @Override
    public Icon getImage(boolean bl) {
        Debug.trace(this, "getImage() in RepBO - thread: " + Thread.currentThread().getName());
        ImageIcon imageIcon = null;
        switch (((ReplicationSO)this.getSO()).getState()) {
            case 1: {
                if (bl) {
                    imageIcon = new ImageIcon(ASEImages.getFolderOpenedImage());
                    break;
                }
                imageIcon = new ImageIcon(ASEImages.getFolderClosedImage());
                break;
            }
            case -1: 
            case 0: 
            case 3: {
                if (bl) {
                    imageIcon = new ImageIcon(ASEImages.getFolderOpenedImage());
                    break;
                }
                imageIcon = new ImageIcon(ASEImages.getFolderClosedImage());
                break;
            }
            default: {
                Debug.wassert(false, this, "Invalid Replication State");
            }
        }
        imageIcon = bl ? new ImageIcon(ASEImages.getFolderOpenedImage()) : new ImageIcon(ASEImages.getFolderClosedImage());
        return imageIcon;
    }

    @Override
    public int queryDropItems(int n, DataFlavor[] dataFlavorArray) {
        return -1;
    }

    protected void shutdown(JFrame jFrame) {
        Debug.wassert(jFrame != null, this, "Null frame parameter");
        String string = ASEUtils.getString("MSG_SHUTDOWN_TITLE");
        String string2 = ASEUtils.getString("MSG_SHUTDOWN_IMMEDIATELY");
        String string3 = ASEUtils.getString("MSG_SHUTDOWN_CANCEL");
        int n = JOptionPane.showOptionDialog(jFrame, ASEUtils.getString("MSG_SHUTDOWN_CONFIRM"), ASEUtils.getString("DISP_QUESTION"), 1, 3, null, new String[]{string, string2, string3}, string3);
        try {
            if (n == 0) {
                this.getConnection().executeCommand(((ReplicationSO)this.getSO()).shutdown(false));
            } else if (n == 1) {
                this.getConnection().executeCommand(((ReplicationSO)this.getSO()).shutdown(true));
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), ASEMessageText.toString(sQLException), sQLException);
        }
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        return new ASEBaseHeader[]{new ASEBaseHeader(ASEUtils.getString("DISP_CONN_HDR"), 0, 170), new ASEBaseHeader(ASEUtils.getString("DISP_TYPE_HDR"), 2, 80), new ASEBaseHeader(ASEUtils.getString("DISP_REASON_HDR"), 3, 200)};
    }

    public synchronized void monitorRefresh(Vector vector) {
        Debug.trace(this, "monitorRefresh() in RepBO - thread: " + Thread.currentThread().getName());
        this._refreshList.addAll(vector);
    }

    protected synchronized void refreshRepObjects() {
        Debug.trace(this, "refreshRepObjects in RepBO - thread: " + Thread.currentThread().getName());
        Enumeration enumeration = this._refreshList.elements();
        while (enumeration.hasMoreElements()) {
            ASEBaseContainer2 aSEBaseContainer2 = (ASEBaseContainer2)enumeration.nextElement();
            if (!(aSEBaseContainer2 instanceof ReplicationBO) && !(aSEBaseContainer2 instanceof ConnectionBO) && !(aSEBaseContainer2 instanceof SubscriptionBO)) continue;
            aSEBaseContainer2.refresh();
        }
        this._refreshList.removeAllElements();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Debug.trace(this, "Refresh Timer actionPerformed - thread: " + Thread.currentThread().getName());
        if (actionEvent.getSource() == this._refreshTimer) {
            if (this._monitorDelay != ((ReplicationSO)this._so).getMonitorDelay()) {
                this._monitorDelay = ((ReplicationSO)this._so).getMonitorDelay();
                this._refreshTimer.setDelay(this._monitorDelay * 1000);
            }
            ASConnection aSConnection = this.getConnection();
            try {
                if (aSConnection.getConnection() == null || aSConnection.getConnection().isClosed()) {
                    this.shutdownMonitor();
                } else if (((ReplicationSO)this._so).getMonitoringFlag() && this.isMonitorRunning()) {
                    this._monitor.monitorReplication();
                    this.refreshRepObjects();
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            }
        }
    }

    public void startMonitor() {
        if (!this.isMonitorRunning() && this.getDDB() != null && this.getDDB().length() > 0) {
            try {
                this._monitor = new RLStatusMonitor(new ReplicationSO(this.getConnection()), this);
                ((ReplicationSO)this._so).setMonitoringFlag(true);
                ServerBO serverBO = (ServerBO)this.getParent();
                String string = serverBO.getDisplayName(0);
                this._refreshTimer = TimerManager.getTimer(string, this._monitorDelay * 1000, this);
                this._refreshTimer.setInitialDelay(1);
                this._refreshTimer.setCoalesce(true);
                this._refreshTimer.start();
            }
            catch (Exception exception) {
                Debug.trace(this, "FAILURE! RLStatus monitor object not created.");
                this._monitor = null;
                ((ReplicationSO)this._so).setMonitoringFlag(false);
                this._refreshTimer.stop();
            }
        }
    }

    public void stopMonitor() {
        this.shutdownMonitor();
        ((ReplicationSO)this._so).setMonitoringFlag(false);
    }

    private void shutdownMonitor() {
        if (this._monitor != null) {
            this._monitor = null;
        }
        this._refreshTimer.stop();
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 64;
    }

    public boolean isMonitorRunning() {
        return this._monitor != null;
    }

    public RLStatusMonitor getRLStatusMonitor() {
        return this._monitor;
    }
}

