/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.asa.ASAButton;
import com.sybase.asa.ASAGOConstants;
import com.sybase.asa.ASALabel;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.ProfileHelper;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ExecuteWebServicesDialog;
import com.sybase.aseplugin.bo.dlg.TableDataConfigDialog;
import com.sybase.aseplugin.go.ASEMnemGridBagPanel;
import com.sybase.aseplugin.so.ASEBaseDBItemSO;
import com.sybase.aseplugin.so.ASEBaseSO;
import com.sybase.aseplugin.so.SOOwnedItemInterface;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.so.ViewSO;
import com.sybase.aseplugin.so.WebServicesSO;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.central.SCContainer;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCDetailsPanel4;
import com.sybase.central.SCItem;
import com.sybase.central.SCViewerManager;
import com.sybase.resultSetTable.ResultSetTable;
import com.sybase.resultSetTable.ResultSetTableEvent;
import com.sybase.resultSetTable.ResultSetTableListener;
import com.sybase.util.DialogUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ResultSetDetailsPanel
extends JPanel
implements SCDetailsPanel4,
ResultSetTableListener,
FocusListener,
ListSelectionListener,
ActionListener,
ASAGOConstants {
    public static final int ROWCOUNT_LIMIT = 1000;
    private static final int VIEW_MODE = 1;
    private static final int EDIT_MODE = 2;
    private static final int INSERT = 0;
    private static final int EDIT = 1;
    private static final int DELETE = 2;
    private static final int UPDATE = 3;
    private static final int CANCEL = 4;
    private static final int FETCH_LIMIT = 300;
    private static int _rowCount = 1000;
    private static String _nullDisplay = "(Null)";
    private static boolean _showRowNumbers = true;
    private SCViewerManager _viewerManager = null;
    private String _panelName = "";
    private GridBagLayout _layout = null;
    private GridBagConstraints _gbc = null;
    private SCContainer _container = null;
    private boolean _isOpen = false;
    private ResultSetTable _rsetTable = null;
    private ASEMnemGridBagPanel _panel = null;
    private ASAButton _selectAllButton = null;
    private ASAButton _configButton = null;
    private ASAButton _copyButton = null;
    private ASALabel _selectedLabel = null;
    private ASALabel _rowLabel = null;
    private int _currentMode = 1;
    private SOOwnedItemInterface _so = null;
    private ASResultSet _rset = null;
    private boolean _isTable = false;

    ResultSetDetailsPanel(TableSO tableSO) {
        this._so = tableSO;
        this._isTable = true;
        this._rset = new ASResultSet(this._so.getConnection());
        this._panelName = ASEUtils.getString("TABP_DATA");
    }

    ResultSetDetailsPanel(ViewSO viewSO) {
        this._so = viewSO;
        this._rset = new ASResultSet(this._so.getConnection());
        this._panelName = ASEUtils.getString("TABP_DATA");
    }

    public static String getProfNullDisplay() {
        String string = ProfileHelper.getPreference("TableDataNullDisplay");
        if (string != null && string.length() > 0) {
            return string;
        }
        return "(Null)";
    }

    public static boolean getProfShowRowNumbers() {
        boolean bl = false;
        String string = ProfileHelper.getPreference("TableDataShowRowNumbers");
        if (string != null && string.length() > 0) {
            bl = new Boolean(string);
        }
        return bl;
    }

    public void setViewerManager(SCViewerManager sCViewerManager) {
        this._viewerManager = sCViewerManager;
    }

    public void onOpen(SCContainer sCContainer) {
        Object object;
        block7: {
            if (this._isOpen) {
                return;
            }
            if (this._isTable && this._panelName.equals(ASEUtils.getString("TABP_DATA")) && ((TableSO)(object = (TableSO)this._so)).isProxyTable()) {
                try {
                    if (!((TableSO)object).isWebMethodProxyTable()) break block7;
                    Vector<String> vector = new Vector<String>();
                    vector.addElement(ASEUtils.getString("DISP_NAME_TEXT"));
                    vector.addElement(ASEUtils.getString("DISP_TYPE_TEXT"));
                    vector.addElement(ASEUtils.getString("DISP_VALUE_TEXT"));
                    Vector vector2 = new Vector();
                    WebServicesSO webServicesSO = new WebServicesSO(this._rset.getConnection(), "");
                    webServicesSO.setDatabase(((ASEBaseDBItemSO)object).getDatabaseName());
                    webServicesSO.setProxyTableName(((ASEBaseSO)object).getName());
                    webServicesSO.setOwner(((TableSO)object).getOwner());
                    try {
                        vector2 = ((TableSO)object).getWebMethodColumns();
                    }
                    catch (SQLException sQLException) {
                        Support.showDetailsError(((ASEBaseSO)object).getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                    }
                    ExecuteWebServicesDialog executeWebServicesDialog = ExecuteWebServicesDialog.getDialog(new JFrame(), ASEUtils.getString("DLG_EXECUTE_WEBSERVICE_TITLE"), ASEUtils.getString("MSG_EXECUTE_WEBSERVICE"), vector, vector2, webServicesSO);
                    executeWebServicesDialog.render();
                    this._isOpen = false;
                    return;
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(((ASEBaseSO)object).getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                }
            }
        }
        this._isOpen = true;
        this._container = sCContainer;
        this._rsetTable = new ResultSetTable();
        _nullDisplay = ResultSetDetailsPanel.getProfNullDisplay();
        object = ProfileHelper.getPreference("TableDataRowCount");
        if (object != null && ((String)object).length() > 0) {
            _rowCount = Integer.valueOf((String)object);
        }
        this._rsetTable.setNullDisplayString(_nullDisplay);
        this._rsetTable.setSortable(true);
        this._rsetTable.setSelectionMode(2);
        this._rsetTable.addResultSetTableListener((ResultSetTableListener)this);
        this._selectAllButton = new ASAButton(ASEUtils.getString("BTTN_SELECT_ALL"));
        this._selectAllButton.setMnemonic(Support.getMnemonic("MNEM_SELECT_ALL"));
        this._configButton = new ASAButton(ASEUtils.getString("MSG_OPTIONS"));
        this._configButton.setMnemonic(Support.getMnemonic("OK_MNEM"));
        this._copyButton = new ASAButton(ASEUtils.getString("DATA_DTLSPANEL_BTTN_COPY_ROW"));
        this._copyButton.setMnemonic(Support.getMnemonic("DATA_DTLSPANEL_MNEM_COPY_ROW"));
        this._selectedLabel = new ASALabel();
        this._rowLabel = new ASALabel();
        this._copyButton.setToolTipText(ASEUtils.getString("DATA_DTLSPANEL_TTIP_COPY_ROW"));
        this._copyButton.setEnabled(false);
        this._selectAllButton.addActionListener((ActionListener)this);
        this._configButton.addActionListener((ActionListener)this);
        this._copyButton.addActionListener((ActionListener)this);
        this._rsetTable.setEditable(this.isEditable());
        this._panel = new ASEMnemGridBagPanel(INSETS_NONE);
        int n = 0;
        this._panel.add((Component)this._selectAllButton, n, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this._panel.add((Component)this._copyButton, ++n, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this._panel.add((Component)this._selectedLabel, ++n, 0, 1, 1, 0.5, 0.0, 17, 2, INSETS, 0, 0);
        this._panel.add((Component)this._rowLabel, ++n, 0, 1, 1, 0.5, 0.0, 17, 2, INSETS, 0, 0);
        this._panel.add((Component)this._configButton, ++n, 0, 1, 1, 0.0, 0.0, 13, 0, INSETS, 0, 0);
        this._layout = new GridBagLayout();
        this.setLayout(this._layout);
        this._gbc = new GridBagConstraints();
        this._gbc.anchor = 18;
        this._gbc.fill = 2;
        this._gbc.gridheight = 1;
        this._gbc.gridwidth = 0;
        this._gbc.gridx = 0;
        this._gbc.gridy = 0;
        this._gbc.ipadx = 0;
        this._gbc.ipady = 0;
        this._gbc.weightx = 0.0;
        this._gbc.weighty = 0.0;
        this.add((Component)((Object)this._panel), this._gbc);
        this._gbc.anchor = 18;
        this._gbc.fill = 1;
        this._gbc.gridheight = 0;
        this._gbc.gridwidth = 0;
        this._gbc.gridx = 0;
        this._gbc.gridy = 1;
        this._gbc.ipadx = 0;
        this._gbc.ipady = 0;
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 1.0;
        this.add((Component)this._rsetTable, this._gbc);
        this.setResult();
        this.updateToolbarButtons();
    }

    public void setPanelName(String string) {
        this._panelName = string;
    }

    public String getPanelName() {
        return this._panelName;
    }

    public void onKillActive() {
        if (this._rsetTable != null) {
            this._rsetTable.removeFocusListener((FocusListener)this);
            this._rsetTable.removeListSelectionListener((ListSelectionListener)this);
        }
    }

    public void releaseResources() {
        if (this._rsetTable != null) {
            try {
                if (this._rset != null) {
                    this._rset.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._rset = null;
            this._rsetTable.removeResultSetTableListener((ResultSetTableListener)this);
            this._rsetTable.destroy();
            this._panel = null;
            this._copyButton.removeActionListener((ActionListener)this);
            this._configButton.removeActionListener((ActionListener)this);
            this._selectAllButton.removeActionListener((ActionListener)this);
            this._copyButton = null;
            this._selectAllButton = null;
            this._configButton = null;
            this._selectedLabel = null;
            this._rowLabel = null;
        }
        this._rsetTable = null;
        this._so = null;
        this._viewerManager = null;
        this._layout = null;
        this._gbc = null;
        this._container = null;
        DialogUtils.removeComponents((Container)this);
    }

    public void onSetActive() {
    }

    public void refresh() {
        this._isOpen = false;
        if (this._panel != null) {
            this.remove((Component)((Object)this._panel));
        }
        if (this._rsetTable != null) {
            this.remove((Component)this._rsetTable);
        }
        this.onOpen(this._container);
    }

    public JComponent getJComponent() {
        return this;
    }

    public void redisplayItem(SCItem sCItem) {
    }

    public void addItem(SCItem sCItem) {
    }

    public void deleteItem(SCItem sCItem) {
    }

    public boolean onKillActiveNotification() {
        return true;
    }

    public SCDetailsContainer getSCDetailsContainer() {
        return null;
    }

    public void setSCDetailsContainer(SCDetailsContainer sCDetailsContainer) {
    }

    public void selectFirstItem() {
    }

    public void selectAllItems() {
    }

    public void invertSelectedItems() {
    }

    public boolean exception(ResultSetTableEvent resultSetTableEvent) {
        Support.showDetailsError(this._so.getConnection(), this.getClass(), resultSetTableEvent.getException().getMessage(), resultSetTableEvent.getException());
        return true;
    }

    public boolean update(ResultSetTableEvent resultSetTableEvent) {
        return true;
    }

    public boolean insert(ResultSetTableEvent resultSetTableEvent) {
        return true;
    }

    public boolean delete(ResultSetTableEvent resultSetTableEvent) {
        return true;
    }

    public boolean cancel(ResultSetTableEvent resultSetTableEvent) {
        return true;
    }

    public void selectionChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this._rsetTable) {
            int n = this._rsetTable.getSelectedRows().length;
            if (n > 0) {
                String string = n > 1 ? ASEUtils.getString("DATA_DTLSPANEL_LABC_ROWS_SELECTED") : ASEUtils.getString("DATA_DTLSPANEL_LABC_ONE_ROW_SELECTED");
                ASEMessageText aSEMessageText = new ASEMessageText(string, new Integer(n));
                this._selectedLabel.setText(aSEMessageText.toString());
            } else {
                this._selectedLabel.setText("");
            }
            this.updateToolbarButtons();
        } else {
            Object object = listSelectionEvent.getSource();
            System.out.println(object);
        }
    }

    public void notify(ResultSetTableEvent resultSetTableEvent) {
        int n = resultSetTableEvent.getNotificationId();
        ResultSetTable resultSetTable = (ResultSetTable)resultSetTableEvent.getSource();
        if (n == 8) {
            this._rowLabel.setText(ASEUtils.getString("MSG_FETCHING_ROWS"));
        } else if (n == 9) {
            if (resultSetTable.isRowCountAnEstimate()) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_FIRST_NUM_ROWS"), new Integer(resultSetTable.getRowCount()));
                this._rowLabel.setText(aSEMessageText.toString());
            } else {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_NUM_ROWS"), new Integer(resultSetTable.getRowCount()));
                this._rowLabel.setText(aSEMessageText.toString());
            }
        } else if (n == 7) {
            ASEMessageText aSEMessageText = new ASEMessageText(resultSetTable.getRowCount() == _rowCount ? ASEUtils.getString("MSG_FIRST_NUM_ROWS") : ASEUtils.getString("MSG_NUM_ROWS"), new Integer(resultSetTable.getRowCount()));
            this._rowLabel.setText(aSEMessageText.toString());
        } else if (n == 10) {
            // empty if block
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TableDataConfigDialog tableDataConfigDialog;
        if (actionEvent.getSource() == this._copyButton) {
            this._rsetTable.copy();
        } else if (actionEvent.getSource() == this._selectAllButton) {
            this._rsetTable.selectAll();
        } else if (actionEvent.getSource() == this._configButton && (tableDataConfigDialog = TableDataConfigDialog.getDialog(Support.getViewerFrame())).render()) {
            boolean bl;
            _rowCount = tableDataConfigDialog.getRowCount();
            String string = tableDataConfigDialog.getNullDisplay();
            this._rsetTable.setNullDisplayString(string);
            if (!_nullDisplay.equals(string)) {
                this.setResult();
                _nullDisplay = string;
            }
            if (_showRowNumbers != (bl = tableDataConfigDialog.showRowNumbers())) {
                this._rsetTable.showRowHeader(bl);
                this.refresh();
                _showRowNumbers = bl;
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.updateToolbarButtons();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateToolbarButtons();
    }

    public boolean sortColumn(ResultSetTableEvent resultSetTableEvent) {
        return false;
    }

    public boolean selectAll(ResultSetTableEvent resultSetTableEvent) {
        return false;
    }

    public boolean copyColumn(ResultSetTableEvent resultSetTableEvent) {
        return false;
    }

    private void updateToolbarButtons() {
        this._copyButton.setEnabled(this._rsetTable.getSelectedRow() > -1);
    }

    private void setResult() {
        this.setResult(-1, false);
    }

    private void setResult(int n, boolean bl) {
        try {
            this._so.getDatabaseSO().useDB();
            String string = "set rowcount ";
            this._so.getConnection().executeCommand(string + _rowCount, false);
            String string2 = "select * from " + this._so.getFullyQualifiedName();
            if (n > -1) {
                int n2 = n + 1;
                string2 = string2 + " order by " + n2;
                string2 = string2 + (bl ? " asc" : " desc");
            }
            ResultSet resultSet = this._rset.open(string2, false);
            resultSet.setFetchSize(300);
            this._rsetTable.setMaximumRows(-1);
            this._rsetTable.setResultSet(this._so.getConnection().getConnection(), resultSet, this._so.getOwner(), this._so.getName());
            this._so.getConnection().executeCommand(string + 0, false);
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this._so.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
        }
    }

    private boolean isEditable() {
        return false;
    }

    class ASEResultSetTable
    extends ResultSetTable {
        ASEResultSetTable() {
        }

        protected JPopupMenu createContextMenu() {
            JMenuItem[] jMenuItemArray;
            if (this._table.getSelectedRow() > -1) {
                return super.createContextMenu();
            }
            if (ResultSetDetailsPanel.this._viewerManager == null || (jMenuItemArray = ResultSetDetailsPanel.this._viewerManager.buildContextMenuItems()) == null) {
                return null;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            for (JMenuItem jMenuItem : jMenuItemArray) {
                if (jMenuItem == null) {
                    jPopupMenu.add(new JSeparator());
                    continue;
                }
                jPopupMenu.add(jMenuItem);
            }
            return jPopupMenu;
        }
    }
}

