/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ClipboardHelper;
import com.sybase.aseplugin.bo.RoleBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.CopyObjectDialog;
import com.sybase.aseplugin.bo.prop.PasswordConfigProperties;
import com.sybase.aseplugin.bo.wiz.RoleWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.RoleSO;
import com.sybase.aseplugin.so.RolesCtrSO;
import com.sybase.aseplugin.so.ServerSO;
import java.awt.datatransfer.DataFlavor;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.swing.JFrame;

public class RolesCtrBO
extends ASEBaseContainer2 {
    public static final int CMD_PASSWORD_CONFIG = 3169;
    private static final String[] PASTABLE_CLASS_NAMES = new String[]{RoleBO.class.getName()};

    public RolesCtrBO(ServerBO serverBO) {
        super(ASEUtils.getString("DNAME_ROLES"), (ASEBaseContainer2)serverBO);
        this.setCtrSO(new RolesCtrSO(this.getConnection(), (ServerSO)serverBO.getSO()));
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        ASEBaseHeader aSEBaseHeader = new ASEBaseHeader(ASEUtils.getString("DISP_NAME_TEXT"), 0, 170);
        ASEBaseHeader aSEBaseHeader2 = new ASEBaseHeader(ASEUtils.getString("DISP_PASSWORD_TEXT"), 1, 80);
        if (ServerBO.getEnableUAF(this.getServerSO())) {
            return new ASEBaseHeader[]{aSEBaseHeader, aSEBaseHeader2, new ASEBaseHeader(ASEUtils.getString("DISP_UA_ROLES_TEXT"), 2, 200)};
        }
        return new ASEBaseHeader[]{aSEBaseHeader, aSEBaseHeader2};
    }

    @Override
    public String[] getPastableClassNames() {
        return PASTABLE_CLASS_NAMES;
    }

    @Override
    public boolean enableDelete() {
        return false;
    }

    @Override
    public boolean includeProperties() {
        return false;
    }

    @Override
    boolean pasteItem(JFrame jFrame, Object object, int n) {
        String string = ((ASEBaseItem2)object).getItemScript();
        boolean bl = ((RoleBO)object).getParent() == this;
        boolean bl2 = CopyObjectDialog.showDialog(jFrame, object, (ServerSO)this.getSO(), string, bl);
        boolean bl3 = ClipboardHelper.getInstance().getDelayedDelete();
        if (bl2 && bl3) {
            bl2 = ClipboardHelper.getInstance().setClipboardProccessing(this, (ASEBaseItem2)object, true);
        }
        return bl2;
    }

    @Override
    public int queryDropItems(int n, DataFlavor[] dataFlavorArray) {
        return this.arePastable(dataFlavorArray, PASTABLE_CLASS_NAMES) ? 1 : 0;
    }

    private ServerSO getServerSO() {
        return (ServerSO)((ServerBO)this.getParent()).getSO();
    }

    public boolean isConfigRolePasswordApplicable() {
        boolean bl = this.getConnection().getVersion().compareTo("15.0.2") >= 0;
        return this.getConnection().hasSSORole() && bl;
    }

    @Override
    public ASEBaseItem2 getItemBO(ASEBaseItemSO aSEBaseItemSO) {
        return new RoleBO((RoleSO)aSEBaseItemSO, (ASEBaseContainer2)this);
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        String string = ASEUtils.getString("MSG_ROLE_TYPE");
        String string2 = ASEUtils.getString("CREATION_HINT_NEW_ROLE");
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3069, string, string2, Support.getMnemonic("CREATION_MNEM_NEW_ROLE"), RoleBO.ROLE_ICON);
        return new ASEMenuItem[]{aSEMenuItem};
    }

    @Override
    public String getDisabledCreateHint() {
        return ASEUtils.getString("CONTEXT_MENU_DELETE_MORE_SSO_ROLE_HINT");
    }

    @Override
    public boolean isPastableItemContainer() {
        return true;
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3069, RoleBO.NEW_ROLE_ICON, ASEUtils.getString("MSG_ROLE_TYPE"), ASEUtils.getString("CREATION_HINT_NEW_ROLE"));
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public ASEToolBarButton[] getContextButtons() {
        if (!this.isConfigRolePasswordApplicable()) {
            return null;
        }
        ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3169, RoleBO.CONFIG_ROLE_ICON, ASEUtils.getString("MSG_CONFIGURE_ROLE_PASSWORDS"), ASEUtils.getString("CONTEXT_MENU_ROLE_PASSWORD_CONFIGURATION_HINT"));
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public int[] getEnabledContextCmdIds() {
        return new int[]{3169};
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        if (n == 3069) {
            ServerSO serverSO = (ServerSO)((ServerBO)this.getParent()).getSO();
            RolesCtrSO rolesCtrSO = new RolesCtrSO(this.getConnection(), serverSO);
            RoleSO roleSO = new RoleSO(this.getConnection(), rolesCtrSO);
            ASEBaseDialog2.showDialog(jFrame, new RoleWizard(roleSO, this));
        } else if (n == 3169) {
            try {
                if (!this.getConnection().isRolePasswordConfigurable()) {
                    Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_ROLE_PASSWORD_EXPIRATION_NO_ROLES_TO_BE_EXPIRED"));
                    return;
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                return;
            }
            ASEBaseDialog2.showDialog(jFrame, PasswordConfigProperties.getPropertiesDialog(this.getConnection(), false));
        } else {
            super.onCommand(jFrame, n, enumeration, n2);
        }
    }
}

