/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.CachesCtrBO;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseDevicesCtrBO;
import com.sybase.aseplugin.bo.EngineGroupsCtrBO;
import com.sybase.aseplugin.bo.ProcessesCtrBO;
import com.sybase.aseplugin.bo.SDCInstancesCtrBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.ServersDetailsBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TempDBsCtrBO;
import com.sybase.aseplugin.bo.TempDBsListCtrBO;
import com.sybase.aseplugin.bo.dlg.AuthenticateDialog;
import com.sybase.aseplugin.bo.dlg.InstanceWorkloadStatusDialog;
import com.sybase.aseplugin.bo.dlg.ItemsConfirmDialog;
import com.sybase.aseplugin.bo.dlg.ShutdownConfirmDialog;
import com.sybase.aseplugin.bo.dlg.ShutdownInstanceWaitDialog;
import com.sybase.aseplugin.bo.dlg.WorkingDialog;
import com.sybase.aseplugin.so.ASEBaseSO;
import com.sybase.aseplugin.so.SDCInstanceSO;
import com.sybase.aseplugin.so.SDCInstancesCtrSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.aseplugin.util.SDCClusterAgentUtils;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.ua.AgentConnection;
import com.sybase.ua.PluginInfo;
import com.sybase.ua.util.AgentClientUtil;
import com.sybase.util.ds.uaf.SyUAF;
import com.sybase.util.ds.uaf.SyUAFASEEntry;
import java.awt.Container;
import java.awt.Frame;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.jdom.JDOMException;

public class SDCInstanceBO
extends ServerBO {
    private static final int COL_NAME = 0;
    private static final int CMD_WRKLD_STATUS = 3008;
    public static final ImageIcon NEW_INSTANCE_ICON = new ImageIcon(ASEImages.getNewInstanceImage());
    protected TempDBsCtrBO _tempDBsCtrBO;

    public SDCInstanceBO(SDCInstancesCtrBO sDCInstancesCtrBO, SDCInstanceSO sDCInstanceSO) {
        super(sDCInstancesCtrBO, (ServerSO)sDCInstanceSO);
        try {
            this.initInstanceUAFEntry();
        }
        catch (Exception exception) {
            Support.addLogEntry(0, sDCInstanceSO.getConnection(), this.getClass(), exception.getMessage(), ASEMessageText.toString(exception));
        }
        this.setImageIcon(SDCInstanceBO.getIcon(sDCInstancesCtrBO.getConnection().getServerServerName(), sDCInstanceSO));
    }

    public SDCInstanceBO(ServersDetailsBO serversDetailsBO, SDCInstanceSO sDCInstanceSO) {
        super(serversDetailsBO, (ServerSO)sDCInstanceSO, SDCInstanceBO.getIcon(serversDetailsBO.getParent().getConnection().getServerServerName(), sDCInstanceSO));
    }

    public static ImageIcon getIcon(String string, SDCInstanceSO sDCInstanceSO) {
        if (SDCInstancesCtrSO.isShuttingdown(string, sDCInstanceSO.getName())) {
            return SERVER_WARN_ICON;
        }
        if (sDCInstanceSO.isUAFMonitored()) {
            return sDCInstanceSO.isOnline() ? SERVER_RUNNING_ICON : SERVER_DISCONNECTED_STOPPED_ICON;
        }
        return SERVER_ICON;
    }

    @Override
    public Vector getItems(int n) {
        Vector<ASEBaseContainer2> vector = new Vector<ASEBaseContainer2>();
        if (this.getSO().getConnection() == null) {
            return vector;
        }
        this._cachesCtrBO = new CachesCtrBO(ASEUtils.getString("DNAME_CACHES_LOCAL"), this);
        vector.addElement(this._cachesCtrBO);
        vector.addElement(new ProcessesCtrBO(this));
        this._engineGroupsCtrBO = new EngineGroupsCtrBO(this);
        vector.addElement(this._engineGroupsCtrBO);
        this._databaseDevicesCtrBO = new DatabaseDevicesCtrBO(this);
        vector.addElement(this._databaseDevicesCtrBO);
        this._tempDBsCtrBO = new TempDBsCtrBO(this);
        vector.addElement(this._tempDBsCtrBO);
        return vector;
    }

    @Override
    public int getAttributes() {
        return -5;
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        return new ASEBaseHeader[]{new ASEBaseHeader(ASEUtils.getString("DISP_FOLDERS_TEXT"), 0, 200)};
    }

    @Override
    public SCMenu getContextMenu() {
        ASEMenuItem aSEMenuItem;
        ASEMenuItem aSEMenuItem2;
        this._contextMenu = new ASEMenu();
        SDCInstanceSO sDCInstanceSO = (SDCInstanceSO)this.getSO();
        if (sDCInstanceSO.isOnline()) {
            if (sDCInstanceSO.isUAFMonitored()) {
                // empty if block
            }
            aSEMenuItem2 = new ASEMenuItem(3004, ASEUtils.getString("CONTEXT_MENU_SHUTDOWN"), ASEUtils.getString("CONTEXT_MENU_SHUTDOWN_HINT"), Support.getMnemonic("CONTEXT_MENU_SHUTDOWN_MNEM"));
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem2);
            aSEMenuItem = this.getDeleteMenuItem();
            aSEMenuItem.setEnabled(false);
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        } else {
            if (sDCInstanceSO.isUAFMonitored()) {
                aSEMenuItem2 = new ASEMenuItem(3076, ASEUtils.getString("BTTN_START"), ASEUtils.getString("CONTEXT_MENU_START_SERVER_HINT"), Support.getMnemonic("CONTEXT_MENU_START_SERVER_MNEM"));
                this._contextMenu.addItem((SCMenuItem)aSEMenuItem2);
            }
            this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
        }
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        aSEMenuItem2 = new ASEMenuItem(3002, ASEUtils.getString("CONTEXT_MENU_LOGSPACE_TEXT"), ASEUtils.getString("CONTEXT_MENU_LOGSPACE_HINT"), Support.getMnemonic("CONTEXT_MENU_LOGSPACE_MNEM"));
        aSEMenuItem2.setEnabled(sDCInstanceSO.isOnline());
        this._contextMenu.addItem((SCMenuItem)aSEMenuItem2);
        aSEMenuItem = new ASEMenuItem(3003, ASEUtils.getString("CONTEXT_MENU_SERVER_CONFIG"), ASEUtils.getString("CONTEXT_MENU_SERVER_CONFIG_HINT"), Support.getMnemonic("CONTEXT_MENU_SERVER_CONFIG_MNEM"));
        aSEMenuItem.setEnabled(sDCInstanceSO.isOnline());
        this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        ASEMenuItem aSEMenuItem3 = new ASEMenuItem(3008, ASEUtils.getString("CONTEXT_MENU_INST_WRKLD_STATUS"), ASEUtils.getString("CONTEXT_MENU_INST_WRKLD_STATUS_HINT"), Support.getMnemonic("CONTEXT_MENU_INST_WRKLD_STATUS_MNEM"));
        aSEMenuItem3.setEnabled(sDCInstanceSO.isOnline());
        this._contextMenu.addItem((SCMenuItem)aSEMenuItem3);
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        ASEMenuItem aSEMenuItem4 = ASEMenuItem.getPropertiesMenuItem();
        aSEMenuItem4.setEnabled(sDCInstanceSO.isOnline() || sDCInstanceSO.isUAFMonitored());
        this._contextMenu.addItem((SCMenuItem)aSEMenuItem4);
        return this._contextMenu;
    }

    @Override
    protected void addDatabaseDeviceCreationMenu() {
        String string = ASEUtils.getString("MSG_DATABASE_DEVICE_TYPE_SDC_LOCAL");
        String string2 = ASEUtils.getString("CREATION_HINT_NEW_DATABASE_DEVICE_SDC_LOCAL");
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3063, string, string2);
        this._creationMenu.addItem((SCMenuItem)aSEMenuItem);
    }

    @Override
    public void open(int n) {
        int n2 = ((SDCInstancesCtrBO)this.getParent()).getInstanceCtrType();
        if (n2 == 2) {
            return;
        }
        super.open(n);
    }

    @Override
    public void open(int n, Object[] objectArray) {
        int n2 = ((SDCInstancesCtrBO)this.getParent()).getInstanceCtrType();
        if (n2 == 2) {
            return;
        }
        super.open(n, objectArray);
    }

    public ServerBO getClusterServerBO() {
        SDCInstancesCtrBO sDCInstancesCtrBO = (SDCInstancesCtrBO)this.getParent();
        ServerBO serverBO = (ServerBO)sDCInstancesCtrBO.getParent();
        return serverBO;
    }

    public boolean checkUAF(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            SDCInstanceBO sDCInstanceBO;
            SDCInstanceSO sDCInstanceSO;
            Object e = arrayList.get(i);
            if (!(e instanceof SDCInstanceBO) || (sDCInstanceSO = (SDCInstanceSO)(sDCInstanceBO = (SDCInstanceBO)e).getSO()).isUAFMonitored()) continue;
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_SDC_DELETE_INSTANCE_CHECK_UAF"), sDCInstanceSO.getName());
            Support.showError(this.getConnection(), this.getClass(), aSEMessageText.toString());
            return false;
        }
        return true;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        Object object;
        String string = "";
        String string2 = "";
        ServerSO serverSO = (ServerSO)this.getSO();
        if (null != serverSO && serverSO.isCluster() && (n == 3076 || n == 3078 || n == 3004)) {
            if (n == 3076 || this.isCluster() && serverSO.isUAFMonitored() && !serverSO.hasAuthToGetMembershipMode()) {
                object = AuthenticateDialog.showDialog(Support.getViewerFrame(), serverSO, true, false);
                if (((AuthenticateDialog)((Object)object)).getCloseState()) {
                    string = ((AuthenticateDialog)((Object)object)).getUserName();
                    string2 = ((AuthenticateDialog)((Object)object)).getPassword();
                } else {
                    return;
                }
            }
            object = null;
            if (serverSO.isVCSMode()) {
                object = n == 3076 ? ASEUtils.getString("MSG_START_CLUSTER_ON_VCS") : ASEUtils.getString("MSG_SHUTDOWN_CLUSTER_ON_VCS");
                Support.showError(this.getConnection(), this.getClass(), (String)object);
                return;
            }
        }
        object = (SDCInstancesCtrBO)this.getParent();
        ServerBO serverBO = (ServerBO)object.getParent();
        switch (n) {
            case 106: {
                ArrayList arrayList = Support.enumToArrayList(enumeration);
                if (!this.checkUAF(arrayList)) break;
                String string3 = serverBO.getDisplayName(0);
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_SDC_CONFIRM_INSTANCE_DELETE_TEXT"), this.getSO().getName(), string3);
                ItemsConfirmDialog itemsConfirmDialog = new ItemsConfirmDialog(Support.createDialogSupport(jFrame), aSEMessageText.toString(), this, arrayList);
                if (itemsConfirmDialog.start(this)) {
                    Support.getTopBO().refresh(false);
                }
                SDCInstancesCtrSO.removeShutdownInstance(object.getConnection().getServerServerName(), this.getSO().getName());
                ServerSO serverSO2 = (ServerSO)serverBO.getSO();
                try {
                    serverSO2.refreshClusterConfiguration();
                    serverSO2.refreshBackupServer(false);
                    serverSO2.refreshMonitorServer(false);
                    serverSO2.refreshXPServer(false);
                }
                catch (Exception exception) {}
                break;
            }
            case 3004: {
                ShutdownConfirmDialog shutdownConfirmDialog = ShutdownConfirmDialog.getDialog(jFrame, serverSO);
                if (!shutdownConfirmDialog.render()) break;
                if (shutdownConfirmDialog.isNoWait()) {
                    this.shutdownNoWait();
                    break;
                }
                int n3 = shutdownConfirmDialog.getReminderMinutes();
                SDCInstanceSO sDCInstanceSO = (SDCInstanceSO)this.getSO();
                this.shutdown(n3);
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("OPERATION_IN_PROGESS"), ASEUtils.getString("MSG_SHUTDOWN"));
                sDCInstanceSO.setDisplayName(sDCInstanceSO.getName() + "(" + aSEMessageText.toString() + ")");
                this.setImageIcon(SDCInstanceBO.getIcon(this.getParentSO().getConnection().getServerServerName(), sDCInstanceSO));
                this.redisplay();
                break;
            }
            case 3076: {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("OPERATION_IN_PROGESS"), ASEUtils.getString("BTTN_START"));
                WorkingDialog workingDialog = new WorkingDialog((Frame)jFrame, ASEUtils.getString("BTTN_START"), aSEMessageText.toString());
                String string4 = serverSO.getUAFInfo().getName();
                InstanceStartTask instanceStartTask = new InstanceStartTask(workingDialog, string4, Support.enumToArrayList(enumeration), string, string2);
                workingDialog.init(instanceStartTask);
                workingDialog.dispose();
                if (this.getParent() == null) break;
                this.getParent().refreshLater();
                break;
            }
            case 3008: {
                InstanceWorkloadStatusDialog instanceWorkloadStatusDialog = new InstanceWorkloadStatusDialog(Support.createDialogSupport(Support.getViewerFrame()), (SDCInstanceSO)this.getSO());
                instanceWorkloadStatusDialog.showDialog();
                break;
            }
            case 3070: {
                TempDBsListCtrBO tempDBsListCtrBO = new TempDBsListCtrBO(this._tempDBsCtrBO);
                tempDBsListCtrBO.setDatabaseCtrType(7);
                tempDBsListCtrBO.onCommand(jFrame, 3062, enumeration, n2);
                break;
            }
            default: {
                super.onCommand(jFrame, n, enumeration, n2);
            }
        }
    }

    private void waitForInstanceAppear() {
        String string = null;
        while (string == null) {
            try {
                SDCInstancesCtrSO sDCInstancesCtrSO = this.getParentSO();
                if (sDCInstancesCtrSO == null) break;
                string = sDCInstancesCtrSO.getInstanceState(this.getSO().getName());
                Thread.sleep(100L);
            }
            catch (SQLException sQLException) {
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void waitForExpectState(String string) {
        String string2 = null;
        while (!string.equals(string2)) {
            try {
                SDCInstancesCtrSO sDCInstancesCtrSO = this.getParentSO();
                if (sDCInstancesCtrSO == null) break;
                string2 = sDCInstancesCtrSO.getInstanceState(this.getSO().getName());
                Thread.sleep(100L);
            }
            catch (SQLException sQLException) {
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private boolean tryCloseConnections() {
        SDCInstanceSO sDCInstanceSO = (SDCInstanceSO)this.getSO();
        ServerSO serverSO = (ServerSO)this.getClusterServerBO().getSO();
        if (serverSO.getConnectionInfo().host.equals(sDCInstanceSO.getConnectionInfo().host) && serverSO.getConnectionInfo().port == sDCInstanceSO.getConnectionInfo().port) {
            ASConnection.removeShutdownServer(serverSO.getName());
            return Support.getProvider().removeServerConnections(serverSO, true);
        }
        return false;
    }

    private void closeConnectionsAndRefreshContainer() {
        if (!this.tryCloseConnections() && this.getParent() != null) {
            this.getParent().refreshLater();
        }
    }

    private void shutdownNoWait() {
        String string = ASEUtils.getString("MSG_SHUTDOWN");
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("OPERATION_IN_PROGESS"), string);
        new WorkingDialog((Frame)Support.getViewerFrame(), new Runnable(){

            @Override
            public void run() {
                SDCInstanceSO sDCInstanceSO = (SDCInstanceSO)SDCInstanceBO.this.getSO();
                try {
                    sDCInstanceSO.shutdownNoWait();
                }
                catch (SQLException sQLException) {
                    Support.addLogEntry(2, sDCInstanceSO.getConnection(), this.getClass(), sQLException.getMessage(), ASEMessageText.toString(sQLException));
                }
                SDCInstanceBO.this.waitForInstanceAppear();
                SDCInstanceBO.this.closeConnectionsAndRefreshContainer();
            }
        }, string, aSEMessageText.toString());
    }

    private SDCInstancesCtrSO getParentSO() {
        SDCInstancesCtrBO sDCInstancesCtrBO = ContainerViewBO.getSDCInstancesCtrBO(this.getClusterServerBO());
        return sDCInstancesCtrBO == null ? null : sDCInstancesCtrBO.getContainerSO();
    }

    private void shutdown(int n) {
        SDCInstanceSO sDCInstanceSO = (SDCInstanceSO)this.getSO();
        SDCInstancesCtrSO.addShutdownInstance(this.getParentSO().getConnection().getServerServerName(), sDCInstanceSO.getName());
        try {
            ASConnection aSConnection = sDCInstanceSO.getConnection();
            this._newConn = aSConnection.duplicate();
            final SDCInstanceSO sDCInstanceSO2 = new SDCInstanceSO(this._newConn, sDCInstanceSO.getConnectionInfo(), sDCInstanceSO.getName(), sDCInstanceSO.getServerGroup(), sDCInstanceSO.getUAFInfo());
            Thread thread = new Thread("InstanceShutdown"){

                @Override
                public void run() {
                    try {
                        sDCInstanceSO2.shutdown();
                    }
                    catch (SQLException sQLException) {
                        Support.addLogEntry(2, null, this.getClass(), sQLException.getMessage(), ASEMessageText.toString(sQLException));
                    }
                }
            };
            thread.start();
            this._timer = new Timer();
            this._timer.schedule((TimerTask)new InstanceShutdownTask(sDCInstanceSO2, 20 * n), 0L, 3000L);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_NO_JDBC_DRIVER"), classNotFoundException);
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
        }
    }

    public void initInstanceUAFEntry() throws IOException, JDOMException, RemoteException, Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        AgentConnection agentConnection2;
        SDCInstancesCtrBO sDCInstancesCtrBO = (SDCInstancesCtrBO)this.getParent();
        SDCInstanceSO sDCInstanceSO = (SDCInstanceSO)this.getSO();
        String string = "";
        ASConnection aSConnection = sDCInstancesCtrBO.getConnection();
        if (aSConnection != null) {
            string = aSConnection.getServerServerName();
        }
        ServerBO serverBO = this.getClusterServerBO();
        ServerSO serverSO = (ServerSO)serverBO.getSO();
        String string2 = ASEUtils.getString("MSG_SDC_CONNECTING_LOCAL_INSTANCE") + this.getDisplayName(0);
        string2 = string2 + " . . .";
        Support.setStatusBarMessage(string2);
        ArrayList arrayList = (ArrayList)sDCInstancesCtrBO.getContainerSO().getSDCInstances();
        if (arrayList == null) {
            Support.setStatusBarMessage("");
            return;
        }
        String string3 = "";
        String string4 = "";
        String string5 = "";
        for (AgentConnection agentConnection2 : arrayList) {
            string3 = agentConnection2[1];
            if (!sDCInstanceSO.getName().equals(string3)) continue;
            string4 = agentConnection2[2];
            string5 = agentConnection2[3];
            break;
        }
        if ((agentConnection2 = ((SDCInstanceSO)this.getSO()).getCachedInstanceAgentConn(string4, string5)) == null) {
            string2 = string2 + " . . .";
            Support.setStatusBarMessage(string2);
            object4 = serverSO.getAgentInfo().getRMIPort();
            object3 = SDCClusterAgentProxy.getCLAPAdmin();
            object2 = "";
            object = new SDCClusterAgentProxy(string4, (String)object4, (String)object3, (String)object2);
            string2 = string2 + " . . .";
            Support.setStatusBarMessage(string2);
            ((SDCClusterAgentProxy)object).connect();
            string2 = string2 + " . . .";
            Support.setStatusBarMessage(string2);
            agentConnection2 = ((SDCClusterAgentProxy)object).getAgentConnection();
            ((SDCInstanceSO)this.getSO()).addCachedInstanceAgentConn(string4, string5, agentConnection2);
        }
        object4 = agentConnection2.getAgentInfo();
        object3 = object4.getPluginInfos(SyUAF.SDC_PLUGIN_ID);
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (PluginInfo)iterator.next();
            object = AgentClientUtil.getPluginMBeanName((String)object2.getId(), (String)object2.getVersion(), (int)object2.getInstanceNumber());
            String string6 = (String)agentConnection2.getAgentPluginProperty((String)object, "host");
            String string7 = (String)object2.getDiscoveryProperty("clusterName");
            string2 = string2 + " . . .";
            Support.setStatusBarMessage(string2);
            if (!SDCClusterAgentUtils.isSameHost(string4, string6) || !string.equals(string7)) continue;
            SyUAFASEEntry syUAFASEEntry = new SyUAFASEEntry(object2.getDiscoveryProperties(), object2.getId(), object2.getVersion(), object2.getInstanceNumber(), object4);
            ServerSO.addDiscoveredServer(string4, syUAFASEEntry.getPortNumber(), syUAFASEEntry);
            sDCInstanceSO.setAgentConnection(agentConnection2);
            sDCInstanceSO.setUAFInfo(syUAFASEEntry);
            Support.setStatusBarMessage("");
            return;
        }
        Support.setStatusBarMessage("");
    }

    class InstanceStartTask
    extends Thread {
        Container _parent;
        private String _clusterName = "";
        private String _agentUser = "";
        private String _agentEncryptedPassword = "";
        private List _items;

        public InstanceStartTask(Container container, String string, List list, String string2, String string3) {
            this._parent = container;
            this._clusterName = string;
            this._items = list;
            this._agentUser = string2;
            this._agentEncryptedPassword = ASEUtils.encryptPassword(string3);
        }

        @Override
        public void run() {
            SDCInstanceBO sDCInstanceBO2 = null;
            ASEBaseSO aSEBaseSO = null;
            try {
                for (SDCInstanceBO sDCInstanceBO2 : this._items) {
                    aSEBaseSO = (SDCInstanceSO)sDCInstanceBO2.getSO();
                    ((ServerSO)aSEBaseSO).getUAFInfo().startCluster(this._clusterName, aSEBaseSO.getName(), this._agentUser, ASEUtils.decryptPassword(this._agentEncryptedPassword), null);
                    Support.getTopBO().updateServerStatus(sDCInstanceBO2, true, 0);
                    int n = 5000;
                    for (int i = 0; i < 6; ++i) {
                        Support.getTopBO().updateServerStatus(sDCInstanceBO2, true, n, "RUNNING");
                        n += 5000;
                    }
                }
            }
            catch (Exception exception) {
                String string = new ASEMessageText(ASEUtils.getString("MSG_OPERATION_FAILED"), "start", aSEBaseSO.getName()).toString();
                Support.showDetailsError(SDCInstanceBO.this.getConnection(), this.getClass(), this._parent, string, exception);
                return;
            }
        }
    }

    class InstanceShutdownTask
    extends TimerTask {
        private int _numChecks;
        private SDCInstanceSO _instanceSO;

        InstanceShutdownTask(SDCInstanceSO sDCInstanceSO, int n) {
            this._instanceSO = sDCInstanceSO;
            this._numChecks = n;
        }

        @Override
        public void run() {
            String string = this._instanceSO.getName();
            if (this._numChecks > 0) {
                try {
                    ASConnection aSConnection = this._instanceSO.getConnection().duplicate();
                    aSConnection.close();
                    --this._numChecks;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (SQLException sQLException) {
                    SDCInstancesCtrSO.removeLocalConnection(SDCInstanceBO.this.getClusterServerBO().getConnection().getServerServerName(), string);
                    SDCInstanceBO.this.closeConnectionsAndRefreshContainer();
                    SDCInstanceBO.this.waitForExpectState("offline");
                    SDCInstanceBO.this._timer.cancel();
                    if (SDCInstanceBO.this.getParentSO() != null) {
                        SDCInstancesCtrSO.removeShutdownInstance(SDCInstanceBO.this.getParentSO().getConnection().getServerServerName(), string);
                    }
                    SDCInstanceBO.this.closeConnectionsAndRefreshContainer();
                    SDCInstanceBO.this._newConn = null;
                }
            } else {
                ShutdownInstanceWaitDialog shutdownInstanceWaitDialog = ShutdownInstanceWaitDialog.getDialog(Support.getViewerFrame(), this._instanceSO);
                if (shutdownInstanceWaitDialog.render()) {
                    if (shutdownInstanceWaitDialog.isNoWait()) {
                        SDCInstanceBO.this._timer.cancel();
                        SDCInstanceBO.this.shutdownNoWait();
                    } else {
                        int n = shutdownInstanceWaitDialog.getWaitMinutes();
                        this._numChecks = 20 * n;
                    }
                }
            }
        }
    }
}

