/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ClusterConfigFactory;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.util.XMLCluster;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.SDCInstanceBO;
import com.sybase.aseplugin.bo.SDCInstsCtrBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.SDCInstanceWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.so.SDCInstanceSO;
import com.sybase.aseplugin.so.SDCInstancesCtrSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.ua.AuthorizationException;
import com.sybase.ua.util.jdom.JDomUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import org.jdom.Element;

public class SDCInstancesCtrBO
extends SDCInstsCtrBO {
    private SDCInstancesCtrSO _instancesCtrSO;
    private ServerSO _serverSO;
    private ServerBO _serverBO;

    public SDCInstancesCtrBO(ServerBO serverBO) {
        super(ASEUtils.getString("DNAME_SDC_INSTANCES"), (ASEBaseContainer2)serverBO);
        this._serverBO = serverBO;
        this._serverSO = (ServerSO)this._serverBO.getSO();
        this._instancesCtrSO = new SDCInstancesCtrSO(this.getConnection(), this._serverSO);
        this.setCtrSO(this._instancesCtrSO);
    }

    public SDCInstancesCtrSO getContainerSO() {
        return this._instancesCtrSO;
    }

    @Override
    public Vector getItems(int n, Object[] objectArray) throws SQLException {
        Vector<SDCInstanceBO> vector = new Vector<SDCInstanceBO>();
        if (this._instancesCtrSO.getConnection().isDead()) {
            return null;
        }
        Support.getViewerSupport().startWait();
        List list = this._instancesCtrSO.open(1, objectArray);
        if (list != null) {
            for (SDCInstanceSO sDCInstanceSO : list) {
                SDCInstanceBO sDCInstanceBO = new SDCInstanceBO(this, sDCInstanceSO);
                vector.addElement(sDCInstanceBO);
                try {
                    sDCInstanceSO.authenticateASE();
                }
                catch (Exception exception) {
                    Support.addLogEntry(1, this._instancesCtrSO.getConnection(), this.getClass(), exception.getMessage(), ASEMessageText.toString(exception));
                }
            }
        }
        Support.getViewerSupport().endWait();
        return vector;
    }

    @Override
    public Vector getItems(int n) throws SQLException {
        return this.getItems(n, null);
    }

    @Override
    public int getAttributes() {
        if (this.getInstanceCtrType() == 1) {
            return -5;
        }
        return -2;
    }

    @Override
    public void setInstanceCtrType(int n) {
        this._instancesCtrSO.setInstanceCtrType(n);
    }

    @Override
    public int getInstanceCtrType() {
        return this._instancesCtrSO.getInstanceCtrType();
    }

    public ICluster getICluster() {
        ServerBO serverBO = (ServerBO)this.getParent();
        ServerSO serverSO = (ServerSO)serverBO.getSO();
        String string = null;
        try {
            string = serverSO.getClusterConfigXML();
            if (string != null && !string.equals("")) {
                Element element = JDomUtil.getDocument((String)string).getRootElement();
                String string2 = serverSO.getConnection().getServerServerName();
                ICluster iCluster = ClusterConfigFactory.createCluster((String)string2);
                iCluster = XMLCluster.getCluster((ICluster)iCluster, (Element)element);
                return iCluster;
            }
        }
        catch (IOException iOException) {
            Support.addLogEntry(0, this._instancesCtrSO.getConnection(), this.getClass(), iOException.getMessage(), ASEMessageText.toString(iOException));
        }
        catch (ClusterConfigException clusterConfigException) {
            Support.showError(this.getConnection(), this.getClass(), clusterConfigException.getMessage());
        }
        return null;
    }

    private boolean isSupportInstanceCreate() {
        return this._serverSO.isUAFMonitored();
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        if (this.isSupportInstanceCreate()) {
            String string = ASEUtils.getString("DISP_SDC_INSTANCE_NAME");
            String string2 = ASEUtils.getString("MSG_ADD_SDC_INSTANCE");
            ASEMenuItem aSEMenuItem = new ASEMenuItem(3060, string, string2, Support.getMnemonic("MSG_ADD_SDC_INSTANCE"), SDCInstanceBO.NEW_INSTANCE_ICON);
            return new ASEMenuItem[]{aSEMenuItem};
        }
        return null;
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        if (this.isSupportInstanceCreate()) {
            ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3060, SDCInstanceBO.NEW_INSTANCE_ICON, ASEUtils.getString("MSG_ADD_SDC_INSTANCE"), ASEUtils.getString("MSG_ADD_SDC_INSTANCE"));
            return new ASEToolBarButton[]{aSEToolBarButton};
        }
        return null;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        if (n == 3060) {
            if (this.getInstanceCtrType() == 1) {
                try {
                    if (this._serverSO.isLocalInstallation() && !this._serverBO.supportInLocalInstallation()) {
                        Support.showDetailsError(this.getConnection(), this.getClass(), ASEUtils.getString("SDC_CLUSTER_INVALID_LDAP_IN_LOCAL_MODE_ERROR"), new UnsupportedOperationException(ASEUtils.getString("SDC_CLUSTER_INVALID_LDAP_IN_LOCAL_MODE_ERROR_DETAILS")));
                        return;
                    }
                }
                catch (AuthorizationException authorizationException) {
                    Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_NEED_AGENT_AUTHENTICATION"));
                }
                catch (Exception exception) {
                    Support.showError(this.getConnection(), this.getClass(), exception.toString());
                }
                SDCClusterSO sDCClusterSO = new SDCClusterSO(this._serverSO.getConnectionInfo(), this._serverSO.getServerGroup(), this._serverSO.getUAFInfo());
                sDCClusterSO.setConnection(this._serverSO.getConnection());
                ASEBaseDialog2.showDialog(jFrame, new SDCInstanceWizard(sDCClusterSO, this));
            }
        } else {
            super.onCommand(jFrame, n, enumeration, n2);
        }
    }
}

