/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ItemsConfirmDialog;
import com.sybase.aseplugin.bo.dlg.LogicalClusterWorkloadDialog;
import com.sybase.aseplugin.bo.dlg.SDCLCStopConfirmDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.SDCLogicalClusterProperties;
import com.sybase.aseplugin.so.SDCLogicalClusterSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.util.WrkldMgmtUtilities;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class SDCLogicalClusterBO
extends ASEBaseItem2 {
    public static final ImageIcon LOGICAL_CLUSTER_ICON = new ImageIcon(ASEImages.getServerSmallImage());
    public static final ImageIcon NEW_LOGICAL_CLUSTER_ICON = new ImageIcon(ASEImages.getNewLogicalClusterImage());
    protected static final int CMD_SDCLC_ONLINE = 3001;
    protected static final int CMD_SDCLC_OFFLINE = 3002;
    protected static final int CMD_SDCLC_MIGRATE = 3003;
    protected static final int CMD_SDCLC_FAILOVER = 3004;
    protected static final int CMD_SDCLC_FAILBACK = 3005;
    protected static final int CMD_SDCLC_DEACTIVATE = 3006;
    private static final int CMD_SDCLC_WORKLOAD = 3007;

    public static ImageIcon getIcon(SDCLogicalClusterSO sDCLogicalClusterSO) {
        return LOGICAL_CLUSTER_ICON;
    }

    public SDCLogicalClusterBO(SDCLogicalClusterSO sDCLogicalClusterSO, ASEBaseContainer2 aSEBaseContainer2) {
        super((SOItemInterface)sDCLogicalClusterSO, aSEBaseContainer2, (Icon)LOGICAL_CLUSTER_ICON);
    }

    @Override
    public boolean includeDDLGen() {
        return true;
    }

    @Override
    public boolean enableDDLGen() {
        return true;
    }

    @Override
    public String[] getDDLGenParams(SOItemInterface sOItemInterface) {
        return new String[]{"-N" + sOItemInterface.getName(), "-T" + sOItemInterface.getType()};
    }

    @Override
    public SCMenu getContextMenu() {
        ASEMenuItem aSEMenuItem;
        this._contextMenu = new ASEMenu();
        SDCLogicalClusterSO sDCLogicalClusterSO = (SDCLogicalClusterSO)this.getSO();
        try {
            sDCLogicalClusterSO.updateLCState();
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
        }
        if (this.includeDDLGen()) {
            aSEMenuItem = ASEMenuItem.getDDLGenMenuItem(this.enableDDLGen());
            aSEMenuItem.setEnabled(this.enableDDLGen());
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        }
        if (WrkldMgmtUtilities.isWorkloadAuthorized(this.getSO().getConnection()) && !sDCLogicalClusterSO.hasSystemRole()) {
            if (sDCLogicalClusterSO.isFailedOver()) {
                this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3002, ASEUtils.getString("CONTEXT_MENU_SDC_LC_OFFLINE_TEXT"), ASEUtils.getString("CONTEXT_MENU_SDC_LC_OFFLINE_HINT"), Support.getMnemonic("CONTEXT_MENU_SDC_LC_OFFLINE_MNEM")));
                this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3006, ASEUtils.getString("CONTEXT_MENU_SDC_LC_DEACTIVATE_TEXT"), ASEUtils.getString("CONTEXT_MENU_SDC_LC_DEACTIVATE_HINT"), Support.getMnemonic("CONTEXT_MENU_SDC_LC_DEACTIVATE_MNEM")));
                this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3005, ASEUtils.getString("CONTEXT_MENU_SDC_LC_FAILBACK_TEXT"), ASEUtils.getString("CONTEXT_MENU_SDC_LC_FAILBACK_HINT"), Support.getMnemonic("CONTEXT_MENU_SDC_LC_FAILBACK_MNEM")));
            } else if (sDCLogicalClusterSO.isOnline()) {
                this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3002, ASEUtils.getString("CONTEXT_MENU_SDC_LC_OFFLINE_TEXT"), ASEUtils.getString("CONTEXT_MENU_SDC_LC_OFFLINE_HINT"), Support.getMnemonic("CONTEXT_MENU_SDC_LC_OFFLINE_MNEM")));
                this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3006, ASEUtils.getString("CONTEXT_MENU_SDC_LC_DEACTIVATE_TEXT"), ASEUtils.getString("CONTEXT_MENU_SDC_LC_DEACTIVATE_HINT"), Support.getMnemonic("CONTEXT_MENU_SDC_LC_DEACTIVATE_MNEM")));
                this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3004, ASEUtils.getString("CONTEXT_MENU_SDC_LC_FAILOVER_TEXT"), ASEUtils.getString("CONTEXT_MENU_SDC_LC_FAILOVER_HINT"), Support.getMnemonic("CONTEXT_MENU_SDC_LC_FAILOVER_MNEM")));
            } else {
                this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3001, ASEUtils.getString("CONTEXT_MENU_SDC_LC_ONLINE_TEXT"), ASEUtils.getString("CONTEXT_MENU_SDC_LC_ONLINE_HINT"), Support.getMnemonic("CONTEXT_MENU_SDC_LC_ONLINE_MNEM")));
            }
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            aSEMenuItem = this.getDeleteMenuItem();
            aSEMenuItem.setEnabled(this.includeDelete());
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        }
        if (this.includeCopy()) {
            aSEMenuItem = ASEMenuItem.getCopyMenuItem();
            aSEMenuItem.setEnabled(this.enableCopy());
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        }
        if (sDCLogicalClusterSO.isOnline()) {
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3007, ASEUtils.getString("CONTEXT_MENU_SDC_LC_WORKLOAD_TEXT"), ASEUtils.getString("CONTEXT_MENU_SDC_LC_WORKLOAD_HINT"), Support.getMnemonic("CONTEXT_MENU_SDC_LC_WORKLOAD_MNEM")));
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        }
        this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        return this._contextMenu;
    }

    @Override
    public boolean includeDelete() {
        SDCLogicalClusterSO sDCLogicalClusterSO = (SDCLogicalClusterSO)this.getSO();
        return !sDCLogicalClusterSO.isOnline() && !sDCLogicalClusterSO.isFailedOver();
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        SDCLogicalClusterSO sDCLogicalClusterSO = (SDCLogicalClusterSO)this.getSO();
        String string = "";
        String string2 = "";
        switch (n) {
            case 3002: {
                SDCLCStopConfirmDialog sDCLCStopConfirmDialog = SDCLCStopConfirmDialog.getDialog(jFrame, sDCLogicalClusterSO, sDCLogicalClusterSO.getName(), 3004);
                if (!sDCLCStopConfirmDialog.render()) break;
                if (sDCLCStopConfirmDialog.isNoWait()) {
                    try {
                        sDCLogicalClusterSO.offline();
                    }
                    catch (SQLException sQLException) {
                        Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                    }
                    break;
                }
                int n3 = sDCLCStopConfirmDialog.getReminderMinutes();
                try {
                    sDCLogicalClusterSO.offline(n3);
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                }
                break;
            }
            case 3004: 
            case 3005: 
            case 3006: {
                ArrayList arrayList = Support.enumToArrayList(enumeration);
                if (n == 3006 || n == 3004 || n == 3005) {
                    SCDialogSupport sCDialogSupport = Support.createDialogSupport(jFrame);
                    if (n == 3006) {
                        string = ASEUtils.getString("CONTEXT_MENU_SDC_LC_DEACTIVATE_TEXT");
                        string2 = ASEUtils.getString("MSG_SDC_CONFIRM_LC_DEACTIVATE");
                    } else if (n == 3004) {
                        string = ASEUtils.getString("CONTEXT_MENU_SDC_LC_FAILOVER_TEXT");
                        string2 = ASEUtils.getString("MSG_SDC_CONFIRM_LC_FAILOVER");
                    } else if (n == 3005) {
                        string = ASEUtils.getString("CONTEXT_MENU_SDC_LC_FAILBACK_TEXT");
                        string2 = ASEUtils.getString("MSG_SDC_CONFIRM_LC_FAILBACK");
                    }
                    ItemsConfirmDialog itemsConfirmDialog = new ItemsConfirmDialog(sCDialogSupport, string, string2, null, this, n, arrayList);
                    sCDialogSupport.setHelpButton(false);
                    if (itemsConfirmDialog.start(this)) break;
                    return;
                }
            }
            case 3001: {
                try {
                    sDCLogicalClusterSO.online();
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                }
                break;
            }
            case 3003: {
                break;
            }
            case 3007: {
                LogicalClusterWorkloadDialog.showDialog(Support.getViewerFrame(), sDCLogicalClusterSO.getName(), null, sDCLogicalClusterSO.getLoadProfileName(), sDCLogicalClusterSO.getConnection());
                break;
            }
            default: {
                super.onCommand(jFrame, n, enumeration, n2);
            }
        }
        this._parent.refresh();
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        SDCLogicalClusterProperties sDCLogicalClusterProperties = new SDCLogicalClusterProperties(this.getSO(), (SCContainer2)this.getParent());
        return sDCLogicalClusterProperties;
    }

    @Override
    public boolean confirmExecution(ArrayList arrayList, int n) {
        if (n == 3002) {
            return this.offlineObjects(arrayList);
        }
        if (n == 3006) {
            return this.deactivateObjects(arrayList);
        }
        if (n == 3004) {
            return this.failoverObjects(arrayList);
        }
        if (n == 3005) {
            return this.failbackObjects(arrayList);
        }
        return super.confirmExecution(arrayList, n);
    }

    public boolean offlineObjects(ArrayList arrayList) {
        Support.getViewerSupport().startWait();
        for (SDCLogicalClusterBO sDCLogicalClusterBO : arrayList) {
            SDCLogicalClusterSO sDCLogicalClusterSO = (SDCLogicalClusterSO)sDCLogicalClusterBO.getSO();
            try {
                sDCLogicalClusterSO.offline();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            }
        }
        Support.getViewerSupport().endWait();
        return true;
    }

    public boolean failoverObjects(ArrayList arrayList) {
        Support.getViewerSupport().startWait();
        for (SDCLogicalClusterBO sDCLogicalClusterBO : arrayList) {
            SDCLogicalClusterSO sDCLogicalClusterSO = (SDCLogicalClusterSO)sDCLogicalClusterBO.getSO();
            try {
                sDCLogicalClusterSO.failOver();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            }
        }
        Support.getViewerSupport().endWait();
        return true;
    }

    public boolean failbackObjects(ArrayList arrayList) {
        Support.getViewerSupport().startWait();
        for (SDCLogicalClusterBO sDCLogicalClusterBO : arrayList) {
            SDCLogicalClusterSO sDCLogicalClusterSO = (SDCLogicalClusterSO)sDCLogicalClusterBO.getSO();
            try {
                sDCLogicalClusterSO.failBack();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            }
        }
        Support.getViewerSupport().endWait();
        return true;
    }

    public boolean deactivateObjects(ArrayList arrayList) {
        Support.getViewerSupport().startWait();
        for (SDCLogicalClusterBO sDCLogicalClusterBO : arrayList) {
            SDCLogicalClusterSO sDCLogicalClusterSO = (SDCLogicalClusterSO)sDCLogicalClusterBO.getSO();
            try {
                sDCLogicalClusterSO.deactivate();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            }
        }
        Support.getViewerSupport().endWait();
        return true;
    }
}

