/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.LogBO;
import com.sybase.aseplugin.bo.LogsDetailsBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.so.LogSO;
import com.sybase.aseplugin.so.SDCInstanceSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.central.SCItem;
import com.sybase.ua.AuthorizationException;

public class SDCLogsDetailsBO
extends LogsDetailsBO {
    public SDCLogsDetailsBO(ServerBO serverBO) {
        super(serverBO);
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        ASEBaseHeader aSEBaseHeader = new ASEBaseHeader(ASEUtils.getString("DISP_DATE_TEXT"), 0, 170, 2);
        ASEBaseHeader aSEBaseHeader2 = new ASEBaseHeader(ASEUtils.getString("DISP_SOURCE_TEXT"), 1, 80);
        ASEBaseHeader aSEBaseHeader3 = new ASEBaseHeader(ASEUtils.getString("DISP_MESSAGE_TEXT"), 2, 280);
        ASEBaseHeader aSEBaseHeader4 = new ASEBaseHeader(ASEUtils.getString("DISP_SDC_INSTANCE_ID_TEXT"), 3, 80);
        ASEBaseHeader aSEBaseHeader5 = new ASEBaseHeader(ASEUtils.getString("DISP_ENGINE_NUMBER_TEXT"), 4, 80);
        ASEBaseHeader aSEBaseHeader6 = new ASEBaseHeader(ASEUtils.getString("DISP_FAMILY_ID_TEXT"), 5, 80);
        ASEBaseHeader aSEBaseHeader7 = new ASEBaseHeader(ASEUtils.getString("DISP_PROCESS_ID_TEXT"), 6, 80);
        ASEBaseHeader aSEBaseHeader8 = new ASEBaseHeader(ASEUtils.getString("DISP_DESC_TEXT"), 7, 80);
        return new ASEBaseHeader[]{aSEBaseHeader, aSEBaseHeader2, aSEBaseHeader3, aSEBaseHeader4, aSEBaseHeader5, aSEBaseHeader6, aSEBaseHeader7, aSEBaseHeader8};
    }

    @Override
    void populate() {
        ServerBO serverBO = (ServerBO)this.getParent();
        ServerSO serverSO = (ServerSO)serverBO.getSO();
        this._helper.setStatusBarMessage(serverSO.getServerLogsFilterMessage());
        if (this.isOpened()) {
            return;
        }
        this.clearItems();
        Throwable throwable = null;
        String string = null;
        String[] stringArray = null;
        try {
            stringArray = serverSO.getLogEntries();
        }
        catch (AuthorizationException authorizationException) {
            string = serverSO instanceof SDCInstanceSO ? ServerBO.getAuthenticationErrorMessage("getInstanceLogFiltered", serverSO) : ServerBO.getAuthenticationErrorMessage("getClusterLogFiltered", serverSO);
            throwable = authorizationException;
        }
        catch (Exception exception) {
            string = serverSO instanceof SDCInstanceSO ? new ASEMessageText(ASEUtils.getString("MSG_OPERATION_FAILED"), "getInstanceLogFiltered", serverSO.getName()).toString() : new ASEMessageText(ASEUtils.getString("MSG_OPERATION_FAILED"), "getClusterLogFiltered", serverSO.getName()).toString();
            throwable = exception;
        }
        if (string != null) {
            Support.showDetailsError(serverSO.getConnection(), this.getClass(), string, throwable);
            return;
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                LogBO logBO = new LogBO(this, new LogSO(serverSO, string2));
                this.addItem((SCItem)logBO);
            }
        }
    }
}

