/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEFileFilter;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TextQueue;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.SQLListener;
import com.sybase.central.editor.EditorEvent;
import com.sybase.central.editor.EditorFrame;
import com.sybase.central.editor.EditorListener;
import com.sybase.central.editor.Parser;
import com.sybase.central.editor.WsqlParser;
import java.awt.Container;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import javax.swing.JFrame;

public class SQLTracer
implements SQLListener,
EditorListener {
    public static final int TRACE_STOP = 0;
    public static final int TRACE_TO_WINDOW = 1;
    public static final int TRACE_TO_FILE = 2;
    private int _traceType = 1;
    private EditorFrame _windowTracer = null;
    private String _traceFileName;
    private FileWriter _traceFile = null;
    private ServerSO _serverSO;
    private ServerBO _serverBO;
    private int _outputWidth;
    private boolean _logSelect;
    private boolean _logOutput;
    private boolean _showRowNumber;
    private boolean _dateTime;
    private long _startTime;
    private boolean _appendGo;
    private JFrame _frame;
    private TextQueue _q;
    private String _title;
    private boolean _running;

    public SQLTracer(int n, ServerBO serverBO, String string, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, JFrame jFrame) {
        this._traceType = n;
        this._serverBO = serverBO;
        this._serverSO = (ServerSO)this._serverBO.getSO();
        this._outputWidth = n2;
        this._logSelect = bl;
        this._logOutput = bl2;
        this._showRowNumber = bl5;
        this._dateTime = bl3;
        this._appendGo = bl4;
        this._frame = jFrame;
        this._traceFileName = string;
        this._q = new TextQueue();
    }

    public void init() throws IOException {
        this._running = true;
        Thread thread = new Thread("tracer " + this._serverSO.getDisplayName()){

            @Override
            public void run() {
                while (SQLTracer.this._running) {
                    String string = SQLTracer.this._q.getText();
                    boolean bl = true;
                    if (SQLTracer.this._traceType == 1) {
                        bl = SQLTracer.this.traceToWindow(string);
                    } else if (SQLTracer.this._traceType == 2) {
                        bl = SQLTracer.this.traceToFile(string);
                    }
                    if (!bl) break;
                    if (!string.startsWith(SQLTracer.this.getStopTraceMessageWithoutTime())) continue;
                    if (SQLTracer.this._traceType != 2 || SQLTracer.this._traceFile == null) break;
                    try {
                        SQLTracer.this._traceFile.flush();
                        SQLTracer.this._traceFile.close();
                    }
                    catch (IOException iOException) {
                        Support.showDetailsError(SQLTracer.this._serverSO.getConnection(), this.getClass(), (Container)SQLTracer.this._frame, iOException.getMessage(), iOException);
                    }
                    break;
                }
            }
        };
        thread.start();
        switch (this._traceType) {
            case 1: {
                this.initTraceToWindow();
                break;
            }
            case 2: {
                this.initTraceToFile();
            }
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String string) {
        this._title = string;
    }

    private void initTraceToWindow() {
        if (this._title == null || this._title.length() == 0) {
            this._title = Support.getFullTitle(ASEUtils.getString("LOG_SQL_EDIT_TITLE"), this._serverSO.getConnection());
        }
        this._windowTracer = Support.getOpenEditor(this._title);
        if (this._windowTracer == null) {
            this._windowTracer = Support.getExtendedEditor(this._title, ServerBO.SERVER_ICON.getImage(), "", (Parser)(this._logOutput ? null : WsqlParser.getInstance()));
            Support.addFileFiltersToEditor(ASEFileFilter.createFileFilters(1), this._windowTracer);
            this._windowTracer.setDefaultExtension("log");
            Support.addOpenEditor(this._title, this._windowTracer, this._serverSO.getConnection());
            this._windowTracer.addEditorListener((EditorListener)this);
            this._windowTracer.setFileName(this._serverSO.getDisplayName() + " SQL");
        }
        String string = this._windowTracer.getText().length() > 0 ? this._windowTracer.getText() + "\n" + this.getStartTraceMessage() : this.getStartTraceMessage();
        this._windowTracer.setText(string);
    }

    private String getDateTimeMessage() {
        String string = new GregorianCalendar().getTime().toString();
        String string2 = "/* " + string + " */\n";
        return string2;
    }

    private String getStartTraceMessage() {
        if (this._serverSO.getConnection() == null) {
            return "";
        }
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("START_LOG_SQL"), this._serverSO.getDisplayName());
        String string = "/* " + aSEMessageText.toString() + " */\n";
        string = string + this.getDateTimeMessage();
        string = string + "/* " + this._serverSO.getConnection().getVersionString() + " */\n\n";
        return string;
    }

    private String getStopTraceMessageWithoutTime() {
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("STOP_LOG_SQL"), this._serverSO.getDisplayName());
        String string = "/* " + aSEMessageText.toString() + " */\n";
        return string;
    }

    private String getStopTraceMessage() {
        String string = this.getStopTraceMessageWithoutTime() + this.getDateTimeMessage();
        return string;
    }

    private void initTraceToFile() throws IOException {
        this._traceFile = new FileWriter(this._traceFileName, true);
        this._traceFile.write(this.getStartTraceMessage());
        this._serverBO.setLoggingFile(this._traceFileName);
    }

    @Override
    public boolean traceSQL(String string) {
        if (!this._logSelect && string.substring(0, 6).compareToIgnoreCase("SELECT") == 0) {
            return false;
        }
        boolean bl = false;
        if (this._dateTime) {
            this._q.putText(this.getDateTimeMessage());
        }
        if (string.startsWith("/*")) {
            this._q.putText(string + "\n");
        } else {
            String string2 = "/* " + this._serverSO.getDisplayName() + " */ ";
            string = string2 + string;
            this._q.putText(this.lineWrapString(string, this._outputWidth));
            bl = true;
            if (this._appendGo) {
                this._q.putText("\ngo\n");
            } else {
                this._q.putText("\n");
            }
        }
        this._startTime = System.currentTimeMillis();
        return bl;
    }

    @Override
    public boolean needOutput() {
        return this._logOutput;
    }

    @Override
    public boolean needRowNumbers() {
        return this._showRowNumber;
    }

    @Override
    public void traceOutput(String string) {
        this._q.putText("\n\n" + string + "\n");
    }

    @Override
    public void traceElapsedTime() {
        if (this._dateTime) {
            long l = System.currentTimeMillis();
            String string = SQLTracer.getElapsedTimeMessage(l - this._startTime);
            this._q.putText("/* " + string + "*/\n\n");
        }
    }

    public static String getElapsedTimeMessage(long l) {
        DecimalFormat decimalFormat = new DecimalFormat("########.###");
        double d = (double)l / 1000.0;
        String string = decimalFormat.format(d);
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_EXECUTION_TIME"), string);
        return aSEMessageText.toString();
    }

    @Override
    public void stopTracing() {
        this._running = false;
        this.traceSQL(this.getStopTraceMessage());
        if (this._serverSO.getConnection() != null) {
            this._serverSO.getConnection().unsetSQLListener();
        }
        this._serverBO.setLoggingSQL(0);
    }

    public void editorSaveRequested(EditorEvent editorEvent) {
        this._windowTracer.saveFile();
        this._windowTracer.setChanged(false);
        this._windowTracer.setTitle(this._title + " (" + Support.makeFullPath(this._windowTracer.getFileName(), this._windowTracer.getDefaultExtension()) + ")");
    }

    public void editorClosed(EditorEvent editorEvent) {
        if (this._windowTracer != null) {
            this._windowTracer.removeEditorListener((EditorListener)this);
        }
        Support.removeOpenEditor(this._title);
        this._serverBO.stopSQLTracer();
        this._windowTracer = null;
    }

    private boolean traceToWindow(String string) {
        if (this._windowTracer == null || this._windowTracer.getEditor() == null) {
            return false;
        }
        boolean bl = this._windowTracer.isChanged();
        this._windowTracer.getEditor().append(string);
        if (!bl) {
            this._windowTracer.setChanged(false);
        }
        return true;
    }

    private boolean traceToFile(String string) {
        if (this._traceFile == null) {
            return false;
        }
        try {
            this._traceFile.write(string);
            this._traceFile.flush();
            return true;
        }
        catch (IOException iOException) {
            Support.showDetailsError(this._serverSO.getConnection(), this.getClass(), (Container)this._frame, iOException.getMessage(), iOException);
            return false;
        }
    }

    private String lineWrapString(String string, int n) {
        String string2 = "";
        String string3 = " (),.";
        if (string == null) {
            return null;
        }
        while (!string.equals("")) {
            if (string.length() <= n) {
                string2 = string2 + string;
                string = "";
                continue;
            }
            int n2 = n;
            try {
                String string4 = string.substring(0, n2);
                int n3 = string4.lastIndexOf(10);
                if (n3 > 0) {
                    string2 = string2 + string.substring(0, n3 + 1);
                    string = string.substring(n3 + 1);
                    continue;
                }
                while (string3.indexOf(string.charAt(n2)) == -1) {
                    if (--n2 >= 0) continue;
                    string2 = string2 + string.substring(0, n + 1) + "\n";
                    string = string.substring(n + 1);
                }
                string2 = string2 + string.substring(0, n2 + 1) + "\n";
                string = string.substring(n2 + 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
        }
        return string2;
    }
}

