/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ScheduledJobsCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.ScheduleProperties;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ScheduleSO;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ScheduleBO
extends ASEBaseItem2 {
    public static final ImageIcon SCHEDULE_ICON = new ImageIcon(ASEImages.getScheduleSmallImage());
    public static final ImageIcon NEW_SCHEDULE_ICON = new ImageIcon(ASEImages.getNewScheduleImage());
    public static final int CMD_DUPLICATE = 3001;

    public ScheduleBO(SOItemInterface sOItemInterface, ASEBaseContainer2 aSEBaseContainer2) {
        super(sOItemInterface, aSEBaseContainer2, (Icon)SCHEDULE_ICON);
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 96;
    }

    @Override
    public SCMenu getContextMenu() {
        if (this._contextMenu != null) {
            return this._contextMenu;
        }
        this._contextMenu = new ASEMenu();
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3001, ASEUtils.getString("CONTEXT_MENU_DUPLICATE_AS_TEXT"), ASEUtils.getString("CONTEXT_MENU_DUPLICATE_SCHEDULE_HINT"), Support.getMnemonic("CONTEXT_MENU_DUPLICATE_AS_MNEM"));
        this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        return this._contextMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        ScheduledJobsCtrBO scheduledJobsCtrBO = null;
        if (n == 3001) {
            scheduledJobsCtrBO = (ScheduledJobsCtrBO)this._parent.getParent();
            if (!scheduledJobsCtrBO.isJSAuthorized()) {
                Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_NO_JS_COPY_ROLE"));
                return;
            }
            String string = JOptionPane.showInputDialog(jFrame, ASEUtils.getString("NAME_SCHEDULE_INPUT_DIALOG_TEXT"), ASEUtils.getString("NAME_SCHEDULE_INPUT_DIALOG_TITLE"), 3);
            if (string != null) {
                try {
                    ScheduleSO scheduleSO = (ScheduleSO)this.getSO();
                    scheduleSO.copy(string);
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                }
                this.getParent().refresh();
            }
        } else if (n == 106) {
            scheduledJobsCtrBO = (ScheduledJobsCtrBO)this._parent.getParent();
            if (!scheduledJobsCtrBO.isJSAuthorized()) {
                Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_NO_JS_DELETE_ROLE"));
                return;
            }
            super.onCommand(jFrame, n, enumeration, n2);
        } else {
            super.onCommand(jFrame, n, enumeration, n2);
        }
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        return new ScheduleProperties((ScheduleSO)this.getSO(), (SCContainer2)this.getParent());
    }
}

