/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.JobBO;
import com.sybase.aseplugin.bo.ScheduleBO;
import com.sybase.aseplugin.bo.ScheduledJobsCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.ScheduledJobProperties;
import com.sybase.aseplugin.so.JSBaseSO;
import com.sybase.aseplugin.so.JobSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ScheduleSO;
import com.sybase.aseplugin.so.ScheduledJobSO;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class ScheduledJobBO
extends ASEBaseItem2 {
    public static final ImageIcon SCHEDULEDJOB_ICON = new ImageIcon(ASEImages.getScheduledJobSmallImage());
    public static final ImageIcon NEW_SCHEDULEDJOB_ICON = new ImageIcon(ASEImages.getNewScheduledJobImage());
    private static final int CMD_ENABLE = 3001;
    private static final int CMD_DISABLE = 3002;
    private static final int CMD_RUNNOW = 3003;
    private static final int CMD_TERMINATE = 3004;
    private static final int CMD_JOBPROP = 3005;
    private static final int CMD_SCHEDPROP = 3006;
    private ASEMenuItem _enableItem;
    private ASEMenuItem _disableItem;
    private ASEMenuItem _runNowItem;
    private ASEMenuItem _terminateItem;
    private ASEMenuItem _jobpropItem;
    private ASEMenuItem _schedpropItem;

    public ScheduledJobBO(SOItemInterface sOItemInterface, ASEBaseContainer2 aSEBaseContainer2) {
        super(sOItemInterface, aSEBaseContainer2, (Icon)SCHEDULEDJOB_ICON);
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 96;
    }

    @Override
    public SCMenu getContextMenu() {
        ScheduledJobSO scheduledJobSO = (ScheduledJobSO)this.getSO();
        boolean bl = scheduledJobSO.getEnabled();
        boolean bl2 = scheduledJobSO.canRunNow();
        boolean bl3 = scheduledJobSO.canTerminate();
        if (this._contextMenu == null) {
            this._contextMenu = new ASEMenu();
            this._enableItem = new ASEMenuItem(3001, ASEUtils.getString("CONTEXT_MENU_ENABLE_TEXT"), ASEUtils.getString("CONTEXT_MENU_ENABLE_SJ_HINT"), Support.getMnemonic("CONTEXT_MENU_ENABLE_MNEM"));
            this._disableItem = new ASEMenuItem(3002, ASEUtils.getString("CONTEXT_MENU_DISABLE_TEXT"), ASEUtils.getString("CONTEXT_MENU_DISABLE_SJ_HINT"), Support.getMnemonic("CONTEXT_MENU_DISABLE_MNEM"));
            this._runNowItem = new ASEMenuItem(3003, ASEUtils.getString("CONTEXT_MENU_RUNNOW_TEXT"), ASEUtils.getString("CONTEXT_MENU_RUNNOW_SJ_HINT"), Support.getMnemonic("CONTEXT_MENU_RUNNOW_MNEM"));
            this._terminateItem = new ASEMenuItem(3004, ASEUtils.getString("CONTEXT_MENU_TERMINATE_TEXT"), ASEUtils.getString("CONTEXT_MENU_TERMINATE_SJ_HINT"), Support.getMnemonic("CONTEXT_MENU_TERMINATE_MNEM"));
            this._jobpropItem = new ASEMenuItem(3005, ASEUtils.getString("CONTEXT_MENU_JOBPROP_TEXT"), ASEUtils.getString("CONTEXT_MENU_JOBPROP_HINT"), Support.getMnemonic("CONTEXT_MENU_JOBPROP_MNEM"), ASEMenuItem.PROPERTIES_ICON);
            this._schedpropItem = new ASEMenuItem(3006, ASEUtils.getString("CONTEXT_MENU_SCHEDPROP_TEXT"), ASEUtils.getString("CONTEXT_MENU_SCHEDPROP_HINT"), Support.getMnemonic("CONTEXT_MENU_SCHEDPROP_MNEM"), ASEMenuItem.PROPERTIES_ICON);
            this._contextMenu.addItem((SCMenuItem)this._enableItem);
            this._contextMenu.addItem((SCMenuItem)this._disableItem);
            this._contextMenu.addItem((SCMenuItem)this._runNowItem);
            this._contextMenu.addItem((SCMenuItem)this._terminateItem);
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
            this._contextMenu.addItem((SCMenuItem)this._jobpropItem);
            this._contextMenu.addItem((SCMenuItem)this._schedpropItem);
        }
        this._enableItem.setEnabled(!bl);
        this._disableItem.setEnabled(bl);
        this._runNowItem.setEnabled(bl2);
        this._terminateItem.setEnabled(bl3);
        return this._contextMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        ScheduledJobSO scheduledJobSO = (ScheduledJobSO)this.getSO();
        ScheduledJobsCtrBO scheduledJobsCtrBO = (ScheduledJobsCtrBO)this._parent;
        if (!scheduledJobsCtrBO.isJSAuthorized()) {
            switch (n) {
                case 3001: 
                case 3002: {
                    Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_NO_SJ_ENABLE_ROLE"));
                    return;
                }
                case 3003: {
                    Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_NO_SJ_RUN_ROLE"));
                    return;
                }
                case 3004: {
                    Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_NO_SJ_TERM_ROLE"));
                    return;
                }
                case 106: {
                    Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_NO_SJ_DELETE_ROLE"));
                    return;
                }
            }
            return;
        }
        switch (n) {
            case 3001: 
            case 3002: 
            case 3003: 
            case 3004: {
                try {
                    if (n == 3001 || n == 3002) {
                        scheduledJobSO.enable(n == 3001);
                    } else if (n == 3003) {
                        scheduledJobSO.runnow();
                    } else {
                        scheduledJobSO.terminate();
                    }
                    ScheduledJobsCtrBO scheduledJobsCtrBO2 = (ScheduledJobsCtrBO)this.getParent();
                    scheduledJobsCtrBO2.refresh();
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), ASEMessageText.toString(sQLException), sQLException);
                }
                break;
            }
            case 3005: 
            case 3006: {
                ScheduledJobsCtrBO scheduledJobsCtrBO3 = (ScheduledJobsCtrBO)this.getParent();
                ASEBaseItem2 aSEBaseItem2 = null;
                ASEBaseContainer2 aSEBaseContainer2 = n == 3005 ? scheduledJobsCtrBO3.getJobsFolder() : scheduledJobsCtrBO3.getSchedulesFolder();
                try {
                    Vector vector = aSEBaseContainer2.getItems(0);
                    Enumeration enumeration2 = vector.elements();
                    while (enumeration2.hasMoreElements()) {
                        JSBaseSO jSBaseSO;
                        ASEBaseItem2 aSEBaseItem22;
                        Object e = enumeration2.nextElement();
                        if (e instanceof JobBO) {
                            aSEBaseItem22 = (JobBO)e;
                            jSBaseSO = (JobSO)aSEBaseItem22.getSO();
                            if (scheduledJobSO.getJobID() == jSBaseSO.getID(0)) {
                                aSEBaseItem2 = aSEBaseItem22;
                                break;
                            }
                        }
                        if (!(e instanceof ScheduleBO)) continue;
                        aSEBaseItem22 = (ScheduleBO)e;
                        jSBaseSO = (ScheduleSO)aSEBaseItem22.getSO();
                        if (scheduledJobSO.getScheduleID() != jSBaseSO.getID(0)) continue;
                        aSEBaseItem2 = aSEBaseItem22;
                        break;
                    }
                    if (aSEBaseItem2 == null) break;
                    this.showDialog(jFrame, aSEBaseItem2);
                }
                catch (Exception exception) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), exception.getMessage(), exception);
                }
                break;
            }
            default: {
                super.onCommand(jFrame, n, enumeration, n2);
            }
        }
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        return new ScheduledJobProperties((ScheduledJobSO)this.getSO(), (ScheduledJobsCtrBO)this.getParent());
    }
}

