/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.JSBaseInterface;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.JobHistoriesCtrBO;
import com.sybase.aseplugin.bo.JobsCtrBO;
import com.sybase.aseplugin.bo.ScheduledJobBO;
import com.sybase.aseplugin.bo.SchedulesCtrBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.JobSchedulerAdminDialog;
import com.sybase.aseplugin.bo.wiz.ScheduledJobWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.JobSchedulerAdminSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ScheduledJobSO;
import com.sybase.aseplugin.so.ScheduledJobsCtrSO;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class ScheduledJobsCtrBO
extends ASEBaseContainer2
implements JSBaseInterface {
    static final int SJ_ID_COL = 1;
    static final int SJ_JOB_NAME_COL = 2;
    static final int SJ_SCHED_NAME_COL = 3;
    static final int SJ_SERVER_COL = 4;
    static final int SJ_OWNER_COL = 5;
    static final int SJ_CREATED_COL = 6;
    static final int SJ_STATUS_COL = 7;
    static final int SJ_STATE_COL = 8;
    static final int SJ_LASTEXECTIME_COL = 9;
    static final int SJ_LASTEXECRESULT_COL = 10;
    static final int SJ_NEXTEXEC_COL = 11;
    private static final int CMD_ADMIN = 3001;
    private static final int CMD_ALL_USERS = 3002;
    private static final int CMD_NEW_SCHEDULED_JOB = 3003;
    public static final ImageIcon ADMIN_JOB_SCHEDULER_ICON = new ImageIcon(ASEImages.getAdminJobSchedulerImage());
    private JobsCtrBO _jobsCtrBO;
    private SchedulesCtrBO _schedulesCtrBO;
    private JobHistoriesCtrBO _jobHistoriesCtrBO;
    private ASEMenuItem _allUsersItem;
    private boolean _showAllUsers = false;

    public ScheduledJobsCtrBO(ServerBO serverBO) {
        super(ASEUtils.getString("DNAME_SCHEDULEDJOBS"), (ASEBaseContainer2)serverBO);
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        return new ASEBaseHeader[]{new ASEBaseHeader(ASEUtils.getString("DISP_ID_TEXT"), 0, 170, 1), new ASEBaseHeader(ASEUtils.getString("DISP_JOB_NAME_TEXT"), 1, 170), new ASEBaseHeader(ASEUtils.getString("DISP_SCHEDULE_NAME_TEXT"), 2, 170), new ASEBaseHeader(ASEUtils.getString("DISP_SERVER_TEXT"), 3, 170), new ASEBaseHeader(ASEUtils.getString("DISP_CREATOR_TEXT"), 4, 70), new ASEBaseHeader(ASEUtils.getString("DISP_CREATION_DATE_TEXT"), 5, 140, 2), new ASEBaseHeader(ASEUtils.getString("DISP_STATUS_TEXT"), 6, 80), new ASEBaseHeader(ASEUtils.getString("DISP_STATE_TEXT"), 7, 80), new ASEBaseHeader(ASEUtils.getString("DISP_LAST_EXECUTION_TEXT"), 8, 140, 2), new ASEBaseHeader(ASEUtils.getString("DISP_LAST_EXECUTION_RESULT_TEXT"), 9, 170), new ASEBaseHeader(ASEUtils.getString("DISP_NEXT_EXECUTION_TEXT"), 10, 140, 2)};
    }

    @Override
    public Vector getItems(int n) throws Exception {
        ScheduledJobsCtrSO scheduledJobsCtrSO = new ScheduledJobsCtrSO(this.getConnection());
        if (scheduledJobsCtrSO.isSchedulerInstalled()) {
            if (scheduledJobsCtrSO.isJSAuthorized()) {
                if (scheduledJobsCtrSO.isSybmgmtdbUser()) {
                    return this.getItems(scheduledJobsCtrSO);
                }
            } else {
                Support.showInfo(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_NOT_JS_USER"));
            }
        }
        return null;
    }

    private Vector getItems(ScheduledJobsCtrSO scheduledJobsCtrSO) throws SQLException {
        scheduledJobsCtrSO.setShowAllUsers(this._showAllUsers);
        Vector<ASEBaseItem2> vector = new Vector<ASEBaseItem2>();
        if (this.isSchedulerInstalled()) {
            Vector vector2 = (Vector)scheduledJobsCtrSO.open(1, null);
            if (vector2 != null) {
                for (int i = 0; i < vector2.size(); ++i) {
                    ScheduledJobSO scheduledJobSO = (ScheduledJobSO)vector2.elementAt(i);
                    vector.addElement(new ScheduledJobBO((SOItemInterface)scheduledJobSO, this));
                }
            }
            this._jobsCtrBO = new JobsCtrBO(this, scheduledJobsCtrSO.getConnection());
            vector.addElement(this._jobsCtrBO);
            this._schedulesCtrBO = new SchedulesCtrBO(this, scheduledJobsCtrSO.getConnection());
            vector.addElement(this._schedulesCtrBO);
            this._jobHistoriesCtrBO = new JobHistoriesCtrBO(this);
            vector.addElement(this._jobHistoriesCtrBO);
        }
        return vector;
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        String string = ASEUtils.getString("MSG_SCHEDULEDJOB_TYPE");
        String string2 = ASEUtils.getString("CREATION_HINT_NEW_SCHEDULEDJOB");
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3003, string, string2, Support.getMnemonic("CREATION_MNEM_NEW_SCHEDULEDJOB"), ScheduledJobBO.SCHEDULEDJOB_ICON);
        return new ASEMenuItem[]{aSEMenuItem};
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3003, ScheduledJobBO.NEW_SCHEDULEDJOB_ICON, ASEUtils.getString("MSG_SCHEDULEDJOB_TYPE"), ASEUtils.getString("CREATION_HINT_NEW_SCHEDULEDJOB"));
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public ASEToolBarButton[] getContextButtons() {
        ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3001, ADMIN_JOB_SCHEDULER_ICON, ASEUtils.getString("CONTEXT_MENU_ADMIN_TEXT"), ASEUtils.getString("CONTEXT_MENU_ADMIN_JS_HINT"));
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public int[] getEnabledContextCmdIds() {
        return new int[]{3001};
    }

    @Override
    public SCMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ASEMenu();
            ASEMenuItem aSEMenuItem = new ASEMenuItem(3001, ASEUtils.getString("CONTEXT_MENU_ADMIN_TEXT"), ASEUtils.getString("CONTEXT_MENU_ADMIN_JS_HINT"), Support.getMnemonic("CONTEXT_MENU_ADMIN_MNEM"));
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
            if (this.isAdministrator()) {
                this._allUsersItem = new ASEMenuItem(4, 3002, ASEUtils.getString("CONTEXT_MENU_SHOWALLUSERS_JOB_TEXT"), ASEUtils.getString("CONTEXT_MENU_SHOWALLUSERS_JOB_HINT"), Support.getMnemonic("CONTEXT_MENU_SHOWALLUSERS_MNEM"));
                this._allUsersItem.setSelected(this._showAllUsers);
                this._contextMenu.addItem((SCMenuItem)this._allUsersItem);
            }
        }
        return this._contextMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        if (n == 3001) {
            JobSchedulerAdminSO jobSchedulerAdminSO = new JobSchedulerAdminSO(this.getConnection());
            JobSchedulerAdminDialog jobSchedulerAdminDialog = new JobSchedulerAdminDialog(Support.createDialogSupport(Support.getViewerFrame()), jobSchedulerAdminSO);
            jobSchedulerAdminDialog.start(this);
        } else if (n == 3002) {
            this._showAllUsers = !this._showAllUsers;
            this._allUsersItem.setSelected(this._showAllUsers);
            this.refresh();
        } else if (n == 3003) {
            if (!this.isJSAuthorized()) {
                Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_NO_SCHEDJOB_ROLE"));
            } else {
                ScheduledJobSO scheduledJobSO = new ScheduledJobSO(this.getConnection());
                ASEBaseDialog2.showDialog(jFrame, new ScheduledJobWizard(scheduledJobSO, (ASEBaseContainer2)this));
            }
        } else {
            super.onCommand(jFrame, n, enumeration, n2);
        }
    }

    @Override
    public int getAttributes() {
        return 1;
    }

    public JobsCtrBO getJobsFolder() {
        return this._jobsCtrBO;
    }

    public SchedulesCtrBO getSchedulesFolder() {
        return this._schedulesCtrBO;
    }

    public boolean isSchedulerInstalled() throws SQLException {
        ScheduledJobsCtrSO scheduledJobsCtrSO = new ScheduledJobsCtrSO(this.getConnection());
        return scheduledJobsCtrSO.isSchedulerInstalled();
    }

    public boolean isJSUser() {
        ScheduledJobsCtrSO scheduledJobsCtrSO = new ScheduledJobsCtrSO(this.getConnection());
        boolean bl = false;
        try {
            if (scheduledJobsCtrSO.isJSAuthorized()) {
                bl = scheduledJobsCtrSO.isSybmgmtdbUser();
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
        }
        return bl;
    }

    public boolean isJSAuthorized() {
        boolean bl;
        ScheduledJobsCtrSO scheduledJobsCtrSO = new ScheduledJobsCtrSO(this.getConnection());
        try {
            bl = scheduledJobsCtrSO.isJSAuthorized();
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            bl = false;
        }
        return bl;
    }

    public boolean isAdministrator() {
        boolean bl;
        ScheduledJobsCtrSO scheduledJobsCtrSO = new ScheduledJobsCtrSO(this.getConnection());
        try {
            bl = scheduledJobsCtrSO.isAdministrator();
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            bl = false;
        }
        return bl;
    }

    public boolean isUser() {
        boolean bl;
        ScheduledJobsCtrSO scheduledJobsCtrSO = new ScheduledJobsCtrSO(this.getConnection());
        try {
            bl = scheduledJobsCtrSO.isUser();
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            bl = false;
        }
        return bl;
    }

    public boolean isClient() {
        boolean bl;
        ScheduledJobsCtrSO scheduledJobsCtrSO = new ScheduledJobsCtrSO(this.getConnection());
        try {
            bl = scheduledJobsCtrSO.isClient();
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            bl = false;
        }
        return bl;
    }

    public String getMaxAuthorization() {
        String string;
        ScheduledJobsCtrSO scheduledJobsCtrSO = new ScheduledJobsCtrSO(this.getConnection());
        try {
            string = scheduledJobsCtrSO.getMaxAuthorization();
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            string = null;
        }
        return string;
    }
}

