/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.SegmentProperties;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.SegmentSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class SegmentBO
extends ASEBaseItem2 {
    public static final String DEFAULT = "default";
    public static final String LOGSEGMENT = "logsegment";
    public static final String SYSTEM = "system";
    public static final ImageIcon SEGMENT_ICON = new ImageIcon(ASEImages.getSegmentSmallImage());
    public static final ImageIcon NEW_SEGMENT_ICON = new ImageIcon(ASEImages.getNewSegmentImage());
    private static final int CMD_CHECK = 3001;
    private static final int CMD_EXPAND = 3002;
    private static final int CMD_SIMULATE = 3003;
    private static String _editorTitle;
    private static String _editorFileName;
    private SegmentSO _segSO;

    public SegmentBO(SegmentSO segmentSO, ASEBaseContainer2 aSEBaseContainer2) {
        super((SOItemInterface)segmentSO, aSEBaseContainer2, (Icon)SEGMENT_ICON);
        this._segSO = segmentSO;
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        SegmentProperties segmentProperties = new SegmentProperties((SegmentSO)this.getSO(), (SCContainer2)this.getParent());
        return segmentProperties;
    }

    @Override
    public String getDisplayName(int n) {
        String string = "";
        switch (n) {
            case 0: 
            case 1: {
                return super.getDisplayName(n);
            }
            case 2: {
                string = this._segSO.getSegSize();
                break;
            }
            case 3: {
                string = this._segSO.getSegUsed();
                break;
            }
            case 4: {
                string = this._segSO.getSegFree();
                break;
            }
        }
        if (string.length() > 0) {
            double d = Double.valueOf(string);
            double d2 = Utility.getPageSizeToMB(this.getSO().getConnection(), d);
            return String.valueOf(Utility.getPrecision(d2, 3));
        }
        return string;
    }

    @Override
    public boolean includeDelete() {
        boolean bl;
        String string = this.getSO().getName();
        boolean bl2 = bl = string.equals(DEFAULT) || string.equals(LOGSEGMENT) || string.equals(SYSTEM);
        if (bl) {
            return false;
        }
        return super.includeDelete();
    }

    @Override
    public boolean includeDDLGen() {
        return true;
    }

    @Override
    public SCMenu getContextMenu() {
        this._contextMenu = new ASEMenu();
        this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getDDLGenMenuItem());
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        try {
            if (this._segSO.getDatabaseSO().isAutoExpansionApplicable()) {
                ASEMenu aSEMenu = new ASEMenu(ASEUtils.getString("AUTOMATIC_EXPANSION"));
                aSEMenu.setMnemonic(Support.getMnemonic("GENERATE_DDL_MNEM"));
                ASEMenuItem aSEMenuItem = new ASEMenuItem(3001, ASEUtils.getString("CHECK"), ASEUtils.getString("CONTEXT_MENU_CHECK_HINT"), Support.getMnemonic("MNEM_CHECK"));
                aSEMenu.addItem((SCMenuItem)aSEMenuItem);
                ASEMenuItem aSEMenuItem2 = new ASEMenuItem(3002, ASEUtils.getString("EXPAND"), ASEUtils.getString("CONTEXT_MENU_EXPAND_HINT"), Support.getMnemonic("MNEM_EXPAND"));
                aSEMenu.addItem((SCMenuItem)aSEMenuItem2);
                ASEMenuItem aSEMenuItem3 = new ASEMenuItem(3003, ASEUtils.getString("SIMULATE"), ASEUtils.getString("CONTEXT_MENU_SIMULATE_HINT"), Support.getMnemonic("MNEM_SIMULATE"));
                aSEMenu.addItem((SCMenuItem)aSEMenuItem3);
                this._contextMenu.addItem((SCMenuItem)aSEMenu);
                this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
        }
        if (this.includeDelete()) {
            this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        }
        this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        return this._contextMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        try {
            if (_editorTitle == null) {
                _editorFileName = _editorTitle = Support.getFullTitle(ASEUtils.getString("AUTOMATIC_EXPANSION"), this._segSO.getConnection());
            }
            if (n == 3001) {
                String string = this._segSO.checkExpansion();
                if (string.equals("")) {
                    return;
                }
                Support.writeToExtendedLogFileEditor(_editorTitle, ASEImages.getSegmentSmallImage(), string, this._segSO.getConnection(), null, _editorFileName);
            } else if (n == 3003) {
                Support.writeToExtendedLogFileEditor(_editorTitle, ASEImages.getSegmentSmallImage(), this._segSO.simulateExpansion(), this._segSO.getConnection(), null, _editorFileName);
            } else if (n == 3002) {
                int n3 = Support.showQuestionYesNo(new ASEMessageText(ASEUtils.getString("MSG_SEG_CONFIRM_EXPAND"), this._segSO.getName()).toString());
                if (n3 == 0) {
                    Support.writeToExtendedLogFileEditor(_editorTitle, ASEImages.getSegmentSmallImage(), this._segSO.expand(), this._segSO.getConnection(), null, _editorFileName);
                }
            } else {
                super.onCommand(jFrame, n, enumeration, n2);
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
        }
    }
}

