/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.LoginBO;
import com.sybase.aseplugin.bo.RoleBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TopBO;
import com.sybase.aseplugin.bo.dlg.ASEDialogController;
import com.sybase.aseplugin.bo.dlg.CopyObjectDialog;
import com.sybase.aseplugin.bo.dlg.ExecuteSQLDialog;
import com.sybase.aseplugin.bo.dlg.ExportServerGroupsDialog;
import com.sybase.aseplugin.bo.dlg.ItemsConfirmDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.ServerGroupProperties;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.ASEBaseSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ServerGroupSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class ServerGroupBO
extends ASEBaseContainer2 {
    public static final int CMD_NEW_CONNECTION = 3061;
    public static final int CMD_CONNECT_ALL = 3062;
    public static final int CMD_DISCONNECT_ALL = 3063;
    public static final int CMD_EXPORT = 3064;
    public static final int CMD_START_ALL = 3065;
    public static final int CMD_SHUTDOWN_ALL = 3066;
    public static final int CMD_SQL_EXECUTION = 3067;
    public static final ImageIcon SERVER_GROUP_ICON = new ImageIcon(ASEImages.getServerGroupSmallImage());
    public static final ImageIcon NEW_SERVER_GROUP_ICON = new ImageIcon(ASEImages.getNewServerGroupImage());
    private static final String[] PASTABLE_CLASS_NAMES = new String[]{LoginBO.class.getName(), RoleBO.class.getName(), ServerBO.class.getName()};

    public ServerGroupBO(TopBO topBO, ServerGroupSO serverGroupSO) {
        super(topBO, (SOItemInterface)serverGroupSO, (Icon)SERVER_GROUP_ICON);
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        ASEBaseHeader aSEBaseHeader = new ASEBaseHeader(ASEUtils.getString("DISP_SERVER_TEXT"), 0, 170);
        ASEBaseHeader aSEBaseHeader2 = new ASEBaseHeader(ASEUtils.getString("DISP_VERSION_TEXT"), 1, 80);
        ASEBaseHeader aSEBaseHeader3 = new ASEBaseHeader(ASEUtils.getString("DISP_PLATFORM_OS_TEXT"), 2, 170);
        ASEBaseHeader aSEBaseHeader4 = new ASEBaseHeader(ASEUtils.getString("DISP_HOST_PORT_TEXT"), 3, 170);
        ASEBaseHeader aSEBaseHeader5 = new ASEBaseHeader(ASEUtils.getString("DISP_STATUS_TEXT"), 4, 80);
        ASEBaseHeader aSEBaseHeader6 = new ASEBaseHeader(ASEUtils.getString("MSG_CONNECTED"), 5, 80);
        return new ASEBaseHeader[]{aSEBaseHeader, aSEBaseHeader2, aSEBaseHeader3, aSEBaseHeader4, aSEBaseHeader5, aSEBaseHeader6};
    }

    @Override
    public Vector getItems(int n) {
        Vector<ServerBO> vector = new Vector<ServerBO>();
        TopBO topBO = (TopBO)this.getParent();
        Iterator iterator = topBO.getServersIterator();
        while (iterator.hasNext()) {
            ServerSO serverSO = (ServerSO)iterator.next();
            ServerGroupSO serverGroupSO = serverSO.getServerGroup();
            ServerGroupSO serverGroupSO2 = (ServerGroupSO)this.getSO();
            if (serverGroupSO == null || serverGroupSO2 == null || !serverGroupSO.equals(serverGroupSO2)) continue;
            ServerBO serverBO = new ServerBO(this, serverSO);
            topBO.updateServerStatus(serverBO);
            vector.add(serverBO);
        }
        return vector;
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        String string = ASEUtils.getString("DISP_CONNECTION_TEXT");
        String string2 = ASEUtils.getString("CONTEXT_MENU_CONNECT_HINT");
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3061, string, string2, '\u0000', ASEMenuItem.CONNECT_ICON);
        return new ASEMenuItem[]{aSEMenuItem};
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3061, ASEMenuItem.CONNECT_ICON, ASEUtils.getString("DISP_CONNECTION_TEXT"), ASEUtils.getString("CONTEXT_MENU_CONNECT_HINT"));
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public SCMenu getContextMenu() {
        Comparable comparable;
        Object object;
        TopBO topBO = (TopBO)this.getParent();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Object object2 = topBO.getServersIterator();
        while (object2.hasNext()) {
            object = (ServerSO)object2.next();
            comparable = ((ServerSO)object).getServerGroup();
            if (comparable == null || !((ServerGroupSO)comparable).equals(this.getSO())) continue;
            ++n;
            if (((ASEBaseSO)object).getConnection() != null) {
                ++n2;
                ++n4;
                continue;
            }
            if (!ServerBO.getEnableUAF((ServerSO)object)) continue;
            if (((ServerSO)object).isRunning()) {
                ++n4;
                continue;
            }
            ++n3;
        }
        this._contextMenu = new ASEMenu();
        object2 = ASEUtils.getString("CONTEXT_MENU_CONNECT_TEXT");
        object = ASEUtils.getString("CONTEXT_MENU_CONNECT_HINT");
        comparable = new ASEMenuItem(3061, (String)object2, (String)object, Support.getMnemonic("CONTEXT_MENU_CONNECT_MNEM"), ASEMenuItem.CONNECT_ICON);
        this._contextMenu.addItem((SCMenuItem)comparable);
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        object2 = ASEUtils.getString("CONTEXT_MENU_CONNECT_ALL_TEXT");
        object = ASEUtils.getString("CONTEXT_MENU_CONNECT_ALL_HINT");
        comparable = new ASEMenuItem(3062, (String)object2, (String)object, Support.getMnemonic("CONTEXT_MENU_CONNECT_ALL_MNEM"));
        ((ASEMenuItem)comparable).setEnabled(n2 < n);
        this._contextMenu.addItem((SCMenuItem)comparable);
        object2 = ASEUtils.getString("CONTEXT_MENU_DISCONNECT_ALL_TEXT");
        object = ASEUtils.getString("CONTEXT_MENU_DISCONNECT_ALL_HINT");
        comparable = new ASEMenuItem(3063, (String)object2, (String)object, Support.getMnemonic("CONTEXT_MENU_DISCONNECT_ALL_MNEM"));
        ((ASEMenuItem)comparable).setEnabled(n2 > 0);
        this._contextMenu.addItem((SCMenuItem)comparable);
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        object2 = ASEUtils.getString("CONTEXT_MENU_START_ALL_TEXT");
        object = ASEUtils.getString("CONTEXT_MENU_START_ALL_HINT");
        comparable = new ASEMenuItem(3065, (String)object2, (String)object, Support.getMnemonic("CONTEXT_MENU_START_ALL_MNEM"));
        ((ASEMenuItem)comparable).setEnabled(n3 > 0);
        this._contextMenu.addItem((SCMenuItem)comparable);
        object2 = ASEUtils.getString("CONTEXT_MENU_SHUTDOWN_ALL_TEXT");
        object = ASEUtils.getString("CONTEXT_MENU_SHUTDOWN_ALL_HINT");
        comparable = new ASEMenuItem(3066, (String)object2, (String)object, Support.getMnemonic("CONTEXT_MENU_SHUTDOWN_ALL_MNEM"));
        ((ASEMenuItem)comparable).setEnabled(n4 > 0);
        this._contextMenu.addItem((SCMenuItem)comparable);
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        object2 = ASEUtils.getString("CONTEXT_MENU_EXPORT_TEXT");
        object = ASEUtils.getString("CONTEXT_MENU_EXPORT_HINT");
        comparable = new ASEMenuItem(3064, (String)object2, (String)object, Support.getMnemonic("CONTEXT_MENU_EXPORT_MNEM"));
        this._contextMenu.addItem((SCMenuItem)comparable);
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        object2 = ASEUtils.getString("CONTEXT_MENU_SQL_EXECUTION_TEXT");
        object = ASEUtils.getString("CONTEXT_MENU_SQL_EXECUTION_HINT");
        comparable = new ASEMenuItem(3067, (String)object2, (String)object, Support.getMnemonic("CONTEXT_MENU_SQL_EXECUTION_MNEM"));
        ((ASEMenuItem)comparable).setEnabled(n2 > 0);
        this._contextMenu.addItem((SCMenuItem)comparable);
        boolean bl = false;
        if (this.includeDelete()) {
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            bl = true;
            this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
        }
        if (this.includePaste()) {
            if (!bl) {
                this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            }
            ASEMenuItem aSEMenuItem = ASEMenuItem.getPasteMenuItem();
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        }
        if (this.includeProperties()) {
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        }
        return this._contextMenu;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return super.isOkToBatch(n) || n == 3063 || n == 3062 || n == 3065 || n == 3066;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 3061: {
                ASConnection aSConnection = Support.getProvider().connect(jFrame, (ServerGroupSO)this.getSO());
                if (aSConnection == null) break;
                Support.getProvider().handleRefreshConnect(this.getSO().getName(), aSConnection);
                break;
            }
            case 3062: 
            case 3063: {
                this.handleAllConnections(jFrame, n, enumeration, n2);
                break;
            }
            case 3065: {
                this.handleStartAll(jFrame, enumeration, n2);
                break;
            }
            case 3066: {
                this.handleShutdownAll(jFrame, enumeration);
                break;
            }
            case 3064: {
                ServerGroupSO serverGroupSO = (ServerGroupSO)this.getSO();
                ExportServerGroupsDialog exportServerGroupsDialog = ExportServerGroupsDialog.showDialog(jFrame, serverGroupSO);
                exportServerGroupsDialog.render();
                break;
            }
            case 3067: {
                ExecuteSQLDialog.showDialog(jFrame, (ServerGroupSO)this.getSO());
                break;
            }
            default: {
                super.onCommand(jFrame, n, enumeration, n2);
            }
        }
    }

    private void handleStartAll(JFrame jFrame, Enumeration enumeration, int n) {
        while (enumeration.hasMoreElements()) {
            ServerGroupBO serverGroupBO = (ServerGroupBO)enumeration.nextElement();
            Enumeration enumeration2 = serverGroupBO.getItems();
            Vector<ServerBO> vector = new Vector<ServerBO>();
            ServerBO serverBO = null;
            while (enumeration2.hasMoreElements()) {
                ServerSO serverSO;
                Object e = enumeration2.nextElement();
                if (!(e instanceof ServerBO) || !(serverSO = (ServerSO)(serverBO = (ServerBO)e).getSO()).isUAFMonitored() || serverSO.isRunning()) continue;
                vector.add(serverBO);
            }
            if (serverBO == null) continue;
            serverBO.onCommand(jFrame, 3076, vector.elements(), n);
        }
    }

    private void handleShutdownAll(JFrame jFrame, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            ServerGroupBO serverGroupBO = (ServerGroupBO)enumeration.nextElement();
            Enumeration enumeration2 = serverGroupBO.getItems();
            ArrayList<ServerBO> arrayList = new ArrayList<ServerBO>();
            Vector<ServerBO> vector = new Vector<ServerBO>();
            Vector<ServerBO> vector2 = new Vector<ServerBO>();
            ServerBO serverBO = null;
            boolean bl = false;
            while (enumeration2.hasMoreElements()) {
                object2 = enumeration2.nextElement();
                if (!(object2 instanceof ServerBO)) continue;
                serverBO = (ServerBO)object2;
                object = (ServerSO)serverBO.getSO();
                if (((ASEBaseSO)object).getConnection() != null) {
                    bl = true;
                    if (!((ASEBaseSO)object).getConnection().hasSARole()) continue;
                    arrayList.add(serverBO);
                    vector.add(serverBO);
                    continue;
                }
                if (!((ServerSO)object).isRunning()) continue;
                arrayList.add(serverBO);
                vector2.add(serverBO);
            }
            object2 = Support.createDialogSupport(jFrame);
            object = new ItemsConfirmDialog((SCDialogSupport)object2, ASEUtils.getString("CONTEXT_MENU_SHUTDOWN_ALL_TEXT"), ASEUtils.getString("MSG_SHUTDOWN_ALL_CONFIRM") + (bl ? " " + ASEUtils.getString("MSG_ALL_CONNECTIONS_CLOSED") : ""), null, this, 3066, arrayList);
            object2.setHelpButton(false);
            if (!((ASEDialogController)((Object)object)).start(this) || serverBO == null) continue;
            for (int i = 0; i < vector.size(); ++i) {
                ServerBO serverBO2 = (ServerBO)vector.get(i);
                ServerSO serverSO = (ServerSO)serverBO2.getSO();
                try {
                    if (serverSO.getConnection() != null) {
                        serverSO.shutdownNoWait();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ASConnection.removeShutdownServer(serverSO.getName());
                Support.getProvider().removeServerConnections(serverSO);
            }
            serverBO.handleUAOperation(jFrame, 3078, vector2);
        }
    }

    @Override
    public boolean confirmExecution(ArrayList arrayList, int n) {
        if (n == 106) {
            return this.deleteObjects(arrayList);
        }
        return true;
    }

    private void handleAllConnections(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        while (enumeration.hasMoreElements()) {
            ServerGroupBO serverGroupBO = (ServerGroupBO)enumeration.nextElement();
            Enumeration enumeration2 = serverGroupBO.getItems();
            Vector<ServerBO> vector = new Vector<ServerBO>();
            ServerBO serverBO = null;
            while (enumeration2.hasMoreElements()) {
                boolean bl;
                Object e = enumeration2.nextElement();
                if (!(e instanceof ServerBO)) continue;
                serverBO = (ServerBO)e;
                ServerSO serverSO = (ServerSO)serverBO.getSO();
                boolean bl2 = serverSO.getConnection() != null;
                boolean bl3 = bl = serverSO.isUAFMonitored() && !serverSO.isRunning();
                if ((n != 3063 || !bl2) && (n != 3062 || bl2 || bl)) continue;
                vector.add(serverBO);
            }
            if (serverBO == null) continue;
            if (n == 3063) {
                serverBO.onCommand(jFrame, 3001, vector.elements(), n2);
                continue;
            }
            if (n != 3062) continue;
            serverBO.onCommand(jFrame, 3074, vector.elements(), n2);
        }
    }

    @Override
    public boolean includeCreate() {
        return true;
    }

    @Override
    public boolean enableCreate() {
        return true;
    }

    @Override
    public boolean includeDelete() {
        return !this.getSO().getName().equals(ServerGroupSO.DEFAULT_SERVER_GROUP);
    }

    @Override
    public String getDisabledDeleteHint() {
        return ASEUtils.getString("CONTEXT_MENU_DELETE_MORE_SG_HINT");
    }

    @Override
    public boolean enableDelete() {
        TopBO topBO = (TopBO)this.getParent();
        return !topBO.hasConnections((ServerGroupSO)this.getSO());
    }

    @Override
    public int getAttributes() {
        return 5;
    }

    private void unRegisterServer(ServerBO serverBO) {
        TopBO topBO = (TopBO)this.getParent();
        topBO.unRegisterServer((ServerSO)serverBO.getSO(), (ServerGroupSO)this.getSO());
    }

    @Override
    public boolean deleteObjects(ArrayList arrayList) {
        Support.getViewerSupport().startWait();
        for (ServerGroupBO serverGroupBO : arrayList) {
            ServerGroupSO serverGroupSO = (ServerGroupSO)serverGroupBO.getSO();
            Enumeration enumeration = serverGroupBO.getItems();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof ServerBO)) continue;
                ServerBO serverBO = (ServerBO)e;
                serverGroupBO.unRegisterServer(serverBO);
            }
            serverGroupSO.remove();
        }
        Support.getViewerSupport().endWait();
        return true;
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        return new ServerGroupProperties((ServerGroupSO)this.getSO(), (SCContainer2)this.getParent());
    }

    @Override
    public String[] getPastableClassNames() {
        return PASTABLE_CLASS_NAMES;
    }

    @Override
    boolean pasteItem(JFrame jFrame, Object object, int n) {
        if (object instanceof ServerBO) {
            ServerBO serverBO = (ServerBO)object;
            ServerSO serverSO = (ServerSO)serverBO.getSO();
            if (serverSO.getConnection() != null) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_CANNOT_MOVE_CONNECTED_SERVER"), serverSO.getDisplayName());
                String string = aSEMessageText.toString();
                Support.showInfo(null, this.getClass(), string);
                return false;
            }
            String string = serverSO.getUserName();
            ServerGroupSO serverGroupSO = (ServerGroupSO)this.getSO();
            if (string == null || string.length() == 0) {
                boolean bl;
                ASEConnectionInfo aSEConnectionInfo = serverSO.getConnectionInfo();
                ASConnection aSConnection = Support.getProvider().connect(jFrame, serverGroupSO, aSEConnectionInfo);
                boolean bl2 = bl = aSConnection != null;
                if (bl) {
                    Support.getProvider().handleRefreshConnect(serverGroupSO.getName(), aSConnection);
                }
                return bl;
            }
            Object object2 = Support.getTopBO().getServersIterator();
            while (object2.hasNext()) {
                ServerSO serverSO2 = (ServerSO)object2.next();
                if (!serverSO2.getServerGroup().equals(serverGroupSO) || !serverSO2.getName().equals(serverSO.getName()) || !serverSO2.getUserName().equals(serverSO.getUserName())) continue;
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_SERVER_ALREADY_EXISTS_GROUP"), serverSO2.getDisplayName(), serverGroupSO.getName());
                String string2 = aSEMessageText.toString();
                Support.showInfo(null, this.getClass(), string2);
                return false;
            }
            if (n == 104) {
                Support.getTopBO().unRegisterServer(serverSO, serverSO.getServerGroup());
                serverSO.moveToServerGroup(serverGroupSO);
                Support.getTopBO().registerServer(serverSO);
            } else {
                object2 = (ServerSO)serverSO.duplicate();
                ((ServerSO)object2).copyToServerGroup(serverGroupSO);
                Support.getTopBO().registerServer((ServerSO)object2);
            }
            Support.getTopBO().refreshLater();
            return true;
        }
        return CopyObjectDialog.showDialog((Container)jFrame, object, (ServerGroupSO)this.getSO(), ((ASEBaseItem2)object).generateDDLString(((ASEBaseItem2)object).getSO()));
    }

    @Override
    public int queryDropItems(int n, DataFlavor[] dataFlavorArray) {
        boolean bl = this.arePastable(dataFlavorArray, PASTABLE_CLASS_NAMES);
        boolean bl2 = this.arePastable(dataFlavorArray, new String[]{ServerBO.class.getName()});
        if (bl2) {
            return 2;
        }
        if (bl) {
            return 1;
        }
        return 0;
    }
}

