/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.go.ASEServerNameEditor;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.DirectoryService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ServerNameEditor
implements ActionListener {
    private ASEServerNameEditor _editor;
    private ASConnection _conn;
    private boolean _isLocal;
    private boolean _hasServerSideNames;

    public ServerNameEditor(ASEServerNameEditor aSEServerNameEditor) {
        this._init(aSEServerNameEditor, null);
    }

    public ServerNameEditor(ASEServerNameEditor aSEServerNameEditor, ASConnection aSConnection) {
        this._init(aSEServerNameEditor, aSConnection);
    }

    private void _init(ASEServerNameEditor aSEServerNameEditor, ASConnection aSConnection) {
        this._editor = aSEServerNameEditor;
        this._conn = aSConnection;
        this._isLocal = aSConnection != null ? aSConnection.isLocal() : true;
        this._hasServerSideNames = false;
        this._editor.noteMultiLineLabel.setVisible(false);
    }

    public void handleTextValueChanged(DocumentEvent documentEvent) {
        if (this._editor.getServerNameTextField().getDocument() == documentEvent.getDocument() && (this._isLocal || !this._isLocal && this._hasServerSideNames)) {
            String string = this._editor.getServerName();
            boolean bl = this._editor.serverNameComboBox.findItem(string) < 0;
            this._editor.noteMultiLineLabel.setVisible(bl);
        }
    }

    private void removeListeners(DocumentListener documentListener) {
        this._editor.removeDocumentListener(documentListener);
        this._editor.serverNameComboBox.removeActionListener((ActionListener)this);
    }

    private void addListeners(DocumentListener documentListener) {
        this._editor.addDocumentListener(documentListener);
        this._editor.serverNameComboBox.addActionListener((ActionListener)this);
    }

    public void init(DocumentListener documentListener) throws Exception {
        String[] stringArray = new String[]{};
        this.removeListeners(documentListener);
        this._editor.serverNameComboBox.removeAllItems();
        if (this._isLocal) {
            DirectoryService.initServerEntries();
            stringArray = DirectoryService.getAllASEServerNames();
            this._editor.noteMultiLineLabel.setText(ASEUtils.getString("SERVER_LIST_NOTE_SERVER_SERVER_NAME"));
        } else {
            boolean bl;
            ServerBO serverBO = ContainerViewBO.getServerBO(this._conn);
            ServerSO serverSO = (ServerSO)serverBO.getSO();
            if (serverSO != null && ServerBO.getEnableUAF(serverSO)) {
                try {
                    stringArray = serverSO.getServerServerNames();
                    this._hasServerSideNames = true;
                    this._editor.noteMultiLineLabel.setText(ASEUtils.getString("SERVER_LIST_NOTE_SERVER_SERVER_NAME"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this._hasServerSideNames && (bl = DirectoryService.initServerEntries())) {
                stringArray = DirectoryService.getAllASEServerNames();
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this._editor.serverNameComboBox.addItem((Object)stringArray[i]);
        }
        this.setServerName("");
        this.addListeners(documentListener);
    }

    public final void setServerName(String string) {
        this._editor.setServerName(string);
    }

    public final String getServerName() {
        return this._editor.getServerName();
    }

    public final void clearServerNames() {
        this._editor.serverNameComboBox.removeAllItems();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this._editor.noteMultiLineLabel.setVisible(!this._isLocal && !this._hasServerSideNames);
    }

    public void deselect() {
        this._editor.serverNameComboBox.setSelectedIndex(-1);
    }

    public boolean hasServerSideNames() {
        return this._hasServerSideNames;
    }

    public void releaseResources(DocumentListener documentListener) {
        this.removeListeners(documentListener);
        this._conn = null;
    }
}

