/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.RLImages;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ConnectionBO;
import com.sybase.aseplugin.bo.RepArticleBO;
import com.sybase.aseplugin.bo.ReplicationBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.SubscriptionProp;
import com.sybase.aseplugin.bo.wiz.RepArticleWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.RepArticleSO;
import com.sybase.aseplugin.so.SubscriptionSO;
import com.sybase.aseplugin.util.Debug;
import com.sybase.aseplugin.util.RLStatusMonitor;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.awt.Container;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class SubscriptionBO
extends ASEBaseContainer2 {
    static final int SUB_NAME = 0;
    static final int SUB_REASON = 1;
    private static final int CMD_RESUME = 3001;
    private static final int CMD_SUSPEND = 3002;
    private static final int NEW_REP_ARTICLE = 3003;
    public static final ImageIcon SUBSCRIPTION_UP_ICON = new ImageIcon(RLImages.getSubscriptionUpSmallImage());
    public static final ImageIcon SUBSCRIPTION_DOWN_ICON = new ImageIcon(RLImages.getSubscriptionDownSmallImage());
    public static final ImageIcon NEW_SUBSCRIPTION_ICON = new ImageIcon(RLImages.getNewSubscriptionImage());

    SubscriptionBO(ConnectionBO connectionBO, SubscriptionSO subscriptionSO) {
        super(subscriptionSO.getLongName(), (ASEBaseContainer2)connectionBO, subscriptionSO);
        ConnectionBO connectionBO2 = (ConnectionBO)this.getParent();
        ReplicationBO replicationBO = (ReplicationBO)connectionBO2.getParent();
        RLStatusMonitor rLStatusMonitor = replicationBO.getRLStatusMonitor();
        if (rLStatusMonitor != null) {
            rLStatusMonitor.register(this);
        }
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 96;
    }

    public String getDDB() {
        return ((SubscriptionSO)this.getSO()).getDDB();
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3003, ASEUtils.getString("MSG_ADD_REP_ARTICLE"), ASEUtils.getString("MSG_ADD_REP_ARTICLE"), Support.getMnemonic("CREA_MNEM"), RepArticleBO.REPLICATE_ARTICLE_TABLE_ICON);
        return new ASEMenuItem[]{aSEMenuItem};
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3003, RepArticleBO.NEW_REPLICATE_ARTICLE_ICON, ASEUtils.getString("MSG_ADD_REP_ARTICLE"), ASEUtils.getString("MSG_ADD_REP_ARTICLE"));
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public Vector getItems(int n) throws SQLException {
        Debug.trace(this, "Open() in SubBO - thread: " + Thread.currentThread().getName());
        RepArticleSO repArticleSO = new RepArticleSO(this.getConnection(), this.getDDB());
        Vector<RepArticleBO> vector = new Vector<RepArticleBO>();
        Enumeration enumeration = RepArticleSO.getReplicateArticles(this.getConnection(), this.getDDB(), this.getSO().getDisplayName(), ((ConnectionBO)this.getParent()).getSO());
        while (enumeration.hasMoreElements()) {
            vector.addElement(new RepArticleBO(this, (RepArticleSO)enumeration.nextElement()));
        }
        return vector;
    }

    @Override
    public Icon getImage(boolean bl) {
        ImageIcon imageIcon = null;
        switch (((SubscriptionSO)this.getSO()).getState()) {
            case 1: {
                imageIcon = SUBSCRIPTION_UP_ICON;
                break;
            }
            case -1: 
            case 0: 
            case 3: {
                imageIcon = SUBSCRIPTION_DOWN_ICON;
                break;
            }
            default: {
                Debug.wassert(false, this, "Invalid Subscription State");
            }
        }
        return imageIcon;
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getSO().getDisplayName();
            }
            case 1: {
                return ((SubscriptionSO)this.getSO()).getReasonCode();
            }
        }
        return "";
    }

    @Override
    public SCMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ASEMenu();
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3001, ASEUtils.getString("CONTEXT_MENU_RESUME_TEXT"), ASEUtils.getString("CONTEXT_MENU_RESUME_HINT"), Support.getMnemonic("ACTN_MNEM_RESUME")));
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3002, ASEUtils.getString("CONTEXT_MENU_SUSPEND_TEXT"), ASEUtils.getString("CONTEXT_MENU_SUSPEND_HINT"), Support.getMnemonic("ACTN_MNEM_SUSPEND")));
            this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        }
        return this._contextMenu;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return super.isOkToBatch(n) || n == 3001 || n == 3002;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 107: {
                SubscriptionProp subscriptionProp = new SubscriptionProp((SubscriptionSO)this.getSO(), (SCContainer2)this.getParent());
                ASEBaseDialog2.showDialog(jFrame, subscriptionProp);
                break;
            }
            case 106: {
                int n3 = Support.showQuestionYesNo(jFrame, ASEUtils.getString("MSG_DELETE_OBJECT_QUESTION"));
                if (n3 != 0) break;
                Support.getViewerSupport().startWait();
                while (enumeration.hasMoreElements()) {
                    try {
                        SubscriptionBO subscriptionBO = (SubscriptionBO)enumeration.nextElement();
                        subscriptionBO.getSO().remove();
                    }
                    catch (SQLException sQLException) {
                        Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                    }
                }
                Support.getViewerSupport().endWait();
                ((ConnectionBO)this.getParent()).refresh();
                break;
            }
            case 3001: {
                int n4;
                Object object;
                Vector<String> vector = new Vector<String>();
                while (enumeration.hasMoreElements()) {
                    object = (SubscriptionBO)enumeration.nextElement();
                    vector.add(((SubscriptionSO)((ASEBaseItem2)object).getSO()).resume());
                }
                if (vector.size() <= 0 || (n4 = Support.showQuestionYesNo(jFrame, (String)(object = ASEUtils.getString("MSG_RESUME_SUB_CONFIRM")))) != 0) break;
                Support.getViewerSupport().startWait();
                try {
                    this.execute(vector);
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                }
                ((ConnectionBO)this.getParent()).refresh();
                Support.getViewerSupport().endWait();
                break;
            }
            case 3002: {
                int n5;
                Object object;
                Vector<String> vector = new Vector<String>();
                while (enumeration.hasMoreElements()) {
                    object = (SubscriptionBO)enumeration.nextElement();
                    vector.add(((SubscriptionSO)((ASEBaseItem2)object).getSO()).suspend());
                }
                if (vector.size() <= 0 || (n5 = Support.showQuestionYesNo(jFrame, (String)(object = ASEUtils.getString("MSG_SUSPEND_SUB_CONFIRM")))) != 0) break;
                Support.getViewerSupport().startWait();
                try {
                    this.execute(vector);
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                }
                ((ConnectionBO)this.getParent()).refresh();
                Support.getViewerSupport().endWait();
                break;
            }
            case 3003: {
                RepArticleSO repArticleSO = new RepArticleSO(this.getConnection(), this.getDDB());
                RepArticleWizard repArticleWizard = new RepArticleWizard(repArticleSO, (SCContainer2)this.getParent(), this);
                RepArticleWizard.showDialog((Container)jFrame, repArticleWizard);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Vector vector) throws SQLException {
        SQLException sQLException = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                this.getConnection().executeCommand(string);
            }
            catch (SQLException sQLException2) {
                if (sQLException == null) {
                    sQLException = sQLException2;
                    continue;
                }
                sQLException.setNextException(sQLException2);
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        return new ASEBaseHeader[]{new ASEBaseHeader(ASEUtils.getString("DISP_ARTICLE_HDR"), 0, 170), new ASEBaseHeader(ASEUtils.getString("DISP_STATE_HDR"), 1, 170), new ASEBaseHeader(ASEUtils.getString("DISP_TYPE_HDR"), 2, 170), new ASEBaseHeader(ASEUtils.getString("DISP_OWNER_HDR"), 3, 170)};
    }
}

