/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.DDLWriter;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLGenerator;
import javax.swing.JOptionPane;

public class SybDDLGenerator {
    public static final String CHARSET = "-J";
    public static final String DB_NAME = "-D";
    public static final String DDL_VERSION = "-V";
    public static final String FILTER = "-F";
    public static final String HOST_NAME = "-S";
    public static final String INTERFACE_FILE_LOCATION = "-I";
    public static final String OBJECT_NAME = "-N";
    public static final String OBJECT_TYPE = "-T";
    public static final String OUTPUT_FILE_NAME = "-O";
    public static final String PASSWORD = "-P";
    public static final String SHOW_COMMENTS = "-C";
    public static final String SHOW_ERRORS = "-E";
    public static final String SSL = "ssl";
    public static final String USER_NAME = "-U";
    public static final String ENCRYPTED_PASSWORD = "-C";
    public static final String CONN_PROP_ENCRYPTED_PASSWORD = "ENCRYPT_PASSWORD=";
    private static DDLGenerator _generator = null;
    private static boolean _bStoreInAFile = false;
    private static String title;

    private SybDDLGenerator() {
    }

    public static synchronized void setStoreToFile(boolean bl) {
        _bStoreInAFile = bl;
    }

    public static synchronized String generateDDLString(ASConnection aSConnection, String[] stringArray) {
        String string = "";
        try {
            int n = stringArray.length;
            String[] stringArray2 = new String[n + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray2[n] = ASConnection.isEncryptedPassword(aSConnection.getConnectionInfo()) ? "-CENCRYPT_PASSWORD=true" : "-CENCRYPT_PASSWORD=false";
            SybDDLGenerator.setParameters(stringArray2);
            string = _generator.generateDDL();
        }
        catch (DDLBaseException dDLBaseException) {
            Support.showDetailsError(aSConnection, SybDDLGenerator.class, dDLBaseException.getError(), dDLBaseException);
        }
        return string;
    }

    public static synchronized void generateDDL(String[] stringArray, ASConnection aSConnection) {
        try {
            int n = stringArray.length;
            String[] stringArray2 = new String[n + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray2[n] = ASConnection.isEncryptedPassword(aSConnection.getConnectionInfo()) ? "-CENCRYPT_PASSWORD=true" : "-CENCRYPT_PASSWORD=false";
            SybDDLGenerator.setParameters(stringArray2);
            if (!_bStoreInAFile) {
                SybDDLGenerator.writeToEditor(_generator.generateDDL(), aSConnection);
            } else {
                String string = stringArray2[5].substring(OUTPUT_FILE_NAME.length());
                String string2 = stringArray2[4].substring(OBJECT_NAME.length());
                _generator.generateDDL();
                title = ASEUtils.getString("MSG_DDL_GENERATOR_TITLE");
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("DATABASE_DDL_SAVE_COMPLETE_INFO"), string2, string);
                JOptionPane.showMessageDialog(null, aSEMessageText, title, 1);
                _bStoreInAFile = false;
            }
        }
        catch (DDLBaseException dDLBaseException) {
            Support.showDetailsError(aSConnection, new SybDDLGenerator().getClass(), dDLBaseException.getError(), dDLBaseException);
        }
    }

    private static void writeToEditor(String string, ASConnection aSConnection) {
        DDLWriter.writeToEditor(string, aSConnection);
    }

    private static void setParameters(String[] stringArray) throws DDLBaseException {
        if (_generator == null) {
            _generator = new DDLGenerator(stringArray);
        } else {
            _generator.setParams(stringArray);
        }
    }
}

