/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.CheckConstraintBO;
import com.sybase.aseplugin.bo.CheckConstraintsCtrBO;
import com.sybase.aseplugin.bo.ColumnBO;
import com.sybase.aseplugin.bo.ColumnStatsCtrBO;
import com.sybase.aseplugin.bo.ColumnsCtrBO;
import com.sybase.aseplugin.bo.ForeignKeyBO;
import com.sybase.aseplugin.bo.ForeignKeysCtrBO;
import com.sybase.aseplugin.bo.IndexBO;
import com.sybase.aseplugin.bo.IndexesCtrBO;
import com.sybase.aseplugin.bo.PartitionsCtrBO;
import com.sybase.aseplugin.bo.ResultSetDetailsPanel;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.SybDDLGenerator;
import com.sybase.aseplugin.bo.TablesCtrBO;
import com.sybase.aseplugin.bo.TriggerBO;
import com.sybase.aseplugin.bo.TriggersCtrBO;
import com.sybase.aseplugin.bo.UniqueConstraintBO;
import com.sybase.aseplugin.bo.dlg.DDLObjectFilterDialog;
import com.sybase.aseplugin.bo.dlg.ItemsConfirmDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.TableProperties;
import com.sybase.aseplugin.bo.wiz.BCPWizard;
import com.sybase.aseplugin.bo.wiz.DBCCWizard;
import com.sybase.aseplugin.bo.wiz.IncrementalTransferInWizard;
import com.sybase.aseplugin.bo.wiz.IncrementalTransferOutWizard;
import com.sybase.aseplugin.bo.wiz.RestoreDataWizard;
import com.sybase.aseplugin.bo.wiz.UpdateStatWizard;
import com.sybase.aseplugin.so.ASEBaseDBItemSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.SOOwnedItemInterface;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.table.TableEditor;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.central.SCViewerDetailsPanel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import sybase.isql.ISQLImages;

public class TableBO
extends ASEBaseContainer2 {
    public static final ImageIcon TABLE_ICON = new ImageIcon(ASEImages.getTableSmallImage());
    public static final ImageIcon NEW_TABLE_ICON = new ImageIcon(ASEImages.getNewTableImage());
    public static final ImageIcon PROXY_TABLE_ICON = new ImageIcon(ASEImages.getProxyTableSmallImage());
    public static final ImageIcon NEW_PROXY_TABLE_ICON = new ImageIcon(ASEImages.getNewProxyTableImage());
    public static final ImageIcon SYSTEM_TABLE_ICON = new ImageIcon(ASEImages.getSystemTableSmallImage());
    public static final int CMD_NEW_CHECK_CONSTRAINT = 3061;
    public static final int CMD_NEW_COLUMN = 3062;
    public static final int CMD_NEW_FOREIGN_KEY = 3063;
    public static final int CMD_NEW_INDEX = 3064;
    public static final int CMD_NEW_TRIGGER = 3065;
    public static final int CMD_NEW_UNIQUE_CONSTRAINT = 3066;
    private static final int CMD_GENERATE_CREATE_DDL = 3067;
    private static final int CMD_GENERATE_OBJECTS_DDL = 3068;
    protected static final int CMD_CHECK_CONSISTENCY = 3069;
    public static final int CMD_NEW_PARTITION = 3070;
    public static final int CMD_UPDATE_STATS = 3080;
    public static final int CMD_DELETE_STATS = 3081;
    public static final int CMD_DISPLAY_STATS = 3082;
    public static final int CMD_OPEN_DBISQL = 3083;
    public static final int CMD_SUPPLY_PASSWORD = 3084;
    private static final int CMD_RESTORE_DATA = 3085;
    private static final int CMD_BCP_IN = 3086;
    private static final int CMD_BCP_OUT = 3087;
    private static final int CMD_INCREMENTAL_TRANSFER_IN = 3088;
    private static final int CMD_INCREMENTAL_TRANSFER_OUT = 3089;
    private CheckConstraintsCtrBO _checkConstraintsCtrBO;
    private ColumnsCtrBO _columnsCtrBO;
    private ForeignKeysCtrBO _foreignKeysCtrBO;
    private IndexesCtrBO _indexesCtrBO;
    private TriggersCtrBO _triggersCtrBO;
    private PartitionsCtrBO _partitionsCtrBO;

    public static ImageIcon getIcon(TableSO tableSO) {
        if (tableSO.isProxyTable()) {
            return PROXY_TABLE_ICON;
        }
        if (tableSO.isSystemTable()) {
            return SYSTEM_TABLE_ICON;
        }
        return TABLE_ICON;
    }

    public TableBO(TablesCtrBO tablesCtrBO, TableSO tableSO) {
        super(tablesCtrBO, (SOItemInterface)tableSO, (Icon)TableBO.getIcon(tableSO));
        this._init();
    }

    public TableBO(TablesCtrBO tablesCtrBO, TableSO tableSO, ImageIcon imageIcon) {
        super(tablesCtrBO, (SOItemInterface)tableSO, (Icon)imageIcon);
        this._init();
    }

    private void _init() {
        this._columnsCtrBO = new ColumnsCtrBO(this);
        this._indexesCtrBO = new IndexesCtrBO(this);
        this._checkConstraintsCtrBO = new CheckConstraintsCtrBO(this);
        this._triggersCtrBO = new TriggersCtrBO(this);
        this._foreignKeysCtrBO = new ForeignKeysCtrBO(this);
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        return new ASEBaseHeader[]{new ASEBaseHeader(ASEUtils.getString("DISP_FOLDERS_TEXT"), 0, 200)};
    }

    @Override
    public Object[] getDetailsPanels() {
        return new Object[]{SCViewerDetailsPanel.getViewerDetailsPanel((String)"DETAILS_LIST"), new ResultSetDetailsPanel((TableSO)this.getSO())};
    }

    private boolean isUserTable() {
        return !((TableSO)this.getSO()).isSystemTable();
    }

    @Override
    public Vector getItems(int n) {
        Vector<ASEBaseContainer2> vector = new Vector<ASEBaseContainer2>();
        vector.addElement(this._columnsCtrBO);
        vector.addElement(this._indexesCtrBO);
        vector.addElement(this._triggersCtrBO);
        vector.addElement(this._foreignKeysCtrBO);
        vector.addElement(this._checkConstraintsCtrBO);
        if (((TableSO)this.getSO()).getConnection().isPartitionsApplicable()) {
            this._partitionsCtrBO = new PartitionsCtrBO(this);
            this._partitionsCtrBO.setType(1);
            vector.addElement(this._partitionsCtrBO);
        }
        return vector;
    }

    @Override
    public String getDisplayName(int n) {
        return n == 0 ? ((SOOwnedItemInterface)this.getSO()).getNameWithOwner() : super.getDisplayName(n);
    }

    @Override
    public int getAttributes() {
        return -5;
    }

    @Override
    public SCMenu getContextMenu() {
        Object object;
        Object object2;
        this._contextMenu = new ASEMenu();
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3083, ASEUtils.getString("CONTEXT_MENU_VIEW_DATA_DBISQL_TEXT"), ASEUtils.getString("CONTEXT_MENU_VIEW_DATA_DBISQL_HINT"), '\u0000', ISQLImages.getImageIcon((String)"isql16")));
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        ASEMenu aSEMenu = new ASEMenu(ASEUtils.getString("DATA_TRANSFER"));
        aSEMenu.setMnemonic(Support.getMnemonic("DATA_TRANSFER_MNEM"));
        ASEMenu aSEMenu2 = new ASEMenu(ASEUtils.getString("CONTEXT_MENU_BCP_TEXT"));
        aSEMenu2.setMnemonic(Support.getMnemonic("BCP_MNEM"));
        aSEMenu2.addItem((SCMenuItem)new ASEMenuItem(3086, ASEUtils.getString("CONTEXT_MENU_BCP_IN_TEXT"), new ASEMessageText(ASEUtils.getString("CONTEXT_MENU_BCP_INOUT_HINT"), ASEUtils.getString("CONTEXT_MENU_BCP_IN_TEXT")).toString(), Support.getMnemonic("CONTEXT_MENU_BCP_IN_MNEM")));
        aSEMenu2.addItem((SCMenuItem)new ASEMenuItem(3087, ASEUtils.getString("CONTEXT_MENU_BCP_OUT_TEXT"), new ASEMessageText(ASEUtils.getString("CONTEXT_MENU_BCP_INOUT_HINT"), ASEUtils.getString("CONTEXT_MENU_BCP_OUT_TEXT")).toString(), Support.getMnemonic("CONTEXT_MENU_BCP_OUT_MNEM")));
        aSEMenu.addItem((SCMenuItem)aSEMenu2);
        if (this.getConnection().hasIncrementalTransferFeature()) {
            object2 = new ASEMenu(ASEUtils.getString("INCREMENTAL"));
            ((ASEMenuItem)object2).setMnemonic(Support.getMnemonic("INCREMENTAL_TRANSFER_MNEM"));
            object = new ASEMenuItem(3088, ASEUtils.getString("CONTEXT_MENU_INCREMENTAL_TRANSFER_IN_TEXT"), ASEUtils.getString("CONTEXT_MENU_INCREMENTAL_TRANSFER_IN_HINT"), Support.getMnemonic("CONTEXT_MENU_INCREMENTAL_TRANSFER_IN_MNEM"));
            ((ASEMenu)object2).addItem((SCMenuItem)object);
            ASEMenuItem aSEMenuItem = new ASEMenuItem(3089, ASEUtils.getString("CONTEXT_MENU_INCREMENTAL_TRANSFER_OUT_TEXT"), ASEUtils.getString("CONTEXT_MENU_INCREMENTAL_TRANSFER_OUT_HINT"), Support.getMnemonic("CONTEXT_MENU_INCREMENTAL_TRANSFER_OUT_MNEM"));
            ((ASEMenu)object2).addItem((SCMenuItem)aSEMenuItem);
            aSEMenu.addItem((SCMenuItem)object2);
        }
        this._contextMenu.addItem((SCMenuItem)aSEMenu);
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        object2 = (TableSO)this.getSO();
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3069, ASEUtils.getString("CONTEXT_MENU_CHECK_CONSISTENCY_TEXT"), ASEUtils.getString("CONTEXT_MENU_CHECK_CONSISTENCY_HINT"), Support.getMnemonic("CC_DATABASE_MNEM")));
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        this._contextMenu.addItem((SCMenuItem)TableBO.getStatisticsMenu(3082));
        if (this.includeDelete()) {
            Object object3 = object = this.enableDelete() ? null : this.getDisabledDeleteHint();
            if (!((TableSO)object2).isProxyTable()) {
                this._contextMenu.addItem((SCMenuItem)TableBO.getStatisticsMenu(3080, (String)object));
            }
            this._contextMenu.addItem((SCMenuItem)TableBO.getStatisticsMenu(3081, (String)object));
        }
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        object = new ASEMenu(ASEUtils.getString("CONTEXT_MENU_GENERATE_DDL_TEXT"));
        ((ASEMenuItem)object).setMnemonic(Support.getMnemonic("GENERATE_DDL_MNEM"));
        ((ASEMenu)object).addItem((SCMenuItem)new ASEMenuItem(3067, ASEUtils.getString("CONTEXT_MENU_TABLE_CREATE_DDL_TEXT"), ASEUtils.getString("CONTEXT_MENU_TABLE_CREATE_DDL_HINT"), Support.getMnemonic("CONTEXT_MENU_DATABASE_CREATE_DDL_MNEM")));
        ((ASEMenu)object).addItem((SCMenuItem)new ASEMenuItem(3068, ASEUtils.getString("CONTEXT_MENU_TABLE_OBJECTS_DDL_TEXT"), ASEUtils.getString("CONTEXT_MENU_TABLE_OBJECTS_DDL_HINT"), Support.getMnemonic("CONTEXT_MENU_DATABASE_OBJECTS_DDL_MNEM")));
        this._contextMenu.addItem((SCMenuItem)object);
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        if (((TableSO)object2).includeRestore()) {
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem(3085, ASEUtils.getString("CONTEXT_MENU_RESTORE_DATA_TEXT"), ASEUtils.getString("CONTEXT_MENU_RESTORE_DATA_HINT"), Support.getMnemonic("RESTORE_DATA_MNEM")));
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        }
        int n = 3030;
        String string = ASEUtils.getString("CONTEXT_MENU_EDIT_TEXT");
        String string2 = ASEUtils.getString("CONTEXT_MENU_EDIT_HINT");
        boolean bl = ((ASEBaseDBItemSO)object2).getDatabaseSO().getOption("DB_OP_READ_ONLY");
        string2 = string2 + (bl ? this.getDisabledDeleteHint() : "");
        ASEMenuItem aSEMenuItem = new ASEMenuItem(n, string, string2, Support.getMnemonic("EDIT_MNEM"));
        aSEMenuItem.setEnabled(!bl);
        if (((TableSO)object2).isProxyTable()) {
            if (((TableSO)object2).getRemoteObjectType().equals("table") || ((TableSO)object2).getRemoteObjectType().equals("view")) {
                this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
            }
        } else {
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        }
        if (this.includeDelete()) {
            this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
        }
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        return this._contextMenu;
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        String string = ASEUtils.getString("MSG_CHECK_CONSTRAINT_NAME");
        String string2 = ASEUtils.getString("CREATION_HINT_NEW_CHECK_CONSTRAINT");
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3061, string, string2, '\u0000', CheckConstraintBO.CHECK_CONSTRAINT_ICON);
        string = ASEUtils.getString("MSG_COLUMN_TYPE");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_COLUMN");
        ASEMenuItem aSEMenuItem2 = new ASEMenuItem(3062, string, string2, '\u0000', ColumnBO.ICON_COLUMN);
        string = ASEUtils.getString("MSG_FKEY_TYPE");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_FOREIGN_KEY");
        ASEMenuItem aSEMenuItem3 = new ASEMenuItem(3063, string, string2, '\u0000', ForeignKeyBO.FOREIGN_KEY_ICON);
        string = ASEUtils.getString("MSG_INDEX_TYPE");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_INDEX");
        ASEMenuItem aSEMenuItem4 = new ASEMenuItem(3064, string, string2, '\u0000', IndexBO.INDEX_ICON);
        string = ASEUtils.getString("MSG_TRIGGER_TYPE");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_TRIGGER");
        ASEMenuItem aSEMenuItem5 = new ASEMenuItem(3065, string, string2, '\u0000', TriggerBO.TRIGGER_ICON);
        string = ASEUtils.getString("MSG_UNI_CONSTRAINT");
        string2 = ASEUtils.getString("CREATION_HINT_NEW_UNIQUE_CONSTRAINT");
        ASEMenuItem aSEMenuItem6 = new ASEMenuItem(3066, string, string2, '\u0000', UniqueConstraintBO.ICON_UNIQUE_KEY);
        return new ASEMenuItem[]{aSEMenuItem, aSEMenuItem2, aSEMenuItem3, aSEMenuItem4, aSEMenuItem5, aSEMenuItem6};
    }

    @Override
    public String getDisabledCreateHint() {
        return ASEUtils.getString("CONTEXT_MENU_DELETE_MORE_DB_HINT");
    }

    @Override
    public boolean isOkToBatch(int n) {
        return super.isOkToBatch(n) || n == 3068 || n == 3069 || n == 3081 || n == 3082 || n == 3080 || n == 3086 || n == 3087;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        TableSO tableSO = (TableSO)this.getSO();
        switch (n) {
            case 3083: {
                String string = "select * from ";
                String string2 = tableSO.getOwner();
                string = string2 != null && string2.equals(this.getCurrentUser()) ? string + tableSO.getName() : string + string2 + "." + tableSO.getName();
                Support.getProvider().openDBISQL(jFrame, this.getConnection(), tableSO.getDatabaseName(), string, true);
                return;
            }
            case 106: {
                ArrayList arrayList = Support.enumToArrayList(enumeration);
                ItemsConfirmDialog itemsConfirmDialog = new ItemsConfirmDialog(Support.createDialogSupport(jFrame), ASEUtils.getString("DNAME_TABLES"), this, arrayList);
                if (!itemsConfirmDialog.start(this)) return;
                ((TablesCtrBO)this.getParent()).refresh();
                return;
            }
            case 3067: {
                TableSO tableSO2 = (TableSO)this.getSO();
                SybDDLGenerator.generateDDL(this.getDDLParams(tableSO2), this.getConnection());
                return;
            }
            case 3068: {
                String[] stringArray;
                Vector<String> vector = new Vector<String>();
                ASConnection aSConnection = null;
                while (enumeration.hasMoreElements()) {
                    stringArray = (String[])enumeration.nextElement();
                    TableSO tableSO3 = (TableSO)stringArray.getSO();
                    vector.addElement(tableSO3.getDatabaseName() + "." + tableSO3.getOwner() + "." + tableSO3.getName());
                    aSConnection = tableSO3.getConnection();
                }
                stringArray = new String[vector.size()];
                int n3 = 0;
                while (true) {
                    if (n3 >= vector.size()) {
                        DDLObjectFilterDialog.render(jFrame, stringArray, 'T', aSConnection, "HELP_DATABASE_DLG_FILTER_OBJECTS_FROM_DDL_OUTPUT_1252");
                        return;
                    }
                    stringArray[n3] = (String)vector.elementAt(n3);
                    ++n3;
                }
            }
            case 3030: {
                TableEditor.showFrame(this, 2);
                return;
            }
            case 3061: {
                this._checkConstraintsCtrBO.onCommand(jFrame, n, enumeration, n2);
                return;
            }
            case 3062: {
                this._columnsCtrBO.onCommand(jFrame, 3062, enumeration, n2);
                return;
            }
            case 3063: {
                this._foreignKeysCtrBO.onCommand(jFrame, n, enumeration, n2);
                return;
            }
            case 3064: {
                this._indexesCtrBO.onCommand(jFrame, n, enumeration, n2);
                return;
            }
            case 3065: {
                this._triggersCtrBO.onCommand(jFrame, n, enumeration, n2);
                return;
            }
            case 3066: {
                this._indexesCtrBO.onCommand(jFrame, n, enumeration, n2);
                return;
            }
            case 3086: {
                if (!TableBO.isBCPVerified(this.getConnection(), this.getClass())) return;
                ArrayList arrayList = Support.enumToArrayList(enumeration);
                TableBO tableBO = (TableBO)arrayList.get(0);
                TableSO tableSO4 = (TableSO)tableBO.getSO();
                BCPWizard bCPWizard = new BCPWizard(tableSO4, arrayList, (SCContainer2)this.getParent(), true);
                ASEBaseDialog2.showDialog(jFrame, bCPWizard);
                return;
            }
            case 3087: {
                if (!TableBO.isBCPVerified(this.getConnection(), this.getClass())) return;
                ArrayList arrayList = Support.enumToArrayList(enumeration);
                TableBO tableBO = (TableBO)arrayList.get(0);
                TableSO tableSO5 = (TableSO)tableBO.getSO();
                BCPWizard bCPWizard = new BCPWizard(tableSO5, arrayList, (SCContainer2)this.getParent(), false);
                ASEBaseDialog2.showDialog(jFrame, bCPWizard);
                return;
            }
            case 3069: {
                ArrayList arrayList = Support.enumToArrayList(enumeration);
                TableBO tableBO = (TableBO)arrayList.get(0);
                TableSO tableSO6 = (TableSO)tableBO.getSO();
                DBCCWizard dBCCWizard = new DBCCWizard(tableSO6, arrayList, (SCContainer2)this.getParent());
                ASEBaseDialog2.showDialog(jFrame, dBCCWizard);
                return;
            }
            case 3085: {
                TableSO tableSO7 = (TableSO)this.getSO();
                try {
                    ASEMessageText aSEMessageText;
                    int n4;
                    int n5 = tableSO7.getNumberOfRows();
                    if (n5 > 0 && (n4 = Support.showQuestionYesNo((aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_TABLE_HAS_ROWS"), tableSO7.getName())).toString())) == 1) {
                        return;
                    }
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                    return;
                }
                try {
                    if (!tableSO7.getDatabaseSO().getOptionStatus("select into/bulkcopy/pllsort")) {
                        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_SELECT_INTO_NOT_ENABLED"), tableSO7.getDatabaseName());
                        Support.showError(this.getConnection(), this.getClass(), aSEMessageText.toString());
                        return;
                    }
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                    return;
                }
                try {
                    if (tableSO7.hasIndex()) {
                        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_TABLE_HAS_INDEX"), tableSO7.getName());
                        Support.showError(this.getConnection(), this.getClass(), aSEMessageText.toString());
                        return;
                    }
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                    return;
                }
                RestoreDataWizard restoreDataWizard = new RestoreDataWizard(tableSO7, (SCContainer2)this.getParent());
                ASEBaseDialog2.showDialog(jFrame, restoreDataWizard);
                return;
            }
            case 3080: 
            case 3081: 
            case 3082: {
                ArrayList arrayList;
                Object object;
                if (enumeration == null) return;
                if (n == 3080) {
                    this.open(1);
                    object = new ColumnStatsCtrBO(this);
                    ((ASEBaseContainer2)object).open(1);
                    ArrayList arrayList2 = Support.enumToArrayList(((ASEBaseContainer2)object).getItems());
                    arrayList = new ArrayList();
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        Object e = arrayList2.get(i);
                        if (!(e instanceof ColumnBO)) continue;
                        arrayList.add(e);
                    }
                } else {
                    arrayList = Support.enumToArrayList(enumeration);
                }
                object = new UpdateStatWizard((TableSO)this.getSO(), arrayList, this._indexesCtrBO, n, (SCContainer2)this.getParent());
                ASEBaseDialog2.showDialog(jFrame, (ASEBaseDialog2)object);
                return;
            }
            case 3089: {
                TableSO tableSO8 = (TableSO)this.getSO();
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("INCREMENTAL_TRANSFER_OUT_FOR"), tableSO8.getName());
                IncrementalTransferOutWizard incrementalTransferOutWizard = new IncrementalTransferOutWizard(tableSO8, (SCContainer2)this.getParent(), aSEMessageText.toString());
                ASEBaseDialog2.showDialog(jFrame, incrementalTransferOutWizard);
                return;
            }
            case 3088: {
                TableSO tableSO9 = (TableSO)this.getSO();
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("INCREMENTAL_TRANSFER_IN_FOR"), tableSO9.getName());
                IncrementalTransferInWizard incrementalTransferInWizard = new IncrementalTransferInWizard(tableSO9, (SCContainer2)this.getParent(), aSEMessageText.toString());
                ASEBaseDialog2.showDialog(jFrame, incrementalTransferInWizard);
                return;
            }
        }
        super.onCommand(jFrame, n, enumeration, n2);
    }

    public static boolean isBCPVerified(ASConnection aSConnection, Class clazz) {
        String string = TableSO.getBCPPath();
        if (!ASEUtils.isExistingFile(string)) {
            Support.showError(aSConnection, clazz, ASEUtils.getString("ERR_NO_BCP"));
            return false;
        }
        if (aSConnection.hasAdHocServerName()) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_NOT_VALID_SERVER_NAME_FOR_EXTERNAL_UTILITY"), aSConnection.getServerName(), TableSO.getBCPCommand());
            String string2 = aSEMessageText.toString();
            if (!ASEUtils.OS_MAC_OS_X) {
                string2 = string2 + ASEUtils.getString("MSG_DEFINE_SERVER_ENTRY");
            }
            Support.showError(aSConnection, clazz, string2);
            return false;
        }
        return true;
    }

    public String getCurrentUser() {
        String string = "";
        ASConnection aSConnection = ((TableSO)this.getSO()).getConnection();
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            aSResultSet.open("select user_name()");
            while (aSResultSet.getNextRow()) {
                string = aSResultSet.getColumnString(1);
            }
            aSResultSet.close();
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), ASEMessageText.toString(sQLException), sQLException);
        }
        return string;
    }

    public ColumnsCtrBO getColumnsCtrBO() {
        return this._columnsCtrBO;
    }

    public CheckConstraintsCtrBO getCheckConstraintsCtrBO() {
        return this._checkConstraintsCtrBO;
    }

    public TriggersCtrBO getTriggersCtrBO() {
        return this._triggersCtrBO;
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        return new TableProperties((TableSO)this.getSO(), (TablesCtrBO)this.getParent());
    }

    public static ASEMenuItem getStatisticsMenu(int n) {
        return TableBO.getStatisticsMenu(n, null);
    }

    public static ASEMenuItem getStatisticsMenu(int n, String string) {
        boolean bl;
        boolean bl2 = bl = string != null && string.length() > 0;
        if (n == 3080) {
            String string2 = ASEUtils.getString("CONTEXT_MENU_UPDATE_STATISTICS_TEXT");
            String string3 = ASEUtils.getString("CONTEXT_MENU_UPDATE_STATISTICS_HINT");
            string3 = string3 + (bl ? string : "");
            ASEMenuItem aSEMenuItem = new ASEMenuItem(n, string2, string3, Support.getMnemonic("CONTEXT_MENU_UPDATE_STATISTICS_MNEM"));
            if (bl) {
                aSEMenuItem.setEnabled(false);
            }
            return aSEMenuItem;
        }
        if (n == 3081) {
            String string4 = ASEUtils.getString("CONTEXT_MENU_DELETE_STATISTICS_TEXT");
            String string5 = ASEUtils.getString("CONTEXT_MENU_DELETE_STATISTICS_HINT");
            string5 = string5 + (bl ? string : "");
            ASEMenuItem aSEMenuItem = new ASEMenuItem(n, string4, string5, Support.getMnemonic("CONTEXT_MENU_DELETE_STATISTICS_MNEM"));
            if (bl) {
                aSEMenuItem.setEnabled(false);
            }
            return aSEMenuItem;
        }
        if (n == 3082) {
            String string6 = ASEUtils.getString("CONTEXT_MENU_DISPLAY_STATISTICS_TEXT");
            String string7 = ASEUtils.getString("CONTEXT_MENU_DISPLAY_STATISTICS_HINT");
            return new ASEMenuItem(n, string6, string7, Support.getMnemonic("CONTEXT_MENU_DISPLAY_STATISTICS_MNEM"));
        }
        return null;
    }

    @Override
    public boolean deleteObjects(ArrayList arrayList) {
        TableSO tableSO = (TableSO)this.getSO();
        String[] stringArray = new String[arrayList.size()];
        boolean bl = true;
        Support.getViewerSupport().startWait();
        for (int i = 0; i < arrayList.size(); ++i) {
            tableSO = (TableSO)((ASEBaseContainer2)arrayList.get(i)).getSO();
            stringArray[i] = tableSO.getOwner() + "." + tableSO.getName();
        }
        try {
            tableSO.remove(stringArray);
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), ASEMessageText.toString(sQLException), sQLException);
            bl = false;
        }
        Support.getViewerSupport().endWait();
        return bl;
    }

    @Override
    String[] getDDLParams(SOItemInterface sOItemInterface) {
        String[] stringArray;
        TableSO tableSO = (TableSO)sOItemInterface;
        String string = tableSO.getConnection().getCharacterSet();
        if (string != null) {
            stringArray = new String[8];
            stringArray[7] = "-J" + string;
        } else {
            stringArray = new String[]{"-U" + tableSO.getConnection().getCurrentUser(), "-P" + tableSO.getConnection().getPassword(), "-S" + tableSO.getConnection().getHostName() + ":" + tableSO.getConnection().getPortNumber(), "-TU", "-N" + tableSO.getOwner() + "." + tableSO.getName(), "-D" + tableSO.getDatabaseName(), "-F%"};
        }
        return stringArray;
    }

    @Override
    public boolean includeDDLGen() {
        return true;
    }

    @Override
    public boolean includeDelete() {
        return this.isUserTable() && super.includeDelete();
    }
}

