/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.ase.logon.ASEDatabaseSource;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.ProfileHelper;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ASEProvider;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.ServerGroupBO;
import com.sybase.aseplugin.bo.ServersDetailsBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.UtilitiesDetailsBO;
import com.sybase.aseplugin.bo.dlg.ExportServerGroupsDialog;
import com.sybase.aseplugin.bo.prop.ProviderProperties;
import com.sybase.aseplugin.bo.wiz.ServerGroupWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.ServerGroupSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.util.Debug;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.ua.AuthorizationException;
import com.sybase.ua.discovery.DiscoveryException;
import com.sybase.util.ds.uaf.DiscoverySetting;
import com.sybase.util.ds.uaf.SyUAF;
import com.sybase.util.ds.uaf.SyUAFASEEntry;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class TopBO
extends ASEBaseContainer2 {
    private static final int CMD_CONNECT = 3001;
    private static final int CMD_EXPORT = 3002;
    private static final int CMD_IMPORT = 3003;
    private static final int CMD_NEW_SERVER_GROUP = 3004;
    public static final ImageIcon ASE_ICON = new ImageIcon(ASEImages.getASEPluginSmallImage());
    private static final String[] PASTABLE_CLASS_NAMES = new String[]{ServerBO.class.getName()};
    private static Timer _statusTimer = null;
    private ASEProvider _provider;
    private UtilitiesDetailsBO _utilitiesDetailsBO = null;
    private ServersDetailsBO _serversDetailsBO = null;
    private ServerGroupBO _defaultServerGroup = null;
    private TreeSet _servers = new TreeSet();
    private List _discoverySettings = null;
    private boolean _needUpdate = true;

    public TopBO(ASEProvider aSEProvider) {
        super(ASEUtils.getString("DNAME_ASE"), null, null);
        this._provider = aSEProvider;
        this.initGroupServers();
        this.initServerStatusCheck();
    }

    public ServerGroupSO getDefaultServerGroup() {
        return (ServerGroupSO)this._defaultServerGroup.getSO();
    }

    @Override
    public Object[] getDetailsPanels(JFrame jFrame) {
        if (this._detailsPanels == null) {
            this._detailsPanels = new Object[]{Support.createDetailsListPanel(ASEUtils.getString("DNAME_SERVER_GROUPS")), Support.createDetailsListPanel(ASEUtils.getString("DNAME_SERVERS"), this.getServersDetailsBO()), Support.createDetailsListPanel(ASEUtils.getString("DNAME_UTILITIES"), this.getUtilitiesDetailsBO())};
        }
        return this._detailsPanels;
    }

    public UtilitiesDetailsBO getUtilitiesDetailsBO() {
        if (this._utilitiesDetailsBO == null) {
            this._utilitiesDetailsBO = new UtilitiesDetailsBO(this);
        }
        return this._utilitiesDetailsBO;
    }

    private ServersDetailsBO getServersDetailsBO() {
        if (this._serversDetailsBO == null) {
            this._serversDetailsBO = new ServersDetailsBO(this);
        }
        return this._serversDetailsBO;
    }

    public ASEProvider getProvider() {
        return this._provider;
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        ASEBaseHeader aSEBaseHeader = new ASEBaseHeader(ASEUtils.getString("DISP_SERVER_GROUP_TEXT"), 0, 170);
        ASEBaseHeader aSEBaseHeader2 = new ASEBaseHeader(ASEUtils.getString("DISP_COMMENT_TEXT"), 1, 200);
        return new ASEBaseHeader[]{aSEBaseHeader, aSEBaseHeader2};
    }

    @Override
    public Icon getImage(boolean bl) {
        return ASE_ICON;
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        String string = ASEUtils.getString("DISP_SERVER_GROUP_TEXT");
        String string2 = ASEUtils.getString("CREATION_HINT_NEW_SERVER_GROUP");
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3004, string, string2, Support.getMnemonic("CREATION_MNEM_NEW_SERVER_GROUP"), ServerGroupBO.SERVER_GROUP_ICON);
        return new ASEMenuItem[]{aSEMenuItem};
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3004, ServerGroupBO.NEW_SERVER_GROUP_ICON, ASEUtils.getString("DISP_SERVER_GROUP_TEXT"), ASEUtils.getString("CREATION_HINT_NEW_SERVER_GROUP"));
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public SCMenu getContextMenu() {
        if (this._contextMenu != null) {
            return this._contextMenu;
        }
        this._contextMenu = new ASEMenu();
        String string = ASEUtils.getString("CONTEXT_MENU_CONNECT_TEXT");
        String string2 = ASEUtils.getString("CONTEXT_MENU_CONNECT_HINT");
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3001, string, string2, Support.getMnemonic("CONTEXT_MENU_CONNECT_MNEM"), ASEMenuItem.CONNECT_ICON);
        this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        string = ASEUtils.getString("EXPORT_DLG_TITLE") + "...";
        string2 = ASEUtils.getString("CONTEXT_MENU_EXPORT_GROUPS_HINT");
        aSEMenuItem = new ASEMenuItem(3002, string, string2, Support.getMnemonic("CONTEXT_MENU_EXPORT_GROUPS_MNEM"));
        this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        string = ASEUtils.getString("IMPORT_DLG_TITLE") + "...";
        string2 = ASEUtils.getString("CONTEXT_MENU_IMPORT_GROUPS_HINT");
        aSEMenuItem = new ASEMenuItem(3003, string, string2, Support.getMnemonic("CONTEXT_MENU_IMPORT_GROUPS_MNEM"));
        this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        if (this.includePaste()) {
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            ASEMenuItem aSEMenuItem2 = ASEMenuItem.getPasteMenuItem();
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem2);
        }
        this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        return this._contextMenu;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 64;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        if (n == 107) {
            ASEBaseDialog2.showDialog(jFrame, new ProviderProperties((SCContainer2)this));
        } else if (n == 3001) {
            ASConnection aSConnection = Support.getProvider().connect(jFrame, this.getDefaultServerGroup());
            if (aSConnection != null) {
                Support.getProvider().handleRefreshConnect(this.getDefaultServerGroup().getName(), aSConnection);
            }
        } else if (n == 3004) {
            ServerGroupSO serverGroupSO = new ServerGroupSO();
            ASEBaseDialog2.showDialog(jFrame, new ServerGroupWizard(serverGroupSO, this));
        } else if (n == 3002) {
            ExportServerGroupsDialog exportServerGroupsDialog = ExportServerGroupsDialog.showDialog(jFrame, null);
            exportServerGroupsDialog.render();
        } else if (n == 3003) {
            String string = Support.browseForFile(jFrame, null, ASEUtils.getString("IMPORT_DLG_TITLE"), 128);
            if (string != null) {
                try {
                    ServerGroupSO.importGroups(string);
                    this.initGroupServers();
                    this.refresh();
                }
                catch (Exception exception) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)jFrame, exception.getMessage(), exception);
                }
            }
        } else {
            super.onCommand(jFrame, n, enumeration, n2);
        }
    }

    @Override
    public Vector getItems(int n) {
        Vector<ServerGroupBO> vector = new Vector<ServerGroupBO>();
        List list = ServerGroupSO.getGroups();
        if (this._defaultServerGroup == null) {
            for (ServerGroupSO serverGroupSO : list) {
                if (!serverGroupSO.isDefault()) continue;
                this._defaultServerGroup = new ServerGroupBO(this, serverGroupSO);
                break;
            }
        }
        if (this._defaultServerGroup != null) {
            vector.add(this._defaultServerGroup);
        }
        for (ServerGroupSO serverGroupSO : list) {
            if (serverGroupSO.isDefault()) continue;
            vector.add(new ServerGroupBO(this, serverGroupSO));
        }
        return vector;
    }

    protected boolean unRegisterServer(ServerSO serverSO, ServerGroupSO serverGroupSO) {
        ServerSO serverSO2 = this.getRegisteredServer(serverSO, serverGroupSO);
        if (serverSO2 != null) {
            return this._servers.remove(serverSO2);
        }
        return false;
    }

    public boolean removeServerFromGroup(ServerSO serverSO, ServerGroupSO serverGroupSO) {
        if (serverSO != null && serverSO.getConnection() != null) {
            Support.getProvider().removeServerConnections(serverSO);
        }
        if (serverSO != null) {
            try {
                serverSO.remove();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            }
        }
        return Support.getTopBO().unRegisterServer(serverSO, serverSO.getServerGroup());
    }

    private ServerSO getRegisteredServer(ServerSO serverSO, ServerGroupSO serverGroupSO) {
        ServerSO serverSO2 = null;
        for (ServerSO serverSO3 : this._servers) {
            if (serverSO3.getConnection() != null || !serverSO3.getName().equals(serverSO.getName()) || (serverSO3.getUserName() != null || serverSO3.getUserName() != serverSO.getUserName()) && (serverSO3.getUserName() == null || !serverSO3.getUserName().equals(serverSO.getUserName())) || !serverSO3.getServerGroup().equals(serverGroupSO)) continue;
            serverSO2 = serverSO3;
            break;
        }
        return serverSO2;
    }

    private SyUAFASEEntry getUAFEntry(String string, String string2) {
        return ServerSO.getDiscoveredServer(string, string2);
    }

    protected ASConnection addConnection(JFrame jFrame, ASEConnectionInfo aSEConnectionInfo, ASEProvider aSEProvider, int n, ServerGroupSO serverGroupSO) throws ClassNotFoundException, SQLException {
        String string = String.valueOf(aSEConnectionInfo.port);
        ASConnection aSConnection = new ASConnection(aSEConnectionInfo, n);
        String string2 = aSConnection.getVersion();
        if (string2.trim().length() > 0 && string2.compareTo("12.0") < 0) {
            Support.showError(this.getConnection(), this.getClass(), jFrame, ASEUtils.getString("MSG_SERVER_NOT_SUPPORTED"));
            return null;
        }
        if (serverGroupSO != null) {
            SyUAFASEEntry syUAFASEEntry = this.getUAFEntry(aSEConnectionInfo.host, string);
            ServerSO serverSO = new ServerSO(aSConnection, aSConnection.getConnectionInfo(), ServerSO.getServerName(aSEConnectionInfo.getServerName(), aSEConnectionInfo.host, string), serverGroupSO, syUAFASEEntry);
            this.unRegisterServer(serverSO, serverGroupSO);
            serverSO.addToServerGroup(serverGroupSO);
            this.registerServer(serverSO);
        }
        return aSConnection;
    }

    public void registerServer(ServerSO serverSO) {
        this._servers.add(serverSO);
    }

    public Iterator getServersIterator() {
        return this._servers.iterator();
    }

    public List getConnectionsByRealServerName(String string) {
        ArrayList<ASConnection> arrayList = new ArrayList<ASConnection>();
        for (ServerSO serverSO : this._servers) {
            boolean bl;
            ASConnection aSConnection = serverSO.getConnection();
            if (aSConnection == null || !(bl = aSConnection.getServerServerName().equals(string))) continue;
            arrayList.add(aSConnection);
        }
        return arrayList;
    }

    public List getConnections(String string) {
        String string2 = string;
        for (ServerSO serverSO : this._servers) {
            if (!serverSO.getName().equals(string)) continue;
            string2 = serverSO.getIPAndPort();
            break;
        }
        return this.getConnections(string2, null, null);
    }

    public List getConnections(ServerSO serverSO) {
        return this.getConnections(serverSO.getIPAndPort(), null, null);
    }

    public List getConnections(ServerSO serverSO, ServerGroupSO serverGroupSO) {
        return this.getConnections(serverSO.getIPAndPort(), serverSO.getUserName(), serverGroupSO);
    }

    private List getConnections(String string, String string2, ServerGroupSO serverGroupSO) {
        ArrayList<ASConnection> arrayList = new ArrayList<ASConnection>();
        for (ServerSO serverSO : this._servers) {
            ASConnection aSConnection = serverSO.getConnection();
            if (aSConnection == null) continue;
            String string3 = serverSO.getIPAndPort();
            String string4 = serverSO.getUserName();
            boolean bl = string3.equals(string) && (string2 == null || string4.equals(string2));
            if (!bl) continue;
            if (serverGroupSO == null) {
                arrayList.add(aSConnection);
                continue;
            }
            if (serverSO.getServerGroup() == null || !serverSO.getServerGroup().equals(serverGroupSO)) continue;
            arrayList.add(aSConnection);
        }
        return arrayList;
    }

    protected boolean hasConnections(ServerGroupSO serverGroupSO) {
        for (ServerSO serverSO : this._servers) {
            ASConnection aSConnection;
            if (!serverGroupSO.equals(serverSO.getServerGroup()) || (aSConnection = serverSO.getConnection()) == null) continue;
            return true;
        }
        return false;
    }

    protected void removeConnection(ASConnection aSConnection) {
        Object object;
        ServerSO serverSO = null;
        for (ASEBaseItemSO aSEBaseItemSO : this._servers) {
            object = aSEBaseItemSO.getConnection();
            if (object == null || !object.equals(aSConnection)) continue;
            serverSO = aSEBaseItemSO;
            break;
        }
        if (serverSO != null) {
            String string = aSConnection.getLastFolderPath();
            serverSO.setLastServerFolder(string);
            this._servers.remove(serverSO);
            if (ProfileHelper.getBooleanPreference("Setting.RememberServer")) {
                ASEBaseItemSO aSEBaseItemSO;
                aSEBaseItemSO = serverSO.getServerGroup();
                object = this.getConnections(serverSO, (ServerGroupSO)aSEBaseItemSO);
                if (object.size() == 0) {
                    List list = ((ServerGroupSO)aSEBaseItemSO).getServers();
                    for (ServerSO serverSO2 : list) {
                        if (!serverSO.getName().equals(serverSO2.getName()) || !serverSO.getUserName().equals(serverSO2.getUserName())) continue;
                        SyUAFASEEntry syUAFASEEntry = this.getUAFEntry(serverSO2.getHostName(), serverSO2.getPortNumber());
                        serverSO2.setUAFInfo(syUAFASEEntry);
                        this.registerServer(serverSO2);
                    }
                }
            } else {
                try {
                    serverSO.remove();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.unRegisterServer(serverSO, serverSO.getServerGroup());
            }
        }
    }

    @Override
    public int getAttributes() {
        return 5;
    }

    protected void markShutDown(ServerSO serverSO) {
        List list = this.getConnections(serverSO);
        for (ASConnection aSConnection : list) {
            Enumeration enumeration = this.getItems();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof ServerGroupBO)) continue;
                ServerGroupBO serverGroupBO = (ServerGroupBO)e;
                Enumeration enumeration2 = serverGroupBO.getItems();
                while (enumeration2.hasMoreElements()) {
                    ServerBO serverBO;
                    ServerSO serverSO2;
                    e = enumeration2.nextElement();
                    if (!(e instanceof ServerBO) || (serverSO2 = (ServerSO)(serverBO = (ServerBO)e).getSO()).getConnection() != aSConnection) continue;
                    serverSO2.load();
                    serverBO.setImageIcon(ServerBO.getIcon(serverSO2));
                    serverBO.redisplayLater(serverGroupBO, (ASEBaseItem2)serverBO);
                }
            }
        }
    }

    public void removeUAConnections() {
        for (ServerSO serverSO : this._servers) {
            serverSO.removeAgentConnections();
        }
    }

    private int getStatusCheckInterval() {
        String string = ProfileHelper.getPreference("Setting.CheckServer");
        int n = 30;
        if (string != null) {
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private void initServerStatusCheck() {
        String string;
        String string2;
        ServerSO.setDefaultAgentPort(ASEDatabaseSource.getSavedAgentPortNumber());
        if (ProfileHelper.getUAFEnabled()) {
            int n = this.getStatusCheckInterval();
            if (n == 0) {
                this.resetServerStatusCheck(-1);
            } else {
                this.resetServerStatusCheck(n > 30 ? 30 : n);
            }
        }
        if ((string2 = System.getProperty(string = "isql.helpFolder")) == null) {
            try {
                string2 = ASEProvider.getSybrootPath() + File.separator + "DBISQL" + File.separator + "help";
                System.setProperty(string, string2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void resetServerStatusCheck(int n) {
        if (ProfileHelper.getUAFEnabled()) {
            if (n > 0) {
                if (_statusTimer == null) {
                    _statusTimer = new Timer();
                }
                _statusTimer.schedule((TimerTask)new ServerStatusTask(), 0L, (long)(n * 60000));
            } else if (n < 0) {
                this.getTimer().schedule((TimerTask)new ServerStatusTask(), 0L);
            } else if (_statusTimer != null) {
                _statusTimer.cancel();
                _statusTimer = null;
            }
        }
    }

    public void setNeedUpdate(boolean bl) {
        this._needUpdate = bl;
    }

    public void refresh(boolean bl) {
        this.setNeedUpdate(bl);
        this._helper.refresh();
        this.setNeedUpdate(true);
    }

    private Timer getTimer() {
        return new Timer();
    }

    public void updateServer(ServerBO serverBO) {
        ServerSO serverSO = (ServerSO)serverBO.getSO();
        this.updateServerUAF(serverSO);
        SyUAFASEEntry syUAFASEEntry = this.getUAFEntry(serverSO.getHostName(), serverSO.getPortNumber());
        serverSO.setUAFInfo(syUAFASEEntry);
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_CHECKING_SERVER_STATUS"), serverSO.getName());
        this.showThreadMessage(aSEMessageText.toString());
        serverBO.pingSilent();
        this.showThreadMessage("");
    }

    private void showThreadMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Thread.currentThread().isAlive()) {
                    Support.setStatusBarMessage(string);
                }
            }
        });
    }

    protected void showThreadException(int n, Exception exception) {
        this.showThreadException(n, "", exception);
    }

    private void showThreadException(final int n, final String string, final Exception exception) {
        if (Debug.isOn()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Thread.currentThread().isAlive()) {
                        if (string == null) {
                            Support.addLogEntry(n, null, this.getClass(), exception.getMessage(), ASEUtils.getStackTrace(exception));
                        } else {
                            Support.addLogEntry(n, null, this.getClass(), string, ASEUtils.getStackTrace(exception));
                        }
                    }
                }
            });
        }
    }

    public void updateServers() {
        this.discoverServers();
    }

    private void updateServers(Enumeration enumeration, ServerBO serverBO) {
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof ServerBO)) continue;
            ServerBO serverBO2 = (ServerBO)e;
            if (serverBO != null && !serverBO.isSameAs(serverBO2)) continue;
            this.updateServer(serverBO2);
        }
    }

    public String getDiscoverySettings() {
        if (this._discoverySettings == null) {
            return null;
        }
        return DiscoverySetting.getDiscoverySettingsString((List)this._discoverySettings);
    }

    private void initGroupServers() {
        List list = ServerGroupSO.getGroups();
        boolean bl = false;
        for (ServerGroupSO serverGroupSO : list) {
            if (serverGroupSO.isDefault()) {
                bl = true;
            }
            List list2 = serverGroupSO.getServers();
            for (ServerSO serverSO : list2) {
                this.registerServer(serverSO);
            }
        }
        if (list == null || list != null && !bl) {
            ServerGroupSO serverGroupSO = new ServerGroupSO(ServerGroupSO.DEFAULT_SERVER_GROUP, ASEUtils.getString("MSG_DEFAULT_SERVER_GROUP"), true);
            serverGroupSO.create();
            this._defaultServerGroup = new ServerGroupBO(this, serverGroupSO);
        }
    }

    private void initServerDiscovery() {
        this.initServerDiscovery(false);
    }

    public void initServerDiscovery(boolean bl) {
        this._discoverySettings = DiscoverySetting.getDiscoverySettings();
        if (bl) {
            this.initServerStatusCheck();
        }
    }

    public void updateServerStatus(ServerBO serverBO) {
        this.updateServerStatus(serverBO, false, 0, null);
    }

    public void updateServerStatus(ServerBO serverBO, boolean bl, int n) {
        this.updateServerStatus(serverBO, bl, n, null);
    }

    public void updateServerStatus(ServerBO serverBO, boolean bl, int n, String string) {
        ServerSO serverSO = (ServerSO)serverBO.getSO();
        if (ProfileHelper.getUAFEnabled() && (this._needUpdate || !serverSO.pinged())) {
            this.getTimer().schedule((TimerTask)new ServerStatusTask(serverBO, bl, string), n);
        }
    }

    public void discoverServers() {
        this.initServerDiscovery();
        boolean bl = false;
        for (DiscoverySetting discoverySetting : this._discoverySettings) {
            ASEMessageText aSEMessageText;
            SyUAF syUAF = new SyUAF();
            syUAF.init(discoverySetting.service, discoverySetting.host, discoverySetting.port);
            try {
                syUAF.initAgentDiscovery();
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_DISCOVERING_SERVERS"), discoverySetting.getURL());
                this.showThreadMessage(aSEMessageText.toString());
                List list = syUAF.discover();
                bl = bl || list.size() > 0;
                Thread.currentThread().setContextClassLoader(classLoader);
                for (SyUAFASEEntry syUAFASEEntry : list) {
                    if (syUAFASEEntry.isCluster()) {
                        ArrayList arrayList = syUAFASEEntry.getHostPorts();
                        arrayList.iterator();
                        for (String[] stringArray : arrayList) {
                            String string = stringArray[0];
                            String string2 = stringArray[1];
                            if (!syUAFASEEntry.getHostName().equalsIgnoreCase(string)) continue;
                            ServerSO.addDiscoveredServer(string, string2, syUAFASEEntry);
                        }
                        continue;
                    }
                    ServerSO.addDiscoveredServer(syUAFASEEntry.getHostName(), syUAFASEEntry.getPortNumber(), syUAFASEEntry);
                }
            }
            catch (DiscoveryException discoveryException) {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_FAILED_TO_DISCOVER_SERVERS"), discoverySetting.getURL());
                this.showThreadException(1, aSEMessageText.toString(), (Exception)((Object)discoveryException));
            }
        }
        this.showThreadMessage("");
    }

    private void updateRegisteredServers() {
        this.updateRegisteredServers(null);
    }

    private void updateRegisteredServers(ServerBO serverBO) {
        Enumeration enumeration = this.getItems();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof ServerGroupBO)) continue;
            ServerGroupBO serverGroupBO = (ServerGroupBO)e;
            Enumeration enumeration2 = serverGroupBO.getItems();
            this.updateServers(enumeration2, serverBO);
        }
    }

    private void updateDetailsServers() {
        this.updateDetailsServers(null);
    }

    private void updateDetailsServers(ServerBO serverBO) {
        Enumeration enumeration = this.getServersDetailsBO().getItems();
        this.updateServers(enumeration, serverBO);
    }

    private synchronized void updateServerUAF(ServerSO serverSO) {
        block5: {
            try {
                String string = serverSO.getHostName();
                String string2 = serverSO.getPortNumber();
                if (!ServerSO.containsDiscoveredServers(string, string2)) {
                    List list = serverSO.getUAFEntries();
                    for (SyUAFASEEntry syUAFASEEntry : list) {
                        String string3 = syUAFASEEntry.getHostName();
                        if (!syUAFASEEntry.containsHostPort(string, string2)) continue;
                        String string4 = !string.equalsIgnoreCase(string3) ? string : string3;
                        ServerSO.addDiscoveredServer(string4, string2, syUAFASEEntry);
                    }
                }
            }
            catch (AuthorizationException authorizationException) {
                this.showThreadException(1, (Exception)((Object)authorizationException));
            }
            catch (RemoteException remoteException) {
                if (!Debug.isOn()) break block5;
                this.showThreadException(2, remoteException);
            }
        }
    }

    @Override
    public String[] getPastableClassNames() {
        return PASTABLE_CLASS_NAMES;
    }

    @Override
    boolean pasteItem(JFrame jFrame, Object object, int n) {
        if (object instanceof ServerBO) {
            ServerBO serverBO = (ServerBO)object;
            ServerSO serverSO = (ServerSO)serverBO.getSO();
            if (serverSO.getConnection() != null) {
                return false;
            }
            String string = serverSO.getUserName();
            if (string == null || string.length() == 0) {
                boolean bl;
                ASEConnectionInfo aSEConnectionInfo = serverSO.getConnectionInfo();
                ASConnection aSConnection = Support.getProvider().connect(jFrame, serverSO.getServerGroup(), aSEConnectionInfo);
                boolean bl2 = bl = aSConnection != null;
                if (bl) {
                    Support.getProvider().handleRefreshConnect(serverSO.getServerGroup().getName(), aSConnection);
                }
                return bl;
            }
        }
        return false;
    }

    @Override
    public int queryDropItems(int n, DataFlavor[] dataFlavorArray) {
        boolean bl = this.arePastable(dataFlavorArray, PASTABLE_CLASS_NAMES);
        if (bl) {
            return 2;
        }
        return 0;
    }

    class ServerStatusTask
    extends TimerTask {
        private ServerBO _serverBO;
        private boolean _checkRelated = false;
        private String _goal = null;

        ServerStatusTask() {
            this._serverBO = null;
        }

        ServerStatusTask(ServerBO serverBO, boolean bl, String string) {
            this._serverBO = serverBO;
            this._checkRelated = bl;
            this._goal = string;
        }

        @Override
        public void run() {
            Thread.currentThread().setName(this._serverBO == null ? "all servers" : this._serverBO.getDisplayName(0));
            Thread.currentThread().setPriority(1);
            try {
                if (this._serverBO == null) {
                    TopBO.this.updateRegisteredServers();
                    TopBO.this.updateDetailsServers();
                } else {
                    ServerSO serverSO;
                    String string;
                    if (this._goal != null && (string = (serverSO = (ServerSO)this._serverBO.getSO()).getStatus()).equalsIgnoreCase(this._goal)) {
                        return;
                    }
                    if (this._checkRelated) {
                        TopBO.this.updateRegisteredServers(this._serverBO);
                        TopBO.this.updateDetailsServers(this._serverBO);
                    } else {
                        TopBO.this.updateServer(this._serverBO);
                    }
                }
            }
            catch (Exception exception) {
                TopBO.this.showThreadException(1, exception);
            }
        }
    }
}

