/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseDBContainer;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.UserBO;
import com.sybase.aseplugin.bo.wiz.UserWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.UserSO;
import com.sybase.aseplugin.so.UsersCtrSO;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.swing.JFrame;

public class UsersCtrBO
extends ASEBaseDBContainer {
    private static int NAME = 0;
    private static int GROUP = 1;
    private static int LOGIN = 2;

    public UsersCtrBO(DatabaseBO databaseBO) {
        super(ASEUtils.getString("DNAME_USERS"), databaseBO);
        this.setCtrSO(new UsersCtrSO(this.getConnection(), this.getDatabaseSO()));
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        return new ASEBaseHeader[]{new ASEBaseHeader(ASEUtils.getString("DISP_NAME_TEXT"), NAME, 170), new ASEBaseHeader(ASEUtils.getString("DISP_GROUP_TEXT"), GROUP, 80), new ASEBaseHeader(ASEUtils.getString("DISP_LOGIN_TEXT"), LOGIN, 80)};
    }

    @Override
    public ASEBaseItem2 getItemBO(ASEBaseItemSO aSEBaseItemSO) {
        return new UserBO((UserSO)aSEBaseItemSO, this);
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        String string = ASEUtils.getString("MSG_USER_TYPE");
        String string2 = ASEUtils.getString("CREATION_HINT_NEW_USER");
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3071, string, string2, Support.getMnemonic("CREATION_MNEM_NEW_USER"), UserBO.USER_ICON);
        return new ASEMenuItem[]{aSEMenuItem};
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3071, UserBO.NEW_USER_ICON, ASEUtils.getString("MSG_USER_TYPE"), ASEUtils.getString("CREATION_HINT_NEW_USER"));
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        if (n == 3071) {
            UserSO userSO = new UserSO(this.getConnection(), null, this.getDatabaseSO());
            try {
                if (userSO.getConnection().hasSARole() && userSO.getAvailableLogins().size() == 0) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_LOGIN_UNAVIALABLE"), userSO.getDatabaseName());
                    Support.showError(this.getConnection(), this.getClass(), aSEMessageText.toString());
                    return;
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                return;
            }
            ASEBaseDialog2.showDialog(jFrame, new UserWizard(userSO, this));
        } else {
            super.onCommand(jFrame, n, enumeration, n2);
        }
    }
}

