/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseDetailsContainer;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.RemoteServersCtrBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.WebServicesBO;
import com.sybase.aseplugin.bo.wiz.RemoteServerWizard;
import com.sybase.aseplugin.bo.wiz.WebServicesConsumeWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.RemoteServerSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.WebServicesCtrSO;
import com.sybase.aseplugin.so.WebServicesSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.central.SCToolBarButton;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;

public class WebServicesCtrBO
extends ASEBaseDetailsContainer {
    private DatabaseSO _dbso;

    public WebServicesCtrBO(DatabaseBO databaseBO) {
        super(ASEUtils.getString("DNAME_WEBSERVICES"), databaseBO);
        this.setHeadingInfo(this.getHeadings());
        this._dbso = (DatabaseSO)databaseBO.getSO();
    }

    @Override
    void populate() {
        try {
            if (this.isOpened()) {
                return;
            }
            this.clearItems();
            ASConnection aSConnection = this.getParent().getSO().getConnection();
            WebServicesCtrSO webServicesCtrSO = new WebServicesCtrSO(aSConnection);
            Vector vector = (Vector)webServicesCtrSO.open(1, null);
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    this.addItem((SCItem)new WebServicesBO((SOItemInterface)((WebServicesSO)vector.elementAt(i)), this));
                }
            }
            this.setOpened(true);
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getParent().getSO().getConnection(), this.getClass(), ASEMessageText.toString(sQLException), sQLException);
        }
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        return new ASEBaseHeader[]{new ASEBaseHeader(ASEUtils.getString("DISP_NAME_TEXT"), 0, 170), new ASEBaseHeader(ASEUtils.getString("DNAME_PROXYTABLE"), 1, 80), new ASEBaseHeader(ASEUtils.getString("MSG_OWNER"), 2, 80), new ASEBaseHeader(ASEUtils.getString("DISP_WSDL_URI"), 3, 280), new ASEBaseHeader(ASEUtils.getString("DISP_TIMEOUT_TEXT") + "(" + ASEUtils.getString("MILLISECOND") + ")", 4, 80)};
    }

    @Override
    public SCMenu getCreationMenu() {
        if (!this._dbso.includeCreate()) {
            return null;
        }
        this._creationMenu = new ASEMenu();
        String string = ASEUtils.getString("MSG_CONSUME_WEBSERVICE");
        String string2 = ASEUtils.getString("WS_CONSUMER_WIZ_TABLES_PAGE_SENT_INTRO");
        boolean bl = this._dbso.enableCreate();
        string2 = string2 + (!bl ? ASEUtils.getString("CONTEXT_MENU_DELETE_MORE_DB_HINT") : "");
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3084, string, string2, Support.getMnemonic("MNEM_CONSUME_WEBSERVICE"), WebServicesBO.WEB_SERVICE_ICON);
        aSEMenuItem.setEnabled(bl);
        this._creationMenu.addItem((SCMenuItem)aSEMenuItem);
        return this._creationMenu;
    }

    @Override
    public SCToolBarButton[] getCreationToolBarButtons() {
        if (this._creationToolBar != null) {
            return this._creationToolBar;
        }
        if (!this._dbso.includeCreate()) {
            return null;
        }
        ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3084, WebServicesBO.NEW_WEB_SERVICE_ICON, ASEUtils.getString("MSG_CONSUME_WEBSERVICE"), ASEUtils.getString("WS_CONSUMER_WIZ_TABLES_PAGE_SENT_INTRO") + (this._dbso.enableCreate() ? "" : ASEUtils.getString("CONTEXT_MENU_DELETE_MORE_DB_HINT")));
        aSEToolBarButton.setEnabled(this._dbso.enableCreate());
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        block6: {
            if (n == 3084) {
                ASConnection aSConnection = this.getParent().getConnection();
                WebServicesSO webServicesSO = new WebServicesSO(aSConnection, "");
                try {
                    Vector vector = webServicesSO.getSDSRemoteServerNames();
                    if (vector.size() == 0) {
                        if (Support.showQuestionYesNo(jFrame, ASEUtils.getString("MSG_WS_CONSUMER_WIZ_NO_SDS_SERVER")) == 0) {
                            ServerBO serverBO = ContainerViewBO.getServerBO(aSConnection);
                            RemoteServersCtrBO remoteServersCtrBO = new RemoteServersCtrBO(serverBO);
                            RemoteServerSO remoteServerSO = new RemoteServerSO(aSConnection, "");
                            RemoteServerWizard remoteServerWizard = new RemoteServerWizard(remoteServerSO, remoteServersCtrBO);
                            ASEBaseDialog2.showDialog(jFrame, remoteServerWizard, true);
                            this.onCommand(jFrame, n, enumeration, n2);
                        }
                        break block6;
                    }
                    WebServicesSO webServicesSO2 = new WebServicesSO(aSConnection, "");
                    ASEBaseDialog2.showDialog(jFrame, new WebServicesConsumeWizard(webServicesSO2, this));
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(aSConnection, this.getClass(), ASEMessageText.toString(sQLException), sQLException);
                }
            } else {
                super.onCommand(jFrame, n, enumeration, n2);
            }
        }
    }
}

