/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEDialogController;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.bo.dlg.WorkingDialogWithCancel;
import com.sybase.aseplugin.go.dlg.AddAgentDlgGOPage;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.aseplugin.util.SDCClusterAgentUtils;
import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import com.sybase.ua.AgentConnection;
import com.sybase.ua.AgentInfo;
import java.awt.Container;
import java.awt.Dialog;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddAgentDialog
extends ASEDialogController {
    public static final boolean CLOSE_STATE_CANCEL = false;
    public static final boolean CLOSE_STATE_OK = true;
    private static SCDialogSupport _ds;
    private AddAgentDialogPage _page;
    private boolean _closeState = false;

    public static AddAgentDialog showDialog(SDCClusterSO sDCClusterSO, Container container, Vector vector, String string, String string2, String string3) {
        SCDialogSupport sCDialogSupport;
        _ds = sCDialogSupport = Support.createDialogSupport(container);
        AddAgentDialog addAgentDialog = new AddAgentDialog(sDCClusterSO, vector, string, string2, string3);
        sCDialogSupport.setDialogController((SCDialogController)addAgentDialog);
        sCDialogSupport.setTitle(ASEUtils.getString("ADD_AGENT_DLG_SENT_INTRO"));
        sCDialogSupport.setResizable(true);
        sCDialogSupport.setModal(true);
        sCDialogSupport.render();
        return addAgentDialog;
    }

    public String getHelpID() {
        return "HELP_DLG_ADD_AGENT_1503CE";
    }

    AddAgentDialog(SDCClusterSO sDCClusterSO, Vector vector, String string, String string2, String string3) {
        super(_ds, new SCPageController[1]);
        this._page = new AddAgentDialogPage(sDCClusterSO, _ds, vector, string, string2, string3);
        this._pageControllers[0] = this._page;
    }

    public boolean getCloseState() {
        return this._closeState;
    }

    public String getAgentHost() {
        return this._page.getAgentHost();
    }

    public String getAgentPort() {
        return this._page.getAgentPort();
    }

    public SDCClusterAgentProxy getSDCClusterAgentProxy() {
        return this._page.getSDCClusterAgentProxy();
    }

    public AgentInfo getAgentInfo() {
        return this._page.getAgentInfo();
    }

    class AddAgentDialogPage
    extends ASEPageController
    implements DocumentListener {
        private AddAgentDlgGOPage _go;
        private SDCClusterSO _so;
        private Vector _existentAgents;
        private String _user;
        private String _passwd;
        private String _upgradeServer;
        AgentInfo _agentInfo;
        SDCClusterAgentProxy _agentProxy;

        AddAgentDialogPage(SDCClusterSO sDCClusterSO, SCDialogSupport sCDialogSupport, Vector vector, String string, String string2, String string3) {
            super(sCDialogSupport, (JPanel)((Object)new AddAgentDlgGOPage()));
            this._agentInfo = null;
            this._agentProxy = null;
            this._existentAgents = vector;
            this._so = sDCClusterSO;
            this._user = string;
            this._passwd = ASEUtils.encryptPassword(string2);
            this._upgradeServer = string3;
            this._go = (AddAgentDlgGOPage)((Object)this.getJPanel());
            if (null != this._upgradeServer && this._upgradeServer.length() > 0) {
                this._go.agentHostTextField.setText(this._upgradeServer);
                this._go.agentHostTextField.setEnabled(false);
            }
            this._go.agentHostTextField.getDocument().addDocumentListener(this);
            this._go.agentPortTextField.getDocument().addDocumentListener(this);
        }

        @Override
        public void init() {
            this.enableOKButton();
        }

        public void textValueChanged() {
            this.enableOKButton();
        }

        private void enableOKButton() {
            _ds.getStandardButtonById(1).setEnabled(this._go.agentHostTextField.getText().length() > 0 && this._go.agentPortTextField.getText().length() > 0);
        }

        String getAgentHost() {
            return this._go.agentHostTextField.getText();
        }

        String getAgentPort() {
            return this._go.agentPortTextField.getText();
        }

        public SDCClusterAgentProxy getSDCClusterAgentProxy() {
            return this._agentProxy;
        }

        public AgentInfo getAgentInfo() {
            return this._agentInfo;
        }

        private boolean isDuplicatedAgent() {
            String string2 = "";
            for (String string2 : this._existentAgents) {
                String string3 = SDCClusterAgentUtils.getAgentNodeName(string2);
                String string4 = SDCClusterAgentUtils.getAgentPort(string2);
                if (!SDCClusterAgentUtils.isSameHost(string3, this._go.agentHostTextField.getText().trim()) || !string4.equalsIgnoreCase(this._go.agentPortTextField.getText().trim())) continue;
                return true;
            }
            return false;
        }

        private boolean isMatchingArchitecture() {
            return this._so.isMatchingArchitecture(this._agentInfo.getOSArchitecture(), this._agentInfo.getOSName());
        }

        public boolean onCancel() {
            AddAgentDialog.this._closeState = false;
            _ds.closeDialog(false);
            return true;
        }

        public boolean onOk() {
            if (this.isDuplicatedAgent()) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_SDC_DUPLICATED_AGENT"), this.getAgentHost() + ":" + this.getAgentPort());
                Support.showError(this._so.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                this._go.agentHostTextField.requestFocus();
                this._go.agentHostTextField.selectAll();
                return false;
            }
            this._agentProxy = new SDCClusterAgentProxy(this.getAgentHost(), this.getAgentPort(), this._user, ASEUtils.decryptPassword(this._passwd));
            InitTask initTask = new InitTask(this._agentProxy);
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_CONNECTING_TO_AGENT"), this.getAgentHost() + ":" + this.getAgentPort());
            WorkingDialogWithCancel workingDialogWithCancel = new WorkingDialogWithCancel((Dialog)this.getJDialog(), initTask, ASEUtils.getString("SDC_TITLE_CONNECTING_TO_AGENT"), aSEMessageText.toString());
            workingDialogWithCancel.dispose();
            if (workingDialogWithCancel.isCancelled()) {
                initTask = null;
                return false;
            }
            if (null == this._agentInfo) {
                Support.showDetailsError(this._so.getConnection(), this.getClass(), (Container)this.getJDialog(), initTask.getErrorMsg(), initTask.getException());
                this._go.agentHostTextField.requestFocus();
                this._go.agentHostTextField.selectAll();
                return false;
            }
            if (!this.isMatchingArchitecture()) {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_AGENT_NOT_MATCH_PLATFORM"), this.getAgentHost() + ":" + this.getAgentPort(), this._so.getClusterPlatform(), this._so.getClusterOS());
                Support.showError(this._so.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                this._go.agentHostTextField.requestFocus();
                this._go.agentHostTextField.selectAll();
                return false;
            }
            AddAgentDialog.this._closeState = true;
            _ds.closeDialog(true);
            return true;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.textValueChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.textValueChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.textValueChanged();
        }

        class InitTask
        implements Runnable {
            private SDCClusterAgentProxy _agentProxy;
            private String _errorMsg = "";
            private Exception _ex = null;

            public InitTask(SDCClusterAgentProxy sDCClusterAgentProxy) {
                this._agentProxy = sDCClusterAgentProxy;
            }

            @Override
            public void run() {
                if (this._agentProxy != null) {
                    try {
                        this._agentProxy.connect();
                        AgentConnection agentConnection = this._agentProxy.getAgentConnection();
                        AddAgentDialogPage.this._agentInfo = agentConnection.getAgentInfo();
                    }
                    catch (Exception exception) {
                        AddAgentDialogPage.this._agentInfo = null;
                        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FAIL_ADD_AGENT"), AddAgentDialogPage.this.getAgentHost() + ":" + AddAgentDialogPage.this.getAgentPort());
                        this._ex = exception;
                        this._errorMsg = aSEMessageText.toString();
                    }
                }
            }

            public String getErrorMsg() {
                return this._errorMsg;
            }

            public Exception getException() {
                return this._ex;
            }
        }
    }
}

