/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.asa.ASAIconTextData;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.ProfileHelper;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseDeviceBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.bo.dlg.WorkingDialog;
import com.sybase.aseplugin.go.ASELongSpinBoxChangeEvent;
import com.sybase.aseplugin.go.ASELongSpinBoxChangeListener;
import com.sybase.aseplugin.go.dlg.AddDeviceToDatabaseDlgGOPage;
import com.sybase.aseplugin.so.ArchiveDBSO;
import com.sybase.aseplugin.so.CheckVCSStatusTask;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.util.ui.JLabelTableModel;
import com.sybase.central.SCDialogSupport;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;

class AddDeviceToDatabaseDialogPage
extends ASEPageController
implements ActionListener,
ListSelectionListener,
ASELongSpinBoxChangeListener {
    private AddDeviceToDatabaseDlgGOPage _go = (AddDeviceToDatabaseDlgGOPage)((Object)this.getJPanel());
    private Vector _vDeviceSOs;
    private DatabaseSO _databaseSO;
    private JLabelTableModel _tableModel;
    private JTable _table;
    private boolean _blnPropertyPage;
    private Vector _ignoreDevList;
    private Map _initDBSizeMap;

    public AddDeviceToDatabaseDialogPage(SCDialogSupport sCDialogSupport, DatabaseSO databaseSO, Vector vector, JLabelTableModel jLabelTableModel, JTable jTable, boolean bl, Map map, Vector vector2) {
        super(sCDialogSupport, (JPanel)((Object)new AddDeviceToDatabaseDlgGOPage()));
        this._go.devicesMultiList.addListSelectionListener((ListSelectionListener)this);
        this._go.devicesMultiList.setSelectionMode(0);
        this._go.sizeSpinBox.addSpinBoxChangeListener(this);
        this._go.sizeSpinBox.setEnabled(false);
        this._vDeviceSOs = vector;
        this._databaseSO = databaseSO;
        this._tableModel = jLabelTableModel;
        this._table = jTable;
        this._blnPropertyPage = bl;
        this._initDBSizeMap = map;
        this._ignoreDevList = vector2;
    }

    @Override
    public String getHelpID() {
        return "HELP_DATABASE_DLG_ADD_DEVICE_SIZE_1252";
    }

    @Override
    public void init() throws SQLException {
        if (this._databaseSO instanceof ArchiveDBSO) {
            this._go.dataRadioButton.setVisible(false);
            this._go.logRadioButton.setVisible(false);
            this._go.deviceTypeLabel.setVisible(false);
        }
        Vector<DatabaseDeviceSO> vector = new Vector<DatabaseDeviceSO>();
        for (int i = 0; i < this._vDeviceSOs.size(); ++i) {
            DatabaseDeviceSO databaseDeviceSO = (DatabaseDeviceSO)this._vDeviceSOs.elementAt(i);
            ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)DatabaseDeviceBO.DATABASE_DEVICE_ICON, databaseDeviceSO.getName());
            double d = 0.0;
            try {
                d = Double.parseDouble((String)this._initDBSizeMap.get(aSAIconTextData.text));
            }
            catch (Exception exception) {
                d = 0.0;
            }
            double d2 = Double.parseDouble(databaseDeviceSO.getUnusedSize()) - (double)this.checkUsedSpace(aSAIconTextData.text) + d;
            if (d2 == 0.0) {
                vector.add(databaseDeviceSO);
                continue;
            }
            this._go.devicesMultiList.addRow(new Object[]{aSAIconTextData, Double.valueOf(databaseDeviceSO.getSize()), d2});
        }
        this._vDeviceSOs.removeAll(vector);
        this._go.devicesMultiList.setInitialColumnWidths();
        this.SetDefaltSizeToSpinBox();
        this.enableOkButton(false);
    }

    private void SetDefaltSizeToSpinBox() throws SQLException {
        long l;
        long l2 = 0L;
        long l3 = this._databaseSO.getModelDBSize();
        l2 = l3 > (l = this._databaseSO.getDefaultDBSize()) ? l3 : l;
        this._go.sizeSpinBox.setValue(l2);
    }

    public long getDeviceSize() {
        return this._go.sizeSpinBox.getValue();
    }

    public String getDeviceType() {
        if (this._go.dataRadioButton.isSelected()) {
            return ASEUtils.getString("MSG_DATA");
        }
        return ASEUtils.getString("MSG_LOG");
    }

    public void textValueChanged() {
        boolean bl = this._go.sizeSpinBox.getValue() > 0L;
        this.enableOkButton(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this._go.devicesMultiList.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            String string = this._go.devicesMultiList.getValueAt(nArray[i], 0).toString();
            ServerBO serverBO = ContainerViewBO.getServerBO(this._databaseSO.getConnection());
            ContainerViewBO.openDatabaseDeviceProperties(serverBO, string);
        }
    }

    public void modifyTableVector(long l, int n) {
        Vector vector = (Vector)this._tableModel.getData().elementAt(n);
        long l2 = ((Double)vector.elementAt(1)).longValue();
        long l3 = l2 + l;
        vector.setElementAt(new Double(l3), 1);
    }

    public int checkIfDevExist(String string, String string2) {
        Vector vector = this._tableModel.getData();
        String string3 = "";
        boolean bl = this._databaseSO instanceof ArchiveDBSO;
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            string3 = ((JLabel)vector2.elementAt(0)).getText();
            if (bl) {
                if (!string3.equals(string)) continue;
                return i;
            }
            String string4 = (String)vector2.elementAt(2);
            if (!string3.equals(string) || !string4.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    private long checkUsedSpace(String string) {
        Vector vector = this._tableModel.getData();
        String string2 = "";
        long l = 0L;
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            string2 = ((JLabel)vector2.elementAt(0)).getText();
            if (!string2.equals(string)) continue;
            l += ((Double)vector2.elementAt(1)).longValue();
        }
        return l;
    }

    public boolean onOk() {
        int[] nArray = this._go.devicesMultiList.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            Accessible accessible;
            Object[] objectArray;
            int n = nArray[i];
            DatabaseDeviceSO databaseDeviceSO = (DatabaseDeviceSO)this._vDeviceSOs.elementAt(n);
            String string = databaseDeviceSO.getName();
            long l = this.getDeviceSize();
            String string2 = this.getDeviceType();
            int n2 = this.checkIfDevExist(string, string2);
            if (n2 >= 0) {
                if (this._blnPropertyPage) {
                    Support.showError(this._databaseSO.getConnection(), this.getClass(), this.getJDialog(), ASEUtils.getString("DEVICE_ALREADY_EXIST"));
                    return false;
                }
                this.modifyTableVector(l, n2);
                continue;
            }
            ServerSO serverSO = (ServerSO)ContainerViewBO.getServerBO(databaseDeviceSO.getConnection()).getSO();
            if (databaseDeviceSO.getConnection().isCluster() && !this._ignoreDevList.contains(databaseDeviceSO.getPhysicalName()) && serverSO.isUAFMonitored()) {
                if (ProfileHelper.getCheckVCSEnabled() && serverSO.isVCSMode()) {
                    objectArray = new CheckVCSStatusTask(databaseDeviceSO, databaseDeviceSO.getPhysicalName());
                    accessible = new WorkingDialog((Frame)Support.getViewerFrame(), (Runnable)objectArray, ASEUtils.getString("CLUSTER_TITLE_RETRIEVE_DEVICE_INFO"), ASEUtils.getString("CLUSTER_MSG_RETRIEVE_DEVICE_INFO"));
                    ((Window)accessible).dispose();
                    Boolean bl = objectArray.getResult();
                    if (null != bl && !bl.booleanValue()) {
                        String string3 = ASEUtils.getString("ERR_CLUSTER_WIZ_INVALID_STORAGE");
                        if (0 != Support.showQuestionYesNo(string3 + ASEUtils.getString("SDC_IOFENCING_CONFIRM"))) {
                            return false;
                        }
                        this._ignoreDevList.add(databaseDeviceSO.getPhysicalName());
                    }
                } else if (ProfileHelper.getCheckIOFencingEnabled() && !serverSO.isVCSMode() && null != (objectArray = databaseDeviceSO.getIOFencingCheckResult(databaseDeviceSO.getPhysicalName()))[0] && ((Boolean)objectArray[0]).booleanValue()) {
                    if (0 != Support.showQuestionYesNo((String)objectArray[1] + ASEUtils.getString("SDC_IOFENCING_CONFIRM"))) {
                        return false;
                    }
                    this._ignoreDevList.add(databaseDeviceSO.getPhysicalName());
                }
            }
            objectArray = new Vector<Serializable>();
            accessible = new ImageIcon(ASEImages.getDeviceSmallImage());
            objectArray.addElement(new JLabel(string, (Icon)((Object)accessible), 0));
            objectArray.addElement(new Double(l));
            objectArray.addElement(string2);
            objectArray.addElement(new Integer(n));
            this._tableModel.addRow((Vector)objectArray);
        }
        this._table.tableChanged(new TableModelEvent(this._tableModel));
        return true;
    }

    @Override
    public void valueChanged(ASELongSpinBoxChangeEvent aSELongSpinBoxChangeEvent) {
        this.enableOkButton(this._go.sizeSpinBox.getValue() > 0L);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        boolean bl = this._go.devicesMultiList.getSelectedRowCount() > 0;
        this._go.sizeSpinBox.setEnabled(bl);
        int n = Integer.MAX_VALUE;
        int[] nArray = this._go.devicesMultiList.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            Double d = (Double)this._go.devicesMultiList.getValueAt(nArray[i], 2);
            int n2 = d.intValue();
            n = n2 <= n ? n2 : n;
        }
        this._go.sizeSpinBox.setMinimum(1L);
        this._go.sizeSpinBox.setMaximum(n);
        try {
            this.SetDefaltSizeToSpinBox();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.enableOkButton(bl && this._go.sizeSpinBox.getValue() > 0L);
    }
}

