/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEDialogController;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.go.dlg.AuthenticateDlgGOPage;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import com.sybase.ua.AuthenticationException;
import java.awt.Container;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AuthenticateDialog
extends ASEDialogController {
    public static final boolean CLOSE_STATE_CANCEL = false;
    public static final boolean CLOSE_STATE_OK = true;
    private SCDialogSupport _ds;
    private AuthenticateDialogPage _page;
    private boolean _closeState = false;
    private ServerSO _serverSO;

    public static AuthenticateDialog showDialog(Container container, ServerSO serverSO, boolean bl, boolean bl2) {
        SCDialogSupport sCDialogSupport = Support.createDialogSupport(container);
        AuthenticateDialog authenticateDialog = new AuthenticateDialog(sCDialogSupport, serverSO, bl, bl2);
        sCDialogSupport.setDialogController((SCDialogController)authenticateDialog);
        String string = ASEUtils.getString("SERVER_PROP_BTTN_AUTHENTICATE");
        sCDialogSupport.setTitle(string);
        sCDialogSupport.setResizable(true);
        sCDialogSupport.setModal(true);
        sCDialogSupport.render();
        return authenticateDialog;
    }

    AuthenticateDialog(SCDialogSupport sCDialogSupport, ServerSO serverSO, boolean bl, boolean bl2) {
        super(sCDialogSupport, new SCPageController[1]);
        this._ds = sCDialogSupport;
        this._serverSO = serverSO;
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("AUTH_DLG_SENT_INTRO"), this._serverSO.getName());
        this._page = new AuthenticateDialogPage(sCDialogSupport, bl, aSEMessageText.toString(), bl2);
        this._pageControllers[0] = this._page;
    }

    public boolean getCloseState() {
        return this._closeState;
    }

    public String getUserName() {
        return this._page.getUserName();
    }

    public String getPassword() {
        return this._page.getPassword();
    }

    public boolean batchSelected() {
        return this._page.batchSelected();
    }

    class AuthenticateDialogPage
    extends ASEPageController
    implements DocumentListener {
        private AuthenticateDlgGOPage _go;

        AuthenticateDialogPage(SCDialogSupport sCDialogSupport, boolean bl, String string, boolean bl2) {
            super(sCDialogSupport, (JPanel)((Object)new AuthenticateDlgGOPage()));
            this._go = (AuthenticateDlgGOPage)((Object)this.getJPanel());
            this._go.extraMultiLineLabel.setVisible(bl);
            this._go.batchCheckBox.setVisible(bl2);
            this._go.infoMultiLineLabel.setText(string);
            this._go.userNameTextField.getDocument().addDocumentListener(this);
            this._go.passwordField.getDocument().addDocumentListener(this);
        }

        @Override
        public String getHelpID() {
            return "HELP_ASEP_DLG_AUTHENTICATE_15";
        }

        @Override
        public void init() {
            this.enableOKButton();
        }

        public void textValueChanged() {
            this.enableOKButton();
        }

        private void enableOKButton() {
            AuthenticateDialog.this._ds.getStandardButtonById(1).setEnabled(this._go.userNameTextField.getText().length() > 0);
        }

        public void selectUser() {
            this._go.userNameTextField.requestFocus();
            this._go.userNameTextField.selectAll();
        }

        String getUserName() {
            return this._go.userNameTextField.getText();
        }

        String getPassword() {
            return new String(this._go.passwordField.getPassword());
        }

        boolean batchSelected() {
            return this._go.batchCheckBox.isSelected();
        }

        private boolean doAuthenticate() {
            boolean bl = false;
            String string = this.getUserName();
            String string2 = this.getPassword();
            String string3 = null;
            Throwable throwable = null;
            try {
                AuthenticateDialog.this._serverSO.authenticate(string, string2);
                bl = true;
            }
            catch (AuthenticationException authenticationException) {
                throwable = authenticationException;
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_FAILED_TO_AUTHENTICATE"), string, AuthenticateDialog.this._serverSO.getName());
                string3 = aSEMessageText.toString();
            }
            catch (Exception exception) {
                throwable = exception;
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_FAILED_TO_CONNECT_AGENT"), AuthenticateDialog.this._serverSO.getName());
                string3 = aSEMessageText.toString();
            }
            if (string3 != null) {
                Support.showDetailsError(AuthenticateDialog.this._serverSO.getConnection(), this.getClass(), (Container)this.getJDialog(), string3, throwable);
                this.selectUser();
            }
            return bl;
        }

        public boolean onCancel() {
            AuthenticateDialog.this._closeState = false;
            AuthenticateDialog.this._ds.closeDialog(false);
            return true;
        }

        public boolean onOk() {
            if (this.doAuthenticate()) {
                AuthenticateDialog.this._closeState = true;
                AuthenticateDialog.this._ds.closeDialog(true);
                return true;
            }
            return false;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.textValueChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.textValueChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.textValueChanged();
        }
    }
}

