/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.ProceduresCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.bo.wiz.StoredProcedureWizard;
import com.sybase.aseplugin.go.ASETable;
import com.sybase.aseplugin.go.dlg.AddThresholdDlgGOPage;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.SegmentSO;
import com.sybase.aseplugin.so.StoredProcedureSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.util.ui.JLabelTableModel;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.central.SCDialogSupport;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class AvailableThresholdsDialogBOPage
extends ASEPageController
implements ActionListener,
DocumentListener,
ListSelectionListener {
    private JLabelTableModel _tableModel;
    private JTable _table;
    private double _size;
    private SegmentSO _so;
    private Vector _dialogVector;
    private AddThresholdDlgGOPage _go;
    private DatabaseBO _dbbo;

    public AvailableThresholdsDialogBOPage(SCDialogSupport sCDialogSupport, SegmentSO segmentSO, Vector vector, DatabaseBO databaseBO) {
        super(sCDialogSupport, (JPanel)((Object)new AddThresholdDlgGOPage()));
        this._so = segmentSO;
        this._go = (AddThresholdDlgGOPage)((Object)this.getJPanel());
        this._dialogVector = vector;
        this._dbbo = databaseBO;
        Support.fillUnitList((JComboBox)this._go.unitComboBox);
        this._go.unitComboBox.setSelectedIndex(2);
        this._go.unitComboBox.addActionListener((ActionListener)this);
        this._go.freeSpaceTextField.setText("0");
        this._go.freeSpaceTextField.selectAll();
        this._go.freeSpaceTextField.getDocument().addDocumentListener(this);
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(ASEUtils.getString("MSG_PROC_TYPE"));
        vector2.addElement(ASEUtils.getString("DISP_CREATOR_TEXT"));
        this._tableModel = new JLabelTableModel(vector2, this._dialogVector);
        this._table = new ASETable(this._tableModel);
        this._table.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
        this._table.setSelectionMode(0);
        this._go.proceduresScrollPane.getViewport().add(this._table);
        this._table.getSelectionModel().addListSelectionListener(this);
        this._go.addStoredProcedureButton.addActionListener((ActionListener)this);
    }

    @Override
    public String getHelpID() {
        return "HELP_SEGMENT_DLG_ADD_NEW_THRESHOLD_1252";
    }

    @Override
    public void init() {
        this.enableOK();
    }

    public double getThresholdSize() {
        return this._size;
    }

    public int getThresholdType() {
        return this._go.unitComboBox.getSelectedIndex();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    public void textValueChanged() {
        int n = this._go.unitComboBox.getSelectedIndex();
        double d = 0.0;
        try {
            d = Double.valueOf(this._go.freeSpaceTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n == 0) {
            this._size = Utility.getPrecision(this._so.pageToKB(d), 4);
        } else if (n == 1) {
            this._size = d;
        } else if (n == 2) {
            this._size = Utility.getMBToKB(d);
        } else if (n == 3) {
            this._size = Utility.getGBToKB(d);
        }
        this.enableOK();
    }

    private void enableOK() {
        int[] nArray = this._table.getSelectedRows();
        this.enableOkButton(nArray.length > 0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._go.addStoredProcedureButton) {
            this.addStoredProcedureByWizard();
        } else if (actionEvent.getSource() == this._go.unitComboBox) {
            int n = this._go.unitComboBox.getSelectedIndex();
            if (n == 0) {
                double d = Utility.getPrecision(this._so.KBToPage(this._size), 2);
                this._go.freeSpaceTextField.setText(String.valueOf(d));
            } else if (n == 1) {
                double d = Utility.getPrecision(this._size, 3);
                this._go.freeSpaceTextField.setText(String.valueOf(d));
            } else if (n == 2) {
                double d = Utility.getPrecision(Utility.getKBToMB(this._size), 6);
                this._go.freeSpaceTextField.setText(String.valueOf(d));
            } else if (n == 3) {
                double d = Utility.getPrecision(Utility.getKBToGB(this._size), 6);
                this._go.freeSpaceTextField.setText(String.valueOf(d));
            }
        }
    }

    public int[] getSelected() {
        return this._table.getSelectedRows();
    }

    public int getCurrentStoredProceduresCount() {
        return this._table.getRowCount();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableOK();
    }

    private void addStoredProcedureByWizard() {
        DatabaseSO databaseSO = (DatabaseSO)this._dbbo.getSO();
        ASConnection aSConnection = databaseSO.getConnection();
        StoredProcedureSO storedProcedureSO = new StoredProcedureSO(aSConnection, "", databaseSO);
        ProceduresCtrBO proceduresCtrBO = (ProceduresCtrBO)this._dbbo.getItem(ASEUtils.getString("DNAME_PROCEDURE"));
        StoredProcedureWizard storedProcedureWizard = new StoredProcedureWizard(storedProcedureSO, proceduresCtrBO);
        boolean bl = ASEBaseDialog2.showDialog(Support.getViewerFrame(), storedProcedureWizard, true);
        if (bl) {
            try {
                this._dialogVector = this._so.initDialog();
                this._tableModel.setData(this._dialogVector);
                this._table.setModel(this._tableModel);
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(aSConnection, this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            }
        }
    }
}

