/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.go.dlg.LoginPasswordChangeDlgGOPage;
import com.sybase.aseplugin.so.LoginSO;
import com.sybase.central.SCDialogSupport;
import java.sql.SQLException;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class ChangePasswordDialogPage
extends ASEPageController
implements DocumentListener {
    int _minLoginPasswordLength;
    private LoginPasswordChangeDlgGOPage _go = (LoginPasswordChangeDlgGOPage)((Object)this.getJPanel());
    private LoginSO _loginSO;

    public ChangePasswordDialogPage(SCDialogSupport sCDialogSupport, LoginSO loginSO, int n) {
        super(sCDialogSupport, (JPanel)((Object)new LoginPasswordChangeDlgGOPage()));
        this._go.passwordMultiLineLabel.setText(new ASEMessageText(ASEUtils.getString("CHANGE_PW_DLG_SENT_PASSWORD"), loginSO.getName()).toString());
        this._minLoginPasswordLength = n;
        this._go.yourPasswordField.getDocument().addDocumentListener(this);
        this._go.newPasswordField.getDocument().addDocumentListener(this);
        this._go.confirmPasswordField.getDocument().addDocumentListener(this);
        this._loginSO = loginSO;
    }

    @Override
    public String getHelpID() {
        return "HELP_LOGIN_DLG_CHANGE_PASSWORD_1252";
    }

    @Override
    public void init() {
        String string = "";
        if (this._minLoginPasswordLength > -1) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("LOGIN_PASSWORD_LENGTH"), String.valueOf(this._minLoginPasswordLength));
            string = aSEMessageText.toString();
        }
        this._go.lengthLabel.setText(string);
        this.textValueChanged();
    }

    public void textValueChanged() {
        boolean bl = this.getOrigPassword().equals(this._loginSO.getConnection().getPassword());
        String string = this.getLoginPassword();
        boolean bl2 = string.length() >= this._minLoginPasswordLength;
        boolean bl3 = string.equals(this.getConfirmPassword());
        this.enableOkButton(bl && bl3 && bl2);
    }

    public String getOrigPassword() {
        return new String(this._go.yourPasswordField.getPassword());
    }

    public String getLoginPassword() {
        return new String(this._go.newPasswordField.getPassword());
    }

    public String getConfirmPassword() {
        return new String(this._go.confirmPasswordField.getPassword());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    public boolean onOk() {
        boolean bl = false;
        try {
            this._loginSO.changePassword(this.getOrigPassword(), this.getLoginPassword());
            this._loginSO.setPassword(this.getLoginPassword());
            bl = true;
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this._loginSO.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            bl = false;
        }
        return bl;
    }
}

