/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASAListCheckEvent;
import com.sybase.asa.ASAListCheckListener;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ColumnBO;
import com.sybase.aseplugin.bo.DefaultBO;
import com.sybase.aseplugin.bo.ESPBO;
import com.sybase.aseplugin.bo.EncryptionKeyBO;
import com.sybase.aseplugin.bo.ForeignKeyBO;
import com.sybase.aseplugin.bo.FunctionBO;
import com.sybase.aseplugin.bo.GroupBO;
import com.sybase.aseplugin.bo.IndexBO;
import com.sybase.aseplugin.bo.RuleBO;
import com.sybase.aseplugin.bo.SQLJFunctionBO;
import com.sybase.aseplugin.bo.SegmentBO;
import com.sybase.aseplugin.bo.StoredProcedureBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.SybDDLGenerator;
import com.sybase.aseplugin.bo.TableBO;
import com.sybase.aseplugin.bo.TriggerBO;
import com.sybase.aseplugin.bo.UserBO;
import com.sybase.aseplugin.bo.UserTypeBO;
import com.sybase.aseplugin.bo.ViewBO;
import com.sybase.aseplugin.bo.dlg.ASEDialogController;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.go.dlg.DDLObjectFilterDlgGOPage;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JPanel;

public class DDLObjectFilterDialog
extends ASEDialogController {
    private String _helpID;

    public static boolean render(Container container, String[] stringArray, char c, ASConnection aSConnection, String string) {
        SCDialogSupport sCDialogSupport = Support.createDialogSupport(container);
        DDLObjectFilterDialog dDLObjectFilterDialog = new DDLObjectFilterDialog(sCDialogSupport, stringArray, c, aSConnection, string);
        sCDialogSupport.setDialogController((SCDialogController)dDLObjectFilterDialog);
        sCDialogSupport.setTitle(ASEUtils.getString("DB_OBJECTS_FILTER_DLG_TITLE"));
        sCDialogSupport.setResizable(true);
        sCDialogSupport.setModal(true);
        return sCDialogSupport.render();
    }

    private DDLObjectFilterDialog(SCDialogSupport sCDialogSupport, String[] stringArray, char c, ASConnection aSConnection, String string) {
        super(sCDialogSupport, new SCPageController[1]);
        this._helpID = string;
        this._pageControllers[0] = new DDLObjectFilterDialogPage(sCDialogSupport, stringArray, c, aSConnection);
    }

    class DDLObjectFilterDialogPage
    extends ASEPageController
    implements ActionListener,
    ASAListCheckListener {
        private DDLObjectFilterDlgGOPage _go;
        private String[] _saNames;
        private char _cType;
        private ASConnection _con;
        private boolean _isEncryptionKeyEnabled;
        private boolean _filterEncryptionKey;
        private boolean _hasInsteadOfTriggers;
        private boolean _hasScalarFunctions;
        private boolean _hasTableFunctions;
        private int _dbObjectFilterCount;
        private int _tableObjectFilterCount;

        public DDLObjectFilterDialogPage(SCDialogSupport sCDialogSupport, String[] stringArray, char c, ASConnection aSConnection) {
            super(sCDialogSupport, (JPanel)((Object)new DDLObjectFilterDlgGOPage(c)));
            this._dbObjectFilterCount = 0;
            this._tableObjectFilterCount = 0;
            this._go = (DDLObjectFilterDlgGOPage)((Object)this.getJPanel());
            this._saNames = stringArray;
            this._cType = c;
            this._con = aSConnection;
            this._isEncryptionKeyEnabled = aSConnection.isEncryptedKeyEnabled();
            this._hasScalarFunctions = this._hasInsteadOfTriggers = this._con.getVersion().compareTo("15.0.2") >= 0;
            this._hasTableFunctions = this._con.getVersion().compareTo("15.0.3") >= 0;
        }

        @Override
        public String getHelpID() {
            return DDLObjectFilterDialog.this._helpID;
        }

        @Override
        public void init() {
            this._go.clearAllButton.addActionListener((ActionListener)this);
            this._go.selectAllButton.addActionListener((ActionListener)this);
            this._go.objectsMultiCheckList.addListCheckListener((ASAListCheckListener)this);
            this._go.objectsMultiCheckList.clear();
            if (this._cType == 'D') {
                this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)DefaultBO.DEFAULT_ICON, ASEUtils.getString("DNAME_DEFAULTS"))});
                if (this._isEncryptionKeyEnabled) {
                    if (this._con.hasSARole() || this._con.hasSSORole()) {
                        this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)EncryptionKeyBO.KEY_ICON, ASEUtils.getString("DNAME_ENCRYPTION_KEY"))});
                    } else {
                        this._filterEncryptionKey = true;
                        this._go.messagePanel.setVisible(true);
                    }
                }
                this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)ESPBO.ESP_ICON, ASEUtils.getString("DNAME_ESPS"))});
                this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)GroupBO.GROUP_ICON, ASEUtils.getString("DNAME_GROUPS"))});
                this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)RuleBO.RULE_ICON, ASEUtils.getString("DNAME_RULES"))});
                this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)SegmentBO.SEGMENT_ICON, ASEUtils.getString("DNAME_SEGMENTS"))});
                this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)StoredProcedureBO.PROC_ICON, ASEUtils.getString("DNAME_PROCEDURES"))});
                this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)SQLJFunctionBO.SQLJ_FUNCTION_ICON, ASEUtils.getString("DNAME_SQLJ_FUNCTIONS"))});
                if (this._hasScalarFunctions) {
                    this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)FunctionBO.FUNCTION_ICON, this._hasTableFunctions ? ASEUtils.getString("DNAME_SQL_FUNCTIONS") : ASEUtils.getString("DNAME_SCALAR_FUNCTIONS"))});
                }
                this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)UserBO.USER_ICON, ASEUtils.getString("DNAME_USERS"))});
                this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)UserTypeBO.UDT_ICON, ASEUtils.getString("DNAME_USERTYPES"))});
                this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)ViewBO.VIEW_ICON, ASEUtils.getString("DNAME_VIEWS"))});
                this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)TableBO.TABLE_ICON, ASEUtils.getString("DNAME_TABLES"))});
            }
            this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)ForeignKeyBO.FOREIGN_KEY_ICON, ASEUtils.getString("DNAME_FKEYS"))});
            ++this._tableObjectFilterCount;
            this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)IndexBO.INDEX_ICON, ASEUtils.getString("DNAME_INDEXES"))});
            ++this._tableObjectFilterCount;
            this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)ColumnBO.ICON_PRIMARY_KEY_COLUMN, ASEUtils.getString("DNAME_PRIMARY_AND_UNIQUE_CONSTRAINTS"))});
            ++this._tableObjectFilterCount;
            this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)TriggerBO.TRIGGER_ICON, ASEUtils.getString("DNAME_TRIGGERS"))});
            ++this._tableObjectFilterCount;
            if (this._con.isPartitionsApplicable()) {
                this._go.objectsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)IndexBO.INDEX_ICON, ASEUtils.getString("DNAME_DATA_PARTTIONS"))});
                ++this._tableObjectFilterCount;
            }
            this._dbObjectFilterCount = this._go.objectsMultiCheckList.getRowCount();
            this._go.objectsMultiCheckList.checkAllRows();
            this._go.objectsMultiCheckList.setSorting(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.clearAllButton) {
                this._go.objectsMultiCheckList.uncheckAllRows();
            } else if (actionEvent.getSource() == this._go.selectAllButton) {
                this._go.objectsMultiCheckList.checkAllRows();
            }
        }

        public boolean onOk() {
            StringBuffer stringBuffer = null;
            int n = this._cType == 'D' ? this._dbObjectFilterCount : this._tableObjectFilterCount;
            int[] nArray = this._go.objectsMultiCheckList.getUncheckedRows();
            int n2 = nArray.length;
            if (n2 == 0 && !this._filterEncryptionKey) {
                stringBuffer = null;
            } else if (n2 == n) {
                stringBuffer = new StringBuffer("-F%");
            } else {
                stringBuffer = new StringBuffer("-F");
                if (this._filterEncryptionKey) {
                    stringBuffer.append("EK,");
                }
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer.append(this.getDDLGenType(this._go.objectsMultiCheckList.getStringAt(nArray[i], 0)) + ",");
                }
                stringBuffer = new StringBuffer(stringBuffer.substring(0, stringBuffer.length() - 1));
            }
            this.generateDDL(stringBuffer == null ? null : stringBuffer.toString());
            return super.onOk();
        }

        private String getDDLGenType(String string) {
            if (string.equals(ASEUtils.getString("DNAME_DEFAULTS"))) {
                return "D";
            }
            if (string.equals(ASEUtils.getString("DNAME_ESPS"))) {
                return "XP";
            }
            if (string.equals(ASEUtils.getString("DNAME_GROUPS"))) {
                return "GRP";
            }
            if (string.equals(ASEUtils.getString("DNAME_RULES"))) {
                return "R";
            }
            if (string.equals(ASEUtils.getString("DNAME_SEGMENTS"))) {
                return "SGM";
            }
            if (string.equals(ASEUtils.getString("DNAME_STORED_PROCEDURES"))) {
                return "P";
            }
            if (string.equals(ASEUtils.getString("DNAME_USERS"))) {
                return "USR";
            }
            if (string.equals(ASEUtils.getString("DNAME_USERTYPES"))) {
                return "UDD";
            }
            if (string.equals(ASEUtils.getString("DNAME_VIEWS"))) {
                return "V";
            }
            if (string.equals(ASEUtils.getString("DNAME_TABLES"))) {
                return "U";
            }
            if (string.equals(ASEUtils.getString("DNAME_FKEYS"))) {
                return "RI";
            }
            if (string.equals(ASEUtils.getString("DNAME_INDEXES"))) {
                return "I";
            }
            if (string.equals(ASEUtils.getString("DNAME_PRIMARY_AND_UNIQUE_CONSTRAINTS"))) {
                return "KC";
            }
            if (string.equals(ASEUtils.getString("DNAME_TRIGGERS"))) {
                return "TR";
            }
            if (string.equals(ASEUtils.getString("DNAME_DATA_PARTTIONS"))) {
                return "PC";
            }
            if (string.equals(ASEUtils.getString("DNAME_SQLJ_FUNCTIONS"))) {
                return "F";
            }
            if (string.equals(ASEUtils.getString("DNAME_SCALAR_FUNCTIONS")) || string.equals(ASEUtils.getString("DNAME_SQL_FUNCTIONS"))) {
                return "SF";
            }
            if (string.equals(ASEUtils.getString("DNAME_ENCRYPTION_KEY"))) {
                return "EK";
            }
            return null;
        }

        public void valueChanged(ASAListCheckEvent aSAListCheckEvent) {
            boolean bl;
            if (this._cType != 'D') {
                return;
            }
            this._go.objectsMultiCheckList.removeListCheckListener((ASAListCheckListener)this);
            int n = this._go.objectsMultiCheckList.findRow(ASEUtils.getString("DNAME_TABLES"));
            int n2 = this._go.objectsMultiCheckList.findRow(ASEUtils.getString("DNAME_INDEXES"));
            int n3 = this._go.objectsMultiCheckList.findRow(ASEUtils.getString("DNAME_FKEYS"));
            int n4 = this._go.objectsMultiCheckList.findRow(ASEUtils.getString("DNAME_PRIMARY_AND_UNIQUE_CONSTRAINTS"));
            int n5 = this._go.objectsMultiCheckList.findRow(ASEUtils.getString("DNAME_TRIGGERS"));
            int n6 = 0;
            if (this._con.isPartitionsApplicable()) {
                n6 = this._go.objectsMultiCheckList.findRow(ASEUtils.getString("DNAME_DATA_PARTTIONS"));
            }
            boolean bl2 = this._go.objectsMultiCheckList.isRowChecked(n);
            this._go.objectsMultiCheckList.setRowEnabled(n2, bl2);
            this._go.objectsMultiCheckList.setRowEnabled(n3, bl2);
            this._go.objectsMultiCheckList.setRowEnabled(n4, bl2);
            this._go.objectsMultiCheckList.setRowEnabled(n5, bl2);
            if (n6 != 0) {
                this._go.objectsMultiCheckList.setRowEnabled(n6, bl2);
            }
            boolean bl3 = bl = aSAListCheckEvent.getFirstIndex() == n;
            if (bl) {
                this._go.objectsMultiCheckList.setRowChecked(n2, bl2);
                this._go.objectsMultiCheckList.setRowChecked(n3, bl2);
                this._go.objectsMultiCheckList.setRowChecked(n4, bl2);
                this._go.objectsMultiCheckList.setRowChecked(n5, bl2);
                if (n6 != 0) {
                    this._go.objectsMultiCheckList.setRowChecked(n6, bl2);
                }
            }
            this._go.objectsMultiCheckList.addListCheckListener((ASAListCheckListener)this);
        }

        private void generateDDL(String string) {
            for (int i = 0; i < this._saNames.length; ++i) {
                String[] stringArray;
                String string2 = this._con.getCharacterSet();
                if (string2 != null) {
                    if (string != null) {
                        stringArray = new String[7];
                        stringArray[6] = string;
                    } else {
                        stringArray = new String[6];
                    }
                    stringArray[5] = "-J" + string2;
                } else if (string != null) {
                    stringArray = new String[6];
                    stringArray[5] = string;
                } else {
                    stringArray = new String[]{"-U" + this._con.getCurrentUser(), "-P" + this._con.getPassword(), "-S" + this._con.getHostName() + ":" + this._con.getPortNumber(), "-T" + (this._cType == 'D' ? "DB" : "U"), "-N" + this._saNames[i]};
                }
                SybDDLGenerator.setStoreToFile(false);
                SybDDLGenerator.generateDDL(stringArray, this._con);
            }
        }
    }
}

