/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.DumpDeviceBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEDialogController;
import com.sybase.aseplugin.bo.dlg.ASEDocPageController;
import com.sybase.aseplugin.go.dlg.DumpDeviceSelectionDlgGOPage;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.util.ui.JLabelTableModel;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TableModelEvent;

public class DumpDeviceChoiceDialog
extends ASEDialogController {
    private int _pageSizeBytes;
    private Vector _dumpDeviceVector;
    private Vector _removebackupServerVector;
    private JLabelTableModel _tableModel;
    private JTable _table;
    private boolean _isBackup;

    DumpDeviceChoiceDialog(SCDialogSupport sCDialogSupport, Vector vector, Vector vector2, int n, JLabelTableModel jLabelTableModel, JTable jTable, boolean bl) {
        super(sCDialogSupport, new SCPageController[1]);
        this._dumpDeviceVector = vector;
        this._removebackupServerVector = vector2;
        this._pageSizeBytes = n;
        this._tableModel = jLabelTableModel;
        this._table = jTable;
        this._isBackup = bl;
        this._pageControllers[0] = new DumpDeviceChoiceDialogBOPage(sCDialogSupport);
    }

    public static boolean showDialog(Container container, Vector vector, Vector vector2, int n, JLabelTableModel jLabelTableModel, JTable jTable, boolean bl) {
        SCDialogSupport sCDialogSupport = Support.createDialogSupport(container);
        DumpDeviceChoiceDialog dumpDeviceChoiceDialog = new DumpDeviceChoiceDialog(sCDialogSupport, vector, vector2, n, jLabelTableModel, jTable, bl);
        sCDialogSupport.setDialogController((SCDialogController)dumpDeviceChoiceDialog);
        sCDialogSupport.setTitle(ASEUtils.getString("SELECT_DUMP_DEVICE"));
        sCDialogSupport.setResizable(true);
        sCDialogSupport.setModal(true);
        return sCDialogSupport.render();
    }

    class DumpDeviceChoiceDialogBOPage
    extends ASEDocPageController
    implements ActionListener {
        private DumpDeviceSelectionDlgGOPage _go;

        public DumpDeviceChoiceDialogBOPage(SCDialogSupport sCDialogSupport) {
            super(sCDialogSupport, (JPanel)((Object)new DumpDeviceSelectionDlgGOPage()));
            this._go = (DumpDeviceSelectionDlgGOPage)((Object)this.getJPanel());
            this._go.namedDumpDeviceComboBox.setRenderer((ListCellRenderer)new MyCellRenderer());
            this._go.namedDumpDeviceRadioButton.addActionListener((ActionListener)this);
            this._go.namedDumpDeviceComboBox.addActionListener((ActionListener)this);
            this._go.explicitDumpDeviceRadioButton.addActionListener((ActionListener)this);
            this._go.physicalPathTextField.getDocument().addDocumentListener(this);
            this._go.remoteBackupCheckBox.addActionListener((ActionListener)this);
            this._go.remoteBackupComboBox.addActionListener((ActionListener)this);
        }

        @Override
        public String getHelpID() {
            return "HELP_DATABASE_DLG_SELECT_DUMP_DEVICES_1252";
        }

        @Override
        public void init() {
            int n;
            for (n = 0; n < DumpDeviceChoiceDialog.this._dumpDeviceVector.size(); ++n) {
                this._go.namedDumpDeviceComboBox.addItem(DumpDeviceChoiceDialog.this._dumpDeviceVector.elementAt(n));
            }
            for (n = 0; n < DumpDeviceChoiceDialog.this._removebackupServerVector.size(); ++n) {
                this._go.remoteBackupComboBox.addItem(DumpDeviceChoiceDialog.this._removebackupServerVector.elementAt(n));
            }
            this._go.physicalPathLabel.setEnabled(false);
            this._go.physicalPathTextField.setEnabled(false);
            this._go.remoteBackupCheckBox.setEnabled(false);
            this._go.remoteBackupComboBox.setEnabled(false);
        }

        @Override
        public void enableComponents() {
            boolean bl = this.isNamedDumpDeviceSelected() && this._go.namedDumpDeviceComboBox.getSelectedItem() != null;
            boolean bl2 = this.isExplicitDumpDeviceSelected() && !this.getPhysicalPath().isEmpty();
            this.setOkButtonEnabled(bl || bl2);
        }

        public boolean onOk() {
            if (DumpDeviceChoiceDialog.this._isBackup) {
                int n;
                int n2;
                if (this._go.blockSizeTextField.getText().length() > 0 && (n2 = (n = Integer.parseInt(this._go.blockSizeTextField.getText())) / DumpDeviceChoiceDialog.this._pageSizeBytes) < 1) {
                    Support.showError(null, this.getClass(), this.getJDialog(), ASEUtils.getString("ERR_TAPE_BLOCK_SIZE"));
                    return false;
                }
                if (this._go.explicitDumpDeviceRadioButton.isSelected() && this._go.physicalPathTextField.getText().length() == 0) {
                    Support.showError(null, this.getClass(), this.getJDialog(), ASEUtils.getString("ERR_FILL_PHYSICAL_PATH"));
                    return false;
                }
            }
            DumpDeviceChoiceDialog.this._tableModel.addRow(this.newRow());
            DumpDeviceChoiceDialog.this._table.tableChanged(new TableModelEvent(DumpDeviceChoiceDialog.this._tableModel));
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._go.namedDumpDeviceRadioButton) {
                this._go.namedDumpDeviceComboBox.setEnabled(true);
                this._go.physicalPathLabel.setEnabled(false);
                this._go.physicalPathTextField.setEnabled(false);
                this._go.remoteBackupCheckBox.setEnabled(false);
                this._go.remoteBackupComboBox.setEnabled(false);
            } else if (object == this._go.explicitDumpDeviceRadioButton) {
                this._go.namedDumpDeviceComboBox.setEnabled(false);
                this._go.physicalPathLabel.setEnabled(true);
                this._go.physicalPathTextField.setEnabled(true);
                this._go.physicalPathTextField.requestFocus();
                this._go.physicalPathTextField.selectAll();
                this._go.remoteBackupCheckBox.setEnabled(true);
            } else if (object == this._go.remoteBackupCheckBox) {
                this._go.remoteBackupComboBox.setEnabled(this._go.remoteBackupCheckBox.isSelected());
            }
            this.enableComponents();
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        private boolean isNamedDumpDeviceSelected() {
            return this._go.namedDumpDeviceRadioButton.isSelected();
        }

        private boolean isExplicitDumpDeviceSelected() {
            return this._go.explicitDumpDeviceRadioButton.isSelected();
        }

        private String getNamedDumpDevice() {
            return ((JLabel)this._go.namedDumpDeviceComboBox.getSelectedItem()).getText();
        }

        private String getPhysicalPath() {
            return this._go.physicalPathTextField.getText().trim();
        }

        private boolean isRemoteBackupServerSelected() {
            return this._go.remoteBackupCheckBox.isSelected();
        }

        private String getRemoteServer() {
            return (String)this._go.remoteBackupComboBox.getSelectedItem();
        }

        private String getBlockSize() {
            return this._go.blockSizeTextField.getText();
        }

        private String getTapeCapacity() {
            if (this._go.tapeCapacityTextField.getText().length() == 0) {
                return this._go.tapeCapacityTextField.getText();
            }
            double d = Double.valueOf(this._go.tapeCapacityTextField.getText());
            return Integer.toString((int)Utility.getMBToKB(d));
        }

        private String getVolumnName() {
            return this._go.volumnNameTextField.getText();
        }

        Vector newRow() {
            String string = ASEUtils.getString("MSG_YES");
            String string2 = ASEUtils.getString("MSG_NO");
            String string3 = string;
            String string4 = "SYB_BACKUP";
            String string5 = "";
            String string6 = "";
            ImageIcon imageIcon = DumpDeviceBO.DUMP_DEVICE_ICON;
            if (this.isExplicitDumpDeviceSelected()) {
                if (this.getPhysicalPath().length() > 0) {
                    string5 = this.getPhysicalPath();
                }
                if (this.isRemoteBackupServerSelected()) {
                    string4 = this.getRemoteServer();
                }
            } else {
                string4 = this.getNamedDumpDevice();
                string5 = this.getNamedDumpDevice();
            }
            string6 = this.getVolumnName();
            if (this.getBlockSize().length() > 0) {
                int n = Integer.parseInt(this.getBlockSize());
                string3 = string2;
            }
            if (this.getTapeCapacity().length() > 0) {
                string3 = string2;
            }
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(new JLabel(string5, imageIcon, 2));
            vector.addElement(string3);
            vector.addElement(new Boolean(this.isNamedDumpDeviceSelected()));
            vector.addElement(new Boolean(this.isRemoteBackupServerSelected()));
            vector.addElement(string5);
            vector.addElement(string6);
            vector.addElement(this.getBlockSize());
            vector.addElement(this.getTapeCapacity());
            return vector;
        }
    }
}

