/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEDialogController;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.go.dlg.EncryptionPasswordDlgGOPage;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EncryptionPasswordDialog
extends ASEDialogController {
    public EncryptionPasswordDialog(SCDialogSupport sCDialogSupport, DatabaseSO databaseSO, int n, int n2) {
        super(sCDialogSupport, new SCPageController[1]);
        this._pageControllers[0] = new EncryptionPasswordDialogBOPage(sCDialogSupport, this, databaseSO, n, n2);
        sCDialogSupport.setDialogController((SCDialogController)this);
        if (n2 == 0) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("TITLE_CREATE_SYSTEM_ENCRYPTION_KEY"), databaseSO.getName());
            sCDialogSupport.setTitle(aSEMessageText.toString());
        } else if (n2 == 1) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("TITLE_ALTER_SYSTEM_ENCRYPTION_KEY"), databaseSO.getName());
            sCDialogSupport.setTitle(aSEMessageText.toString());
        } else if (n2 == 2) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("TITLE_DELETE_SYSTEM_ENCRYPTION_KEY"), databaseSO.getName());
            sCDialogSupport.setTitle(aSEMessageText.toString());
        }
        sCDialogSupport.setResizable(true);
        sCDialogSupport.setModal(true);
    }

    public void refresh() {
    }

    class EncryptionPasswordDialogBOPage
    extends ASEPageController
    implements DocumentListener {
        private EncryptionPasswordDlgGOPage _go;
        private SCDialogSupport _ds;
        private JButton _okButton;
        private DatabaseSO _dbso;
        int _minLength;
        int _mode;

        public EncryptionPasswordDialogBOPage(SCDialogSupport sCDialogSupport, EncryptionPasswordDialog encryptionPasswordDialog2, DatabaseSO databaseSO, int n, int n2) {
            super(sCDialogSupport, (JPanel)((Object)new EncryptionPasswordDlgGOPage(n2, n)));
            this._go = (EncryptionPasswordDlgGOPage)((Object)this.getJPanel());
            this._minLength = n;
            this._mode = n2;
            this._ds = sCDialogSupport;
            this._dbso = databaseSO;
            this._go.oldPasswordField.getDocument().addDocumentListener(this);
            this._go.newPasswordField.getDocument().addDocumentListener(this);
            this._go.confirmPasswordField.getDocument().addDocumentListener(this);
        }

        @Override
        public String getHelpID() {
            String string = "";
            if (this._mode == 0) {
                string = "HELP_DATABASE_DLG_CREATE_SYSTEM_ENCRYPTION_PASSWORD_1253";
            } else if (this._mode == 1) {
                string = "HELP_DATABASE_DLG_ALTER_SYSTEM_ENCRYPTION_PASSWORD_1253";
            } else if (this._mode == 2) {
                string = "HELP_DATABASE_DLG_DELETE_SYSTEM_ENCRYPTION_PASSWORD_1253";
            }
            return string;
        }

        @Override
        public void init() {
            this._okButton = this._ds.getStandardButtonById(1);
            this._okButton.setEnabled(false);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.textValueChanged(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.textValueChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.textValueChanged(documentEvent);
        }

        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableOkButton(this.testStatus());
        }

        public boolean testStatus() {
            boolean bl = false;
            if (this._mode == 2) {
                return true;
            }
            if (this.getPassword().length() < this._minLength || this.getConfirmPassword().length() < this._minLength) {
                return false;
            }
            return this.getPassword().equals(this.getConfirmPassword());
        }

        public String getOldPassword() {
            return new String(this._go.oldPasswordField.getPassword());
        }

        public String getPassword() {
            return new String(this._go.newPasswordField.getPassword());
        }

        public String getConfirmPassword() {
            return new String(this._go.confirmPasswordField.getPassword());
        }

        public boolean onOk() {
            try {
                if (this._mode == 0) {
                    this._dbso.createSystemEncryptionPassword(this.getPassword());
                } else if (this._mode == 1) {
                    this._dbso.alterSystemEncryptionPassword(this.getPassword(), this.getOldPassword());
                } else {
                    this._dbso.deleteSystemEncryptionPassword(this.getOldPassword());
                }
                return true;
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this._dbso.getConnection(), this.getClass(), ASEMessageText.toString(sQLException), sQLException);
                return false;
            }
        }
    }
}

