/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEProvider;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEDialogController;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.go.dlg.ExportServerGroupsDlgGOPage;
import com.sybase.aseplugin.so.ServerGroupSO;
import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ExportServerGroupsDialog
extends ASEDialogController {
    private ExportServerGroupsPage _page;
    private ServerGroupSO _group;

    public static ExportServerGroupsDialog showDialog(Container container, ServerGroupSO serverGroupSO) {
        SCDialogSupport sCDialogSupport = Support.createDialogSupport(container);
        ExportServerGroupsDialog exportServerGroupsDialog = new ExportServerGroupsDialog(sCDialogSupport, serverGroupSO);
        sCDialogSupport.setDialogController((SCDialogController)exportServerGroupsDialog);
        if (serverGroupSO == null) {
            sCDialogSupport.setTitle(ASEUtils.getString("EXPORT_DLG_TITLE"));
        } else {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("EXPORT_DLG_GROUP_TITLE"), serverGroupSO.getName());
            sCDialogSupport.setTitle(aSEMessageText.toString());
        }
        sCDialogSupport.setResizable(true);
        sCDialogSupport.setModal(true);
        return exportServerGroupsDialog;
    }

    ExportServerGroupsDialog(SCDialogSupport sCDialogSupport, ServerGroupSO serverGroupSO) {
        super(sCDialogSupport, new SCPageController[1]);
        this._group = serverGroupSO;
        this._page = new ExportServerGroupsPage(sCDialogSupport, new ExportServerGroupsDlgGOPage());
        this._pageControllers[0] = this._page;
    }

    public boolean render() {
        return this._dialogSupport.render();
    }

    public String getFileName() {
        return this._page.getFileName();
    }

    public boolean exportPassword() {
        return this._page.exportPassword();
    }

    class ExportServerGroupsPage
    extends ASEPageController
    implements DocumentListener {
        private ExportServerGroupsDlgGOPage _go;

        ExportServerGroupsPage(SCDialogSupport sCDialogSupport, ExportServerGroupsDlgGOPage exportServerGroupsDlgGOPage) {
            super(sCDialogSupport, (JPanel)((Object)exportServerGroupsDlgGOPage));
            this._go = exportServerGroupsDlgGOPage;
            this._init();
        }

        @Override
        public String getHelpID() {
            return "HELP_EXPORT_GROUPS_DLG_15";
        }

        private void _init() {
            File file = Support.getInitDirectory(null);
            if (file == null) {
                file = ASEProvider.getSybaseOrSybrootDir();
            }
            if (file != null) {
                String string = ExportServerGroupsDialog.this._group == null ? "ServerGroups" : ExportServerGroupsDialog.this._group.getName();
                String string2 = ".xml";
                String string3 = "";
                string3 = file.isDirectory() ? file.getAbsolutePath() : file.getParent();
                String string4 = ASEUtils.buildFullPathName(string3, string + string2);
                if (ASEUtils.isExistingFile(string4)) {
                    for (int i = 1; i < 999 && ASEUtils.isExistingFile(string4 = ASEUtils.buildFullPathName(string3, string + i + string2)); ++i) {
                    }
                }
                this._go.exportFileNameEditor.setFileName(string4);
            }
            this._go.exportPasswordCheckBox.setSelected(true);
            this._go.exportFileNameEditor.addDocumentListener(this);
        }

        @Override
        public void init() {
            this._go.exportFileNameEditor.setParentWindow(this.getJDialog());
        }

        @Override
        public void enableComponents() {
            String string = this.getFileName();
            boolean bl = string != null && string.length() > 0 && !ASEUtils.isExistingDirectory(string);
            this.enableOkButton(bl);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        String getFileName() {
            return this._go.exportFileNameEditor.getFileName();
        }

        boolean exportPassword() {
            return this._go.exportPasswordCheckBox.isSelected();
        }

        public boolean onOk() {
            String string = this.getFileName();
            if (ASEUtils.isExistingFile(string)) {
                boolean bl;
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_FILE_EXIST_CONTINUE"), ASEUtils.getFileFromPath(string));
                boolean bl2 = bl = Support.showQuestionYesNo(this.getJDialog(), aSEMessageText.toString()) == 0;
                if (!bl) {
                    return true;
                }
            }
            return this.doExport();
        }

        private boolean doExport() {
            try {
                String string = this.getFileName();
                if (this.exportPassword()) {
                    ServerGroupSO.export(string, ExportServerGroupsDialog.this._group);
                } else {
                    ServerGroupSO.safeExport(string, ExportServerGroupsDialog.this._group);
                }
                return true;
            }
            catch (Exception exception) {
                Support.showDetailsError(null, this.getClass(), (Container)this.getJDialog(), exception.getMessage(), exception);
                if (exception instanceof IOException) {
                    this._go.exportFileNameEditor.selectAll();
                }
                return false;
            }
        }
    }
}

