/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.go.dlg.JobSchedulerAdminDlgGOPage1;
import com.sybase.aseplugin.so.JobSchedulerAdminSO;
import com.sybase.central.SCDialogSupport;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class JobSchedulerAdminDialogBOPage1
extends ASEPageController
implements ActionListener,
DocumentListener,
Runnable {
    private JobSchedulerAdminSO _so;
    private JobSchedulerAdminDlgGOPage1 _go;
    private boolean _readState = true;
    private boolean _readConfig = true;
    private boolean _updateInProgress;
    private boolean _updateEnabled;
    private boolean _updateInterval;
    private boolean _updateThreads;
    private boolean _updateMaxOutput;

    public JobSchedulerAdminDialogBOPage1(SCDialogSupport sCDialogSupport, JobSchedulerAdminDlgGOPage1 jobSchedulerAdminDlgGOPage1, JobSchedulerAdminSO jobSchedulerAdminSO) {
        super(sCDialogSupport, (JPanel)((Object)jobSchedulerAdminDlgGOPage1), ASEUtils.getString("MSG_JS_ADMIN_DLG_PAGE1"));
        this._so = jobSchedulerAdminSO;
        this._go = jobSchedulerAdminDlgGOPage1;
        this._go.setDisplayPreviewButton(false);
        this._go.setDisplayScheduleButton(false);
        this._go.setVisiblePreviewButton(false);
        this._go.setVisibleScheduleButton(false);
        this._go.startButton.addActionListener((ActionListener)this);
        this._go.stopButton.addActionListener((ActionListener)this);
        this._go.terminateCheckBox.addActionListener((ActionListener)this);
        this._go.enableAtBootCheckBox.addActionListener((ActionListener)this);
        this._go.timeoutTextField.getDocument().addDocumentListener(this);
        this._go.intervalTextField.getDocument().addDocumentListener(this);
        this._go.threadsTextField.getDocument().addDocumentListener(this);
        this._go.outputTextField.getDocument().addDocumentListener(this);
    }

    @Override
    public String getHelpID() {
        return "HELP_SJ_DLG_TASK_CONFIGURATION_1252";
    }

    @Override
    public boolean onSetActive() {
        this._readState = true;
        this._readConfig = true;
        SwingUtilities.invokeLater(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onOk() {
        int n;
        int n2;
        int n3;
        try {
            n3 = Integer.parseInt(this._go.intervalTextField.getText());
            n2 = Integer.parseInt(this._go.threadsTextField.getText());
            n = Integer.parseInt(this._go.outputTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            Support.showDetailsError(this._so.getConnection(), this.getClass(), (Container)this.getJDialog(), numberFormatException.getMessage(), numberFormatException);
            return false;
        }
        try {
            if (this._updateInterval) {
                this._so.setInterval(n3);
            }
            if (this._updateThreads) {
                this._so.setThreads(n2);
            }
            if (this._updateMaxOutput) {
                this._so.setMaxOutputSize(n);
            }
            if (this._updateEnabled) {
                this._so.setEnableAtBoot(this._go.enableAtBootCheckBox.isSelected());
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this._so.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
        }
        finally {
            this._updateEnabled = false;
            this._updateInterval = false;
            this._updateThreads = false;
            this._updateMaxOutput = false;
        }
        return true;
    }

    @Override
    public void run() {
        this._updateInProgress = true;
        if (this._readState) {
            this.updateTaskState();
        }
        if (this._readConfig) {
            this.updateConfigParams();
        }
        this._updateInProgress = false;
    }

    private void updateConfigParams() {
        try {
            this._go.enableAtBootCheckBox.setSelected(this._so.isEnableAtBoot());
            this._go.intervalTextField.setText(String.valueOf(this._so.getInterval()));
            this._go.threadsTextField.setText(String.valueOf(this._so.getThreads()));
            this._go.outputTextField.setText(String.valueOf(this._so.getMaxOutputSize()));
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this._so.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
        }
    }

    private void updateTaskState() {
        boolean bl;
        try {
            bl = this._so.isTaskRunning();
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this._so.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            this._go.taskStateLabel.setText(ASEUtils.getString("MSG_UNKNOWN"));
            this._go.startButton.setEnabled(false);
            this._go.stopButton.setEnabled(false);
            this._go.terminateCheckBox.setEnabled(false);
            this._go.afterLabel.setEnabled(false);
            this._go.timeoutTextField.setEnabled(false);
            this._go.secondsLabel.setEnabled(false);
            return;
        }
        if (bl) {
            this._go.taskStateLabel.setText(ASEUtils.getString("MSG_RUNNING"));
            this._go.startButton.setEnabled(false);
            this._go.stopButton.setEnabled(true);
            this._go.terminateCheckBox.setEnabled(true);
            boolean bl2 = this._go.terminateCheckBox.isSelected();
            this._go.afterLabel.setEnabled(bl2);
            this._go.timeoutTextField.setEnabled(bl2);
            this._go.secondsLabel.setEnabled(bl2);
        } else {
            this._go.taskStateLabel.setText(ASEUtils.getString("MSG_STOPPED"));
            this._go.startButton.setEnabled(true);
            this._go.stopButton.setEnabled(false);
            this._go.terminateCheckBox.setEnabled(false);
            this._go.afterLabel.setEnabled(false);
            this._go.timeoutTextField.setEnabled(false);
            this._go.secondsLabel.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._go.startButton) {
            try {
                this._so.startTask();
                this._readState = true;
                this._readConfig = false;
                SwingUtilities.invokeLater(this);
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this._so.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            }
        } else if (actionEvent.getSource() == this._go.stopButton) {
            try {
                if (this._go.terminateCheckBox.isSelected()) {
                    int n;
                    try {
                        n = Integer.parseInt(this._go.timeoutTextField.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 0;
                    }
                    this._so.terminateTask(n);
                }
                this._so.stopTask();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this._so.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            }
            finally {
                this._readState = true;
                this._readConfig = false;
                SwingUtilities.invokeLater(this);
            }
        } else if (actionEvent.getSource() == this._go.terminateCheckBox) {
            boolean bl = this._go.terminateCheckBox.isSelected();
            this._go.afterLabel.setEnabled(bl);
            this._go.timeoutTextField.setEnabled(bl);
            this._go.secondsLabel.setEnabled(bl);
        } else if (actionEvent.getSource() == this._go.enableAtBootCheckBox && !this._updateInProgress) {
            this._updateEnabled = true;
            this.enableApplyButton(true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.textValueChanged(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.textValueChanged(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.textValueChanged(documentEvent);
    }

    public void textValueChanged(DocumentEvent documentEvent) {
        if (!this._updateInProgress) {
            boolean bl = true;
            if (documentEvent.getDocument() == this._go.intervalTextField.getDocument()) {
                this._updateInterval = true;
            } else if (documentEvent.getDocument() == this._go.threadsTextField.getDocument()) {
                this._updateThreads = true;
            } else if (documentEvent.getDocument() == this._go.outputTextField.getDocument()) {
                this._updateMaxOutput = true;
            } else {
                bl = false;
            }
            this.enableApplyButton(bl);
        }
    }

    public void enableApplyButton(boolean bl) {
        this._dialogSupport.getStandardButtonById(4).setEnabled(bl);
    }
}

