/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEDialogController;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.go.dlg.KeyRecoveryDlgGOPage;
import com.sybase.aseplugin.so.KeyCopySO;
import com.sybase.aseplugin.so.KeySO;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import java.sql.SQLException;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class KeyRecoveryDialog
extends ASEDialogController {
    private boolean _closeState = false;
    public static final boolean CLOSE_STATE_CANCEL = false;
    public static final boolean CLOSE_STATE_OK = true;
    int minPasswordLength;

    public KeyRecoveryDialog(SCDialogSupport sCDialogSupport, KeyCopySO keyCopySO, int n) {
        super(sCDialogSupport, new SCPageController[1]);
        this._pageControllers[0] = new KeyRecoveryDialogBOPage(sCDialogSupport, this, keyCopySO, n);
        this.minPasswordLength = n;
        sCDialogSupport.setDialogController((SCDialogController)this);
        sCDialogSupport.setTitle(ASEUtils.getString("KEY_RECOVERY_FOR") + ASEUtils.getString("MSG_ENCRYPTION_KEY_TYPE") + " " + keyCopySO.getFullyQualifiedName());
        sCDialogSupport.setResizable(true);
        sCDialogSupport.setModal(true);
    }

    public boolean getCloseState() {
        return this._closeState;
    }

    class KeyRecoveryDialogBOPage
    extends ASEPageController
    implements DocumentListener {
        private KeyRecoveryDlgGOPage _go;
        private KeySO _ekso;
        int _minLength;

        public KeyRecoveryDialogBOPage(SCDialogSupport sCDialogSupport, KeyRecoveryDialog keyRecoveryDialog2, KeySO keySO, int n) {
            super(sCDialogSupport, (JPanel)((Object)new KeyRecoveryDlgGOPage(n)));
            this._go = (KeyRecoveryDlgGOPage)((Object)this.getJPanel());
            this._ekso = keySO;
            this._minLength = n;
        }

        @Override
        public String getHelpID() {
            return "HELP_EK_DLG_KEY_RECOVERY_1502";
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void init() throws SQLException {
            if (this.IsPasswordPreSupplied()) {
                this._go.oldPasswordPanel.setVisible(false);
            }
            this._go.oldPasswordField.getDocument().addDocumentListener(this);
            this._go.newPasswordField.getDocument().addDocumentListener(this);
            this._go.confirmPasswordField.getDocument().addDocumentListener(this);
            this.resizeDlg();
        }

        public boolean IsPasswordPreSupplied() {
            return false;
        }

        public void resizeDlg() {
            if (this.getJDialog() != null) {
                int n = this.getJDialog().getSize().width;
                this.getJDialog().setSize(n, this.getJDialog().getPreferredSize().height);
                this.getJDialog().show();
            }
        }

        @Override
        public void enableComponents() {
            String string = new String(this._go.newPasswordField.getPassword()).trim();
            String string2 = new String(this._go.confirmPasswordField.getPassword()).trim();
            if (string.length() < KeyRecoveryDialog.this.minPasswordLength || string2.length() < KeyRecoveryDialog.this.minPasswordLength || !string.equals(string2)) {
                this.enableOkButton(false);
            } else {
                this.enableOkButton(true);
            }
        }

        public boolean onCancel() {
            KeyRecoveryDialog.this._closeState = false;
            return super.onCancel();
        }

        public boolean onOk() {
            try {
                String string = SQLs.getString("alter encryption key {0} with passwd ''{1}'' recover encryption with passwd ''{2}''", this._ekso.getFullyQualifiedName(), new String(this._go.oldPasswordField.getPassword()), new String(this._go.newPasswordField.getPassword()));
                this._ekso.useDB();
                this._ekso.getConnection().executeCommand(string);
                KeyRecoveryDialog.this._closeState = true;
                return true;
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this._ekso.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                return false;
            }
        }
    }
}

