/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.bo.dlg.LoadProfilePreviewDialog;
import com.sybase.aseplugin.go.dlg.LoadProfilePreviewDlgGOPage;
import com.sybase.aseplugin.so.SDCInstanceSO;
import com.sybase.aseplugin.so.SDCLogicalClusterSO;
import com.sybase.aseplugin.so.WorkloadPreviewsCtrSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.central.SCDialogSupport;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

class LoadProfilePreviewDialogBOPage
extends ASEPageController
implements ActionListener {
    public static final int WRKLD_SCORES_PREVIEW_NDX = 0;
    public static final int WRKLD_METRICS_PREVIEW_NDX = 1;
    private SCDialogSupport diagSupport;
    private LoadProfilePreviewDlgGOPage goPage;
    private String lcName;
    private Collection lcInstanceSOs;
    private String lpName;
    private ASConnection connection;
    private Vector lpNames;
    private boolean isPreview = false;
    SDCLogicalClusterSO lcSO;

    public LoadProfilePreviewDialogBOPage(SCDialogSupport sCDialogSupport, String string, Collection collection, String string2, ASConnection aSConnection, Vector vector) {
        super(sCDialogSupport, (JPanel)((Object)new LoadProfilePreviewDlgGOPage()));
        this.diagSupport = sCDialogSupport;
        this.goPage = (LoadProfilePreviewDlgGOPage)((Object)this.getJPanel());
        this.lcName = string;
        this.lcInstanceSOs = collection;
        this.lpName = string2;
        this.connection = aSConnection;
        this.lpNames = vector;
    }

    @Override
    public void init() {
        Serializable serializable;
        LoadProfilePreviewDialog.selectedProfileName = "";
        this.diagSupport.getStandardButtonById(1).setEnabled(true);
        Vector vector = this.getLoadProfileTableData(this.lpName, this.connection);
        if (vector == null) {
            return;
        }
        if (this.lpNames != null) {
            this.isPreview = true;
            this.goPage.loadLoadProfileList(this.lpNames);
            this.goPage.selectLoadProfile(this.lpName);
        } else {
            serializable = new ASEMessageText(ASEUtils.getString("DISP_SDC_LOAD_PROFILE_NAME"), this.lpName);
            this.goPage.setLoadProfileLabel(((ASEMessageText)serializable).toString());
        }
        this.goPage.setPreviewMode(this.isPreview);
        this.goPage.loadScoresTable((Vector)vector.get(0));
        this.goPage.loadRawTable((Vector)vector.get(1));
        serializable = this.diagSupport.getStandardButtonById(2);
        ((AbstractButton)serializable).setLabel(ASEUtils.getString("DISP_CLOSE_TEXT"));
        ((AbstractButton)serializable).setMnemonic(Support.getMnemonic("DISP_MNEM_CLOSE"));
        this.diagSupport.getStandardButtonById(1).setVisible(false);
        this.goPage.setListeners(this);
    }

    private Vector getInstanceIds() {
        Vector<String> vector = new Vector<String>();
        if (this.lcInstanceSOs != null) {
            Iterator iterator = this.lcInstanceSOs.iterator();
            while (iterator.hasNext()) {
                vector.add(((SDCInstanceSO)iterator.next()).getId());
            }
        }
        return vector;
    }

    private Vector getLoadProfileTableData(String string, ASConnection aSConnection) {
        WorkloadPreviewsCtrSO workloadPreviewsCtrSO = new WorkloadPreviewsCtrSO(aSConnection);
        Vector vector = null;
        try {
            if (this.lcInstanceSOs != null) {
                Vector vector2 = this.getInstanceIds();
                vector = workloadPreviewsCtrSO.getWorkloadPreviewTableData(vector2, string);
            } else {
                vector = workloadPreviewsCtrSO.getWorkloadPreviewTableData(this.lcName, string);
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(aSConnection, this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            return vector;
        }
        return vector;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.goPage.getProfileCombo()) {
            Vector vector = this.getLoadProfileTableData(this.goPage.getSelectedProfileName(), this.connection);
            this.goPage.setScoresLabel();
            this.goPage.loadScoresTable((Vector)vector.get(0));
            this.goPage.loadRawTable((Vector)vector.get(1));
        }
    }

    @Override
    public String getHelpID() {
        if (this.isPreview) {
            return "HELP_LOAD_PROFILE_PREVIEW_DIALOG_1501CE";
        }
        return "HELP_LC_WORKLOAD_DIALOG_1501CE";
    }
}

