/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.asa.ASASpinBoxChangeEvent;
import com.sybase.asa.ASASpinBoxChangeListener;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.ProfileHelper;
import com.sybase.aseplugin.bo.SDCInstanceBO;
import com.sybase.aseplugin.bo.SQLTracer;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEDialogController;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.go.dlg.LogSqlStatementsDlgGOPage;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LogSqlStatementsDialog
extends ASEDialogController {
    private ServerBO _serverBO;
    private LogSqlStatementsDialogBOPage _page;

    public static int showDialog(Container container, ServerBO serverBO) {
        SCDialogSupport sCDialogSupport = Support.createDialogSupport(container);
        LogSqlStatementsDialog logSqlStatementsDialog = new LogSqlStatementsDialog(sCDialogSupport, serverBO);
        sCDialogSupport.setDialogController((SCDialogController)logSqlStatementsDialog);
        sCDialogSupport.setTitle(ASEUtils.getString("LOG_SQL_DLG_TITLE"));
        sCDialogSupport.setResizable(true);
        sCDialogSupport.setModal(true);
        boolean bl = sCDialogSupport.render();
        if (bl) {
            return logSqlStatementsDialog.getTraceType();
        }
        return 0;
    }

    LogSqlStatementsDialog(SCDialogSupport sCDialogSupport, ServerBO serverBO) {
        super(sCDialogSupport, new SCPageController[1]);
        this._serverBO = serverBO;
        this._page = new LogSqlStatementsDialogBOPage(sCDialogSupport, new LogSqlStatementsDlgGOPage());
        this._pageControllers[0] = this._page;
    }

    public int getTraceType() {
        return this._page.getTraceType();
    }

    class LogSqlStatementsDialogBOPage
    extends ASEPageController
    implements ItemListener,
    DocumentListener,
    ASASpinBoxChangeListener {
        private LogSqlStatementsDlgGOPage _go;
        private int _traceType;

        LogSqlStatementsDialogBOPage(SCDialogSupport sCDialogSupport, LogSqlStatementsDlgGOPage logSqlStatementsDlgGOPage) {
            super(sCDialogSupport, (JPanel)((Object)logSqlStatementsDlgGOPage));
            this._go = logSqlStatementsDlgGOPage;
            this._init();
        }

        @Override
        public String getHelpID() {
            return "HELP_SERVER_DLG_LOG_SQL_STATEMENTS_1252";
        }

        private void _init() {
            this._go.serverNameTextLabel.setText(LogSqlStatementsDialog.this._serverBO.getSO().getDisplayName());
            String string = ProfileHelper.getPreference("LogSqlTarget");
            if (string == null || string.length() == 0) {
                this._go.logToWindowRadioButton.setSelected(true);
            } else {
                this._go.logToFileRadioButton.setSelected(true);
                this._go.logFileNameEditor.setFileName(string);
            }
            String string2 = ProfileHelper.getPreference("LogSqlWrapText");
            if (string2 == null) {
                this._go.wrapTextSpinBox.setValue(80);
                this._go.wrapTextCheckBox.setSelected(true);
            } else {
                int n = 0;
                try {
                    n = Integer.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n > 0) {
                    this._go.wrapTextSpinBox.setValue(n);
                    this._go.wrapTextCheckBox.setSelected(true);
                } else {
                    this._go.wrapTextCheckBox.setSelected(false);
                    this._go.wrapTextSpinBox.setEnabled(false);
                }
            }
            String string3 = ProfileHelper.getPreference("LogSqlDateTime");
            if (string3 == null) {
                this._go.addDateAndTimeCheckBox.setSelected(false);
            } else {
                boolean bl = Boolean.valueOf(string3);
                this._go.addDateAndTimeCheckBox.setSelected(bl);
            }
            String string4 = ProfileHelper.getPreference("LogSqlAppendGo");
            if (string4 == null) {
                this._go.appendGoCheckBox.setSelected(false);
            } else {
                boolean bl = Boolean.valueOf(string4);
                this._go.appendGoCheckBox.setSelected(bl);
            }
            String string5 = ProfileHelper.getPreference("LogSqlNoSelect");
            if (string5 == null) {
                this._go.noSelectCheckBox.setSelected(false);
            } else {
                boolean bl = Boolean.valueOf(string5);
                this._go.noSelectCheckBox.setSelected(bl);
            }
            String string6 = ProfileHelper.getPreference("LogSqlLogOutput");
            if (string6 == null) {
                this._go.logOutputCheckBox.setSelected(false);
            } else {
                boolean bl = Boolean.valueOf(string6);
                this._go.logOutputCheckBox.setSelected(bl);
            }
            this._go.rowNumberCheckBox.setEnabled(this._go.logOutputCheckBox.isSelected());
            String string7 = ProfileHelper.getPreference("LogSqlShowRowNumbers");
            if (string7 == null) {
                this._go.rowNumberCheckBox.setSelected(false);
            } else {
                boolean bl = Boolean.valueOf(string7);
                this._go.rowNumberCheckBox.setSelected(bl);
            }
            this._go.logToWindowRadioButton.addItemListener((ItemListener)this);
            this._go.logToFileRadioButton.addItemListener((ItemListener)this);
            this._go.logFileNameEditor.addDocumentListener(this);
            this._go.wrapTextCheckBox.addItemListener((ItemListener)this);
            this._go.wrapTextSpinBox.addSpinBoxChangeListener(this);
            this._go.logOutputCheckBox.addItemListener((ItemListener)this);
            this._go.appendGoCheckBox.addItemListener((ItemListener)this);
            this._go.rowNumberCheckBox.addItemListener((ItemListener)this);
        }

        @Override
        public void init() {
            this._go.logFileNameEditor.setParentWindow(this.getJDialog());
        }

        @Override
        public void enableComponents() {
            boolean bl = this._go.logToFileRadioButton.isSelected();
            boolean bl2 = this._go.wrapTextCheckBox.isSelected();
            this._go.logFileNameLabel.setEnabled(bl);
            this._go.logFileNameEditor.setEnabled(bl);
            this._go.wrapTextSpinBox.setEnabled(bl2);
            this._go.charactersLabel.setEnabled(bl2);
            this._go.rowNumberCheckBox.setEnabled(this._go.logOutputCheckBox.isSelected());
            boolean bl3 = bl && this._go.logFileNameEditor.getFileName().trim().length() == 0 || bl2 && this._go.wrapTextSpinBox.getValue() == 0;
            this.enableOkButton(!bl3);
        }

        public int getTraceType() {
            return this._traceType;
        }

        private boolean startLogging() {
            File file;
            File file2;
            this._traceType = this._go.logToWindowRadioButton.isSelected() ? 1 : 2;
            String string = this._go.logFileNameEditor.getFileName().trim();
            if (!(this._traceType != 2 || (file2 = (file = new File(string)).getParentFile()) != null && file2.exists() && file2.isDirectory())) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_FILE_NOT_VALID"), string);
                Support.showError(LogSqlStatementsDialog.this._serverBO.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                this._go.logFileNameEditor.selectAll();
                return false;
            }
            int n = this._go.wrapTextCheckBox.isSelected() ? this._go.wrapTextSpinBox.getValue() : 9999;
            boolean bl = this._go.addDateAndTimeCheckBox.isSelected();
            boolean bl2 = !this._go.noSelectCheckBox.isSelected();
            boolean bl3 = this._go.logOutputCheckBox.isSelected();
            boolean bl4 = this._go.appendGoCheckBox.isSelected();
            boolean bl5 = this._go.rowNumberCheckBox.isSelected();
            JFrame jFrame = (JFrame)this._dialogSupport.getJDialog().getParent();
            SQLTracer sQLTracer = new SQLTracer(this._traceType, LogSqlStatementsDialog.this._serverBO, string, n, bl2, bl3, bl, bl4, bl5, jFrame);
            try {
                sQLTracer.init();
            }
            catch (IOException iOException) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_WRITING_FILE"), string);
                Support.showDetailsError(LogSqlStatementsDialog.this._serverBO.getConnection(), this.getClass(), (Container)this.getJDialog(), aSEMessageText.toString(), iOException);
                return false;
            }
            ServerSO serverSO = (ServerSO)LogSqlStatementsDialog.this._serverBO.getSO();
            serverSO.getConnection().setSQLListener(sQLTracer);
            if (LogSqlStatementsDialog.this._serverBO.isCluster()) {
                Vector vector = LogSqlStatementsDialog.this._serverBO.getSDCInstanceBOs();
                for (int i = 0; i < vector.size(); ++i) {
                    SDCInstanceBO sDCInstanceBO = (SDCInstanceBO)vector.get(i);
                    if (sDCInstanceBO.getConnection() == null) continue;
                    SQLTracer sQLTracer2 = new SQLTracer(this._traceType, sDCInstanceBO, string, n, bl2, bl3, bl, bl4, bl5, jFrame);
                    try {
                        sQLTracer2.setTitle(sQLTracer.getTitle());
                        sQLTracer2.init();
                    }
                    catch (IOException iOException) {
                        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_WRITING_FILE"), string);
                        Support.showDetailsError(sDCInstanceBO.getConnection(), this.getClass(), (Container)this.getJDialog(), aSEMessageText.toString(), iOException);
                        return false;
                    }
                    sDCInstanceBO.getConnection().setSQLListener(sQLTracer2);
                }
            }
            if (this._traceType == 2) {
                ProfileHelper.setPreference("LogSqlTarget", string);
            } else {
                ProfileHelper.setPreference("LogSqlTarget", "");
            }
            if (this._go.wrapTextCheckBox.isSelected()) {
                ProfileHelper.setPreference("LogSqlWrapText", String.valueOf(n));
            } else {
                ProfileHelper.setPreference("LogSqlWrapText", "0");
            }
            ProfileHelper.setPreference("LogSqlDateTime", String.valueOf(bl));
            ProfileHelper.setPreference("LogSqlAppendGo", String.valueOf(bl4));
            ProfileHelper.setPreference("LogSqlNoSelect", String.valueOf(!bl2));
            ProfileHelper.setPreference("LogSqlLogOutput", String.valueOf(bl3));
            return true;
        }

        public boolean onOk() {
            return this.startLogging();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == this._go.logToFileRadioButton) {
                this._go.logFileNameEditor.selectAll();
            }
            this.enableComponents();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        public void valueChanged(ASASpinBoxChangeEvent aSASpinBoxChangeEvent) {
            this.enableComponents();
        }
    }
}

