/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEDialogController;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.go.dlg.PrepareKeyRecoveryDlgGOPage;
import com.sybase.aseplugin.so.KeyCopySO;
import com.sybase.aseplugin.so.KeySO;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import java.sql.SQLException;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PrepareKeyRecoveryDialog
extends ASEDialogController {
    private boolean _closeState = false;
    public static final boolean CLOSE_STATE_CANCEL = false;
    public static final boolean CLOSE_STATE_OK = true;

    public PrepareKeyRecoveryDialog(SCDialogSupport sCDialogSupport, KeyCopySO keyCopySO) {
        super(sCDialogSupport, new SCPageController[1]);
        this._pageControllers[0] = new PrepareKeyRecoveryDialogBOPage(sCDialogSupport, this, keyCopySO);
        sCDialogSupport.setDialogController((SCDialogController)this);
        sCDialogSupport.setTitle(ASEUtils.getString("INPUT_RECOVERY_KEY_PASSWORD_FOR") + ASEUtils.getString("MSG_ENCRYPTION_KEY_TYPE") + " " + keyCopySO.getFullyQualifiedName());
        sCDialogSupport.setResizable(true);
        sCDialogSupport.setModal(true);
    }

    public boolean getCloseState() {
        return this._closeState;
    }

    class PrepareKeyRecoveryDialogBOPage
    extends ASEPageController
    implements DocumentListener {
        private PrepareKeyRecoveryDlgGOPage _go;
        private KeySO _ekso;
        int _minLength;

        public PrepareKeyRecoveryDialogBOPage(SCDialogSupport sCDialogSupport, PrepareKeyRecoveryDialog prepareKeyRecoveryDialog2, KeySO keySO) {
            super(sCDialogSupport, (JPanel)((Object)new PrepareKeyRecoveryDlgGOPage()));
            this._go = (PrepareKeyRecoveryDlgGOPage)((Object)this.getJPanel());
            this._ekso = keySO;
        }

        @Override
        public String getHelpID() {
            return "HELP_EK_DLG_PREPARE_RECOVERY_KEY_PASSWORD_1502";
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void init() throws SQLException {
            this._go.passwordField.getDocument().addDocumentListener(this);
        }

        @Override
        public void enableComponents() {
            this.enableOkButton(true);
        }

        public boolean onCancel() {
            PrepareKeyRecoveryDialog.this._closeState = false;
            return super.onCancel();
        }

        public boolean onOk() {
            try {
                String string = SQLs.getString("alter encryption key {0} prepare recovery with passwd ''{1}''", this._ekso.getFullyQualifiedName(), new String(this._go.passwordField.getPassword()));
                this._ekso.useDB();
                this._ekso.getConnection().executeCommand(string);
                PrepareKeyRecoveryDialog.this._closeState = true;
                return true;
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this._ekso.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                return false;
            }
        }
    }
}

